/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Downstream;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Intron;
import org.snpeff.interval.MarkerParentId;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Upstream;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantNonRef;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.serializer.TxtSerializable;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Gpr;

public class Marker
extends Interval
implements TxtSerializable {
    private static final long serialVersionUID = 7878886900660027549L;
    protected EffectType type = EffectType.NONE;

    protected Marker() {
        this.type = EffectType.NONE;
    }

    public Marker(Marker parent, int start, int end) {
        this(parent, start, end, false, "");
    }

    public Marker(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        if (parent != null && !parent.includes(this)) {
            String err2 = "";
            if (this.isShowWarningIfParentDoesNotInclude()) {
                err2 = "WARNING: " + this.getClass().getSimpleName() + " is not included in parent " + parent.getClass().getSimpleName() + ". \t" + this.getClass().getSimpleName() + " '" + this.getId() + "'  [ " + this.getStart() + " , " + this.getEnd() + " ]\t" + parent.getClass().getSimpleName() + " '" + parent.getId() + "' [ " + parent.getStart() + " , " + parent.getEnd() + " ]";
            }
            if (this.isAdjustIfParentDoesNotInclude(parent)) {
                parent.adjust(this);
                if (this.isShowWarningIfParentDoesNotInclude()) {
                    err2 = err2 + "\t=> Adjusting " + parent.getClass().getSimpleName() + " '" + parent.getId() + "' to [ " + parent.getStart() + " , " + parent.getEnd() + " ]";
                }
            }
            if (this.isShowWarningIfParentDoesNotInclude()) {
                System.err.println(err2);
            }
        }
    }

    protected void adjust(Marker child) {
        this.start = Math.min(this.start, child.getStart());
        this.end = Math.max(this.end, child.getEnd());
    }

    public Marker apply(Variant variant) {
        if (!this.shouldApply(variant)) {
            return this;
        }
        Marker newMarker = null;
        switch (variant.getVariantType()) {
            case SNP: 
            case MNP: {
                newMarker = this;
                break;
            }
            case INS: {
                newMarker = this.applyIns(variant);
                break;
            }
            case DEL: {
                newMarker = this.applyDel(variant);
                break;
            }
            case DUP: {
                newMarker = this.applyDup(variant);
                break;
            }
            case MIXED: {
                newMarker = this.applyMixed(variant);
                break;
            }
            default: {
                throw new RuntimeException("Variant type not supported: " + (Object)((Object)variant.getVariantType()) + "\n\t" + variant);
            }
        }
        if (newMarker == this) {
            return this.cloneShallow();
        }
        return newMarker;
    }

    protected Marker applyDel(Variant variant) {
        Marker m = this.cloneShallow();
        if (variant.getEnd() < m.start) {
            int lenChange = variant.lengthChange();
            m.start += lenChange;
            m.end += lenChange;
        } else {
            if (variant.includes(m)) {
                return null;
            }
            if (m.includes(variant)) {
                m.end += variant.lengthChange();
            } else {
                if (m.end < variant.getEnd()) {
                    // empty if block
                }
                int istart = Math.max(variant.getStart(), m.start);
                int iend = Math.min(variant.getEnd(), m.end);
                if (iend < istart) {
                    throw new RuntimeException("This should never happen!");
                }
                m.end -= iend - istart + 1;
                if (variant.getStart() < m.start) {
                    int delta = m.start - variant.getStart();
                    m.start -= delta;
                    m.end -= delta;
                }
            }
        }
        return m;
    }

    protected Marker applyDup(Variant variant) {
        Marker m = this.cloneShallow();
        if (variant.getEnd() < m.start) {
            int lenChange = variant.lengthChange();
            m.start += lenChange;
            m.end += lenChange;
        } else if (variant.includes(m)) {
            int lenChange = variant.lengthChange();
            m.start += lenChange;
            m.end += lenChange;
        } else if (m.includes(variant)) {
            m.end += variant.lengthChange();
        } else if (variant.intersects(m)) {
            m.end += variant.intersect(m).size();
        }
        return m;
    }

    protected Marker applyIns(Variant variant) {
        Marker m = this.cloneShallow();
        if (variant.getStart() < m.start) {
            int lenChange = variant.lengthChange();
            m.start += lenChange;
            m.end += lenChange;
        } else if (variant.getStart() <= m.end) {
            m.end += variant.lengthChange();
        }
        return m;
    }

    protected Marker applyMixed(Variant variant) {
        Variant[] variants = variant.decompose();
        Marker m = this;
        for (Variant var : variants) {
            if ((m = m.apply(var)) != null) continue;
            return null;
        }
        return m;
    }

    @Override
    public Marker clone() {
        return (Marker)super.clone();
    }

    public Marker cloneShallow() {
        try {
            Constructor<?> ctor = this.getClass().getConstructor(new Class[0]);
            Marker clone2 = (Marker)ctor.newInstance(new Object[0]);
            clone2.chromosomeNameOri = this.chromosomeNameOri;
            clone2.end = this.end;
            clone2.id = this.id;
            clone2.parent = this.parent;
            clone2.start = this.start;
            clone2.strandMinus = this.strandMinus;
            clone2.type = this.type;
            return clone2;
        }
        catch (Exception e) {
            throw new RuntimeException("Error performing shallow clone: ", e);
        }
    }

    public CodonTable codonTable() {
        return CodonTables.getInstance().getTable(this.getGenome(), this.getChromosomeName());
    }

    @Override
    public int compareTo(Interval i2) {
        int comp = this.compareToPos(i2);
        if (comp != 0) {
            return comp;
        }
        if (this.id == null && i2.getId() == null) {
            return 0;
        }
        if (this.id != null && i2.getId() == null) {
            return -1;
        }
        if (this.id == null && i2.getId() != null) {
            return 1;
        }
        return this.id.compareTo(i2.getId());
    }

    public int compareToPos(Interval i2) {
        Marker m2 = (Marker)i2;
        Chromosome chr1 = this.getChromosome();
        Chromosome chr2 = m2.getChromosome();
        if (chr1 != null && chr2 != null) {
            int compChromo = chr1.compareChromoName(chr2);
            if (compChromo != 0) {
                return compChromo;
            }
        } else {
            if (chr1 == null && chr2 != null) {
                return 1;
            }
            if (chr1 != null && chr2 == null) {
                return -1;
            }
        }
        if (this.start > i2.start) {
            return 1;
        }
        if (this.start < i2.start) {
            return -1;
        }
        if (this.end > i2.end) {
            return 1;
        }
        if (this.end < i2.end) {
            return -1;
        }
        return 0;
    }

    public int distance(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return -1;
        }
        if (this.intersects(interval)) {
            return 0;
        }
        if (this.start > interval.getEnd()) {
            return this.start - interval.getEnd();
        }
        if (interval.getStart() > this.end) {
            return interval.getStart() - this.end;
        }
        throw new RuntimeException("This should never happen!");
    }

    public int distanceBases(List<? extends Marker> markers, boolean fromEnd) {
        ArrayList<? extends Marker> markersSort = new ArrayList<Marker>();
        markersSort.addAll(markers);
        if (fromEnd) {
            Collections.sort(markersSort, new IntervalComparatorByEnd(true));
        } else {
            Collections.sort(markersSort, new IntervalComparatorByStart());
        }
        int len = 0;
        int latest = -1;
        for (Marker marker : markersSort) {
            if (latest < 0) {
                latest = fromEnd ? marker.getEnd() + 1 : marker.getStart() - 1;
            }
            if (fromEnd) {
                if (this.intersects(marker)) {
                    return len + (marker.getEnd() - this.start);
                }
                if (this.start > marker.getEnd()) {
                    return len - 1 + (latest - this.start);
                }
                latest = marker.getStart();
            } else {
                if (this.intersects(marker)) {
                    return len + (this.start - marker.getStart());
                }
                if (this.start < marker.getStart()) {
                    return len - 1 + (this.start - latest);
                }
                latest = marker.getEnd();
            }
            len += marker.size();
        }
        if (fromEnd) {
            return len - 1 + (latest - this.start);
        }
        return len - 1 + (this.start - latest);
    }

    @Override
    public Marker getParent() {
        return (Marker)this.parent;
    }

    public EffectType getType() {
        return this.type;
    }

    public String idChain() {
        return this.idChain(";", ":", true);
    }

    public String idChain(String separatorBetween, String separatorWithin, boolean useGeneId) {
        return this.idChain(separatorBetween, separatorWithin, useGeneId, null);
    }

    public String idChain(String separatorBetween, String separatorWithin, boolean useGeneId, VariantEffect varEff) {
        StringBuilder sb = new StringBuilder();
        block9: for (Marker m = this; m != null && !(m instanceof Chromosome) && !(m instanceof Genome); m = m.getParent()) {
            if (sb.length() > 0) {
                sb.append(separatorBetween);
            }
            switch (m.getType()) {
                case EXON: {
                    Transcript tr = (Transcript)m.getParent();
                    Exon ex = (Exon)m;
                    sb.append(m.getClass().getSimpleName());
                    sb.append(separatorWithin + ex.getRank());
                    sb.append(separatorWithin + tr.numChilds());
                    sb.append(separatorWithin + (Object)((Object)ex.getSpliceType()));
                    continue block9;
                }
                case INTRON: {
                    Intron intron = (Intron)m;
                    Transcript tr = (Transcript)m.getParent();
                    sb.append(m.getClass().getSimpleName());
                    sb.append(separatorWithin + intron.getRank());
                    sb.append(separatorWithin + (tr.numChilds() - 1));
                    sb.append(separatorWithin + intron.getSpliceType());
                    continue block9;
                }
                case GENE: {
                    Gene g = (Gene)m;
                    sb.append(m.getClass().getSimpleName());
                    sb.append(separatorWithin + (useGeneId ? m.getId() : g.getGeneName()));
                    sb.append(separatorWithin + (Object)((Object)g.getBioType()));
                    continue block9;
                }
                case TRANSCRIPT: {
                    Transcript tr = (Transcript)m;
                    sb.append(m.getClass().getSimpleName());
                    sb.append(separatorWithin + m.getId());
                    if (tr.getBioType() == null) continue block9;
                    sb.append(separatorWithin + (Object)((Object)tr.getBioType()));
                    continue block9;
                }
                case DOWNSTREAM: {
                    sb.append(m.getClass().getSimpleName());
                    if (varEff == null || varEff.getVariant() == null) continue block9;
                    Downstream downstream = (Downstream)m;
                    sb.append(separatorWithin + downstream.distanceToTr(varEff.getVariant()));
                    continue block9;
                }
                case UPSTREAM: {
                    sb.append(m.getClass().getSimpleName());
                    if (varEff == null || varEff.getVariant() == null) continue block9;
                    Upstream upstream = (Upstream)m;
                    sb.append(separatorWithin + upstream.distanceToTr(varEff.getVariant()));
                    continue block9;
                }
                case CHROMOSOME: 
                case INTERGENIC: {
                    sb.append(m.getClass().getSimpleName());
                    sb.append(separatorWithin + m.getId());
                    continue block9;
                }
            }
        }
        if (sb.length() <= 0) {
            sb.append(this.getClass().getSimpleName() + separatorWithin + this.getId());
        }
        return sb.toString();
    }

    public boolean includes(Marker marker) {
        if (!marker.getChromosomeName().equals(this.getChromosomeName())) {
            return false;
        }
        return this.start <= marker.start && marker.end <= this.end;
    }

    public Marker intersect(Marker marker) {
        if (!this.getChromosomeName().equals(marker.getChromosomeName())) {
            return null;
        }
        int istart = Math.max(this.start, marker.getStart());
        int iend = Math.min(this.end, marker.getEnd());
        if (iend < istart) {
            return null;
        }
        return new Marker(this.getParent(), istart, iend, this.strandMinus, "");
    }

    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return false;
    }

    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Markers minus(Marker interval) {
        Markers ints = new Markers();
        if (this.intersects(interval)) {
            if (interval.getStart() <= this.getStart() && this.getEnd() <= interval.getEnd()) return ints;
            if (interval.getStart() <= this.getStart() && interval.getEnd() < this.getEnd()) {
                ints.add(new Marker(this.getParent(), interval.getEnd() + 1, this.getEnd(), this.isStrandMinus(), this.getId()));
                return ints;
            } else if (this.getStart() < interval.getStart() && this.getEnd() <= interval.getEnd()) {
                ints.add(new Marker(this.getParent(), this.getStart(), interval.getStart() - 1, this.isStrandMinus(), this.getId()));
                return ints;
            } else {
                if (this.getStart() >= interval.getStart() || interval.getEnd() >= this.getEnd()) throw new RuntimeException("Interval intersection not analysed. This should nbever happen!");
                ints.add(new Marker(this.getParent(), this.getStart(), interval.getStart() - 1, this.isStrandMinus(), this.getId()));
                ints.add(new Marker(this.getParent(), interval.getEnd() + 1, this.getEnd(), this.isStrandMinus(), this.getId()));
            }
            return ints;
        } else {
            ints.add(this);
        }
        return ints;
    }

    public Markers query(IntervalForest intervalForest) {
        return intervalForest.query(this);
    }

    public Markers query(Marker marker) {
        return null;
    }

    public void readTxt(String line, int lineNum, Genome genome, int positionBase) {
        if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
            String[] fields = line.split("\\s+");
            if (fields.length >= 3) {
                Chromosome chromo = genome.getChromosome(fields[0].trim());
                if (chromo == null) {
                    System.err.println("WARNING: Chromosome '" + fields[0] + "' not found in genome '" + genome.getGenomeName() + "', version '" + genome.getVersion() + "'!\n\tLine: " + lineNum + "\t'" + line + "'");
                }
                this.parent = chromo;
                this.start = Gpr.parseIntSafe(fields[1]) - positionBase;
                this.end = Gpr.parseIntSafe(fields[2]) - positionBase;
                this.id = "";
                if (fields.length >= 4) {
                    for (int t = 3; t < fields.length; ++t) {
                        this.id = this.id + fields[t].trim() + " ";
                    }
                    this.id = this.id.trim();
                }
            } else {
                throw new RuntimeException("Error line " + lineNum + " (number of fields is " + fields.length + "):\t" + line);
            }
        }
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        this.type = EffectType.valueOf(markerSerializer.getNextField());
        markerSerializer.getNextFieldInt();
        this.parent = new MarkerParentId(markerSerializer.getNextFieldInt());
        this.start = markerSerializer.getNextFieldInt();
        this.end = markerSerializer.getNextFieldInt();
        this.id = markerSerializer.getNextField();
        this.strandMinus = markerSerializer.getNextFieldBoolean();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return (Object)((Object)this.type) + "\t" + markerSerializer.getIdByMarker(this) + "\t" + (this.parent != null ? markerSerializer.getIdByMarker((Marker)this.parent) : -1) + "\t" + this.start + "\t" + this.end + "\t" + this.id + "\t" + this.strandMinus;
    }

    public boolean shouldApply(Variant variant) {
        return variant.getStart() <= this.end;
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + (Object)((Object)this.type) + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public Marker union(Marker m) {
        if (!this.getChromosomeName().equals(m.getChromosomeName())) {
            return null;
        }
        int ustart = Math.min(this.start, m.getStart());
        int uend = Math.max(this.end, m.getEnd());
        return new Marker(this.getParent(), ustart, uend, this.strandMinus, "");
    }

    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        variantEffects.add(variant, this, this.type, "");
        return true;
    }

    public boolean variantEffectNonRef(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        if (variant.isNonRef()) {
            Variant variantRef = ((VariantNonRef)variant).getVariantRef();
            Marker newMarker = this.apply(variantRef);
            if (newMarker == null) {
                return false;
            }
            return newMarker.variantEffect(variant, variantEffects);
        }
        return this.variantEffect(variant, variantEffects);
    }
}

