/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class HarmonicOscillator
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double amplitude;
    private final double omega;
    private final double phase;

    public HarmonicOscillator(double amplitude, double omega, double phase) {
        this.amplitude = amplitude;
        this.omega = omega;
        this.phase = phase;
    }

    public double value(double x2) {
        return HarmonicOscillator.value(this.omega * x2 + this.phase, this.amplitude);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double xTimesOmegaPlusPhase, double amplitude) {
        return amplitude * FastMath.cos(xTimesOmegaPlusPhase);
    }

    public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
        double x2 = t.getValue();
        double[] f2 = new double[t.getOrder() + 1];
        double alpha = this.omega * x2 + this.phase;
        f2[0] = this.amplitude * FastMath.cos(alpha);
        if (f2.length > 1) {
            f2[1] = -this.amplitude * this.omega * FastMath.sin(alpha);
            double mo2 = -this.omega * this.omega;
            for (int i = 2; i < f2.length; ++i) {
                f2[i] = mo2 * f2[i - 2];
            }
        }
        return t.compose(f2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            return HarmonicOscillator.value(x2 * param2[1] + param2[2], param2[0]);
        }

        public double[] gradient(double x2, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            double amplitude = param2[0];
            double omega = param2[1];
            double phase = param2[2];
            double xTimesOmegaPlusPhase = omega * x2 + phase;
            double a = HarmonicOscillator.value(xTimesOmegaPlusPhase, 1.0);
            double p = -amplitude * FastMath.sin(xTimesOmegaPlusPhase);
            double w = p * x2;
            return new double[]{a, w, p};
        }

        private void validateParameters(double[] param2) throws NullArgumentException, DimensionMismatchException {
            if (param2 == null) {
                throw new NullArgumentException();
            }
            if (param2.length != 3) {
                throw new DimensionMismatchException(param2.length, 3);
            }
        }
    }
}

