/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sf.samtools.seekablestream.ISeekableStreamFactory;
import net.sf.samtools.seekablestream.SeekableBufferedStream;
import net.sf.samtools.seekablestream.SeekableFTPStream;
import net.sf.samtools.seekablestream.SeekableFileStream;
import net.sf.samtools.seekablestream.SeekableHTTPStream;
import net.sf.samtools.seekablestream.SeekableStream;

public class SeekableStreamFactory {
    private static final ISeekableStreamFactory DEFAULT_FACTORY;
    private static ISeekableStreamFactory currentFactory;

    private SeekableStreamFactory() {
    }

    public static void setInstance(ISeekableStreamFactory factory) {
        currentFactory = factory;
    }

    public static ISeekableStreamFactory getInstance() {
        return currentFactory;
    }

    public static boolean isFilePath(String path) {
        return !path.startsWith("http:") && !path.startsWith("https:") && !path.startsWith("ftp:");
    }

    static {
        currentFactory = DEFAULT_FACTORY = new DefaultSeekableStreamFactory();
    }

    private static class DefaultSeekableStreamFactory
    implements ISeekableStreamFactory {
        private DefaultSeekableStreamFactory() {
        }

        @Override
        public SeekableStream getStreamFor(URL url) throws IOException {
            return this.getStreamFor(url.toExternalForm());
        }

        @Override
        public SeekableStream getStreamFor(String path) throws IOException {
            if (path.startsWith("http:") || path.startsWith("https:")) {
                URL url = new URL(path);
                return new SeekableHTTPStream(url);
            }
            if (path.startsWith("ftp:")) {
                return new SeekableFTPStream(new URL(path));
            }
            return new SeekableFileStream(new File(path));
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream stream) {
            return this.getBufferedStream(stream, 512000);
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream stream, int bufferSize) {
            return new SeekableBufferedStream(stream, bufferSize);
        }
    }
}

