/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMergeObject;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionResolver;
import com.typesafe.config.impl.Unmergeable;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class ConfigDelayedMerge
extends AbstractConfigValue
implements Unmergeable {
    private static final long serialVersionUID = 1L;
    private final List<AbstractConfigValue> stack;
    private final boolean ignoresFallbacks;

    ConfigDelayedMerge(ConfigOrigin configOrigin, List<AbstractConfigValue> list2, boolean bl) {
        super(configOrigin);
        this.stack = list2;
        this.ignoresFallbacks = bl;
        if (list2.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge value");
        }
        for (AbstractConfigValue abstractConfigValue : list2) {
            if (!(abstractConfigValue instanceof ConfigDelayedMerge) && !(abstractConfigValue instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMerge, should have consolidated stack");
        }
    }

    ConfigDelayedMerge(ConfigOrigin configOrigin, List<AbstractConfigValue> list2) {
        this(configOrigin, list2, false);
    }

    @Override
    public ConfigValueType valueType() {
        throw new ConfigException.NotResolved("called valueType() on value with unresolved substitutions, need to resolve first");
    }

    @Override
    public Object unwrapped() {
        throw new ConfigException.NotResolved("called unwrapped() on value with unresolved substitutions, need to resolve first");
    }

    @Override
    AbstractConfigValue resolveSubstitutions(SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        return ConfigDelayedMerge.resolveSubstitutions(this.stack, substitutionResolver, n, configResolveOptions);
    }

    static AbstractConfigValue resolveSubstitutions(List<AbstractConfigValue> list2, SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) {
        AbstractConfigValue abstractConfigValue = null;
        for (AbstractConfigValue abstractConfigValue2 : list2) {
            AbstractConfigValue abstractConfigValue3 = substitutionResolver.resolve(abstractConfigValue2, n, configResolveOptions);
            if (abstractConfigValue3 == null) continue;
            if (abstractConfigValue == null) {
                abstractConfigValue = abstractConfigValue3;
                continue;
            }
            abstractConfigValue = abstractConfigValue.withFallback(abstractConfigValue3);
        }
        return abstractConfigValue;
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigDelayedMerge relativized(Path path) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue abstractConfigValue : this.stack) {
            arrayList.add(abstractConfigValue.relativized(path));
        }
        return new ConfigDelayedMerge(this.origin(), arrayList, this.ignoresFallbacks);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    @Override
    protected AbstractConfigValue newCopy(boolean bl, ConfigOrigin configOrigin) {
        return new ConfigDelayedMerge(configOrigin, this.stack, bl);
    }

    @Override
    protected final ConfigDelayedMerge mergedWithTheUnmergeable(Unmergeable unmergeable) {
        if (this.ignoresFallbacks) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(this.stack);
        arrayList.addAll(unmergeable.unmergedValues());
        return new ConfigDelayedMerge(AbstractConfigObject.mergeOrigins(arrayList), arrayList, ((AbstractConfigValue)((Object)unmergeable)).ignoresFallbacks());
    }

    @Override
    protected final ConfigDelayedMerge mergedWithObject(AbstractConfigObject abstractConfigObject) {
        if (this.ignoresFallbacks) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(this.stack);
        arrayList.add(abstractConfigObject);
        return new ConfigDelayedMerge(AbstractConfigObject.mergeOrigins(arrayList), arrayList, abstractConfigObject.ignoresFallbacks());
    }

    public Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigDelayedMerge;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigDelayedMerge) {
            return this.canEqual(object) && ((Object)this.stack).equals(((ConfigDelayedMerge)object).stack);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, String string2, boolean bl) {
        ConfigDelayedMerge.render(this.stack, stringBuilder, n, string2, bl);
    }

    static void render(List<AbstractConfigValue> list2, StringBuilder stringBuilder, int n, String string2, boolean bl) {
        if (bl) {
            stringBuilder.append("# unresolved merge of " + list2.size() + " values follows (\n");
            if (string2 == null) {
                ConfigDelayedMerge.indent(stringBuilder, n);
                stringBuilder.append("# this unresolved merge will not be parseable because it's at the root of the object\n");
                stringBuilder.append("# the HOCON format has no way to list multiple root objects in a single file\n");
            }
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(list2);
        Collections.reverse(arrayList);
        int n2 = 0;
        for (AbstractConfigValue abstractConfigValue : arrayList) {
            if (bl) {
                ConfigDelayedMerge.indent(stringBuilder, n);
                if (string2 != null) {
                    stringBuilder.append("#     unmerged value " + n2 + " for key " + ConfigImplUtil.renderJsonString(string2) + " from ");
                } else {
                    stringBuilder.append("#     unmerged value " + n2 + " from ");
                }
                ++n2;
                stringBuilder.append(abstractConfigValue.origin().description());
                stringBuilder.append("\n");
                for (String string3 : abstractConfigValue.origin().comments()) {
                    ConfigDelayedMerge.indent(stringBuilder, n);
                    stringBuilder.append("# ");
                    stringBuilder.append(string3);
                    stringBuilder.append("\n");
                }
                ConfigDelayedMerge.indent(stringBuilder, n);
            }
            if (string2 != null) {
                stringBuilder.append(ConfigImplUtil.renderJsonString(string2));
                stringBuilder.append(" : ");
            }
            abstractConfigValue.render(stringBuilder, n, bl);
            stringBuilder.append(",");
            if (!bl) continue;
            stringBuilder.append('\n');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (bl) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("\n");
            ConfigDelayedMerge.indent(stringBuilder, n);
            stringBuilder.append("# ) end of unresolved merge\n");
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ConfigDelayedMerge(this.origin(), new LinkedList<AbstractConfigValue>(this.stack), this.ignoresFallbacks);
    }
}

