/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfInfoType;

public class VcfHeaderInfo
extends VcfHeaderEntry {
    protected int number;
    protected boolean implicit;
    protected VcfInfoNumber vcfInfoNumber;
    protected VcfInfoType vcfInfoType;
    protected String description;

    public VcfHeaderInfo(String line) {
        super(line);
        Matcher matcher;
        if (VcfHeader.isInfoLine(line) || VcfHeader.isFormatLine(line)) {
            while (line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            this.line = line;
            int start = line.indexOf(60);
            int end = line.lastIndexOf(62);
            if (start < 0 || end < 0) {
                return;
            }
            String params = line.substring(start + 1, end);
            Pattern pattern = Pattern.compile("ID=([^,]+),");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'ID' in info line: '" + line + "'");
            }
            this.id = matcher.group(1);
            this.number = -1;
            this.vcfInfoNumber = VcfInfoNumber.UNLIMITED;
            pattern = Pattern.compile("Number=([^,]+),");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'Number' in info line: '" + line + "'");
            }
            this.setNumber(matcher.group(1));
            pattern = Pattern.compile("Type=([^,]+),");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'Type' in info line: '" + line + "'");
            }
            this.vcfInfoType = VcfInfoType.parse(matcher.group(1).toUpperCase());
            pattern = Pattern.compile("Description=\\\"(.+)\\\"");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'Description' in info line: '" + line + "'");
            }
        } else {
            throw new RuntimeException("Line provided is not an INFO/FORMAT definition: '" + line + "'");
        }
        this.description = matcher.group(1);
    }

    public VcfHeaderInfo(String id, VcfInfoType vcfInfoType, String number2, String description) {
        super(null);
        this.id = id;
        this.vcfInfoType = vcfInfoType;
        this.description = description;
        this.setNumber(number2);
    }

    public VcfHeaderInfo(VcfHeaderInfo header) {
        super(null);
        this.id = header.id;
        this.number = header.number;
        this.implicit = header.implicit;
        this.vcfInfoNumber = header.vcfInfoNumber;
        this.vcfInfoType = header.vcfInfoType;
        this.description = header.description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumber() {
        return this.number;
    }

    public VcfInfoNumber getVcfInfoNumber() {
        return this.vcfInfoNumber;
    }

    public VcfInfoType getVcfInfoType() {
        return this.vcfInfoType;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public boolean isInfo() {
        return true;
    }

    public boolean isNumberAllAlleles() {
        return this.vcfInfoNumber == VcfInfoNumber.ALL_ALLELES;
    }

    public boolean isNumberNumber() {
        return this.vcfInfoNumber == VcfInfoNumber.NUMBER;
    }

    public boolean isNumberOnePerAllele() {
        return this.vcfInfoNumber == VcfInfoNumber.ALLELE;
    }

    public boolean isNumberOnePerGenotype() {
        return this.vcfInfoNumber == VcfInfoNumber.GENOTYPE;
    }

    public boolean isNumberPerAllele() {
        return this.vcfInfoNumber == VcfInfoNumber.ALLELE || this.vcfInfoNumber == VcfInfoNumber.ALL_ALLELES;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public void setNumber(int number2) {
        if (number2 < 0) {
            throw new RuntimeException("Vcf header's INFO field 'number' must be a non-negative integer!");
        }
        this.vcfInfoNumber = VcfInfoNumber.NUMBER;
        this.number = number2;
    }

    public void setNumber(String number2) {
        this.number = -1;
        if (this.vcfInfoType == VcfInfoType.Flag) {
            this.setNumber(0);
        } else if (number2.equals("A")) {
            this.vcfInfoNumber = VcfInfoNumber.ALLELE;
        } else if (number2.equals("R")) {
            this.vcfInfoNumber = VcfInfoNumber.ALL_ALLELES;
        } else if (number2.equals("G")) {
            this.vcfInfoNumber = VcfInfoNumber.GENOTYPE;
        } else if (number2.equals(".")) {
            this.vcfInfoNumber = VcfInfoNumber.UNLIMITED;
        } else {
            int num = Gpr.parseIntSafe(number2);
            if (num < 0) {
                this.vcfInfoNumber = VcfInfoNumber.UNLIMITED;
            } else {
                this.setNumber(num);
            }
        }
    }

    public void setVcfInfoNumber(VcfInfoNumber vcfInfoNumber) {
        this.vcfInfoNumber = vcfInfoNumber;
    }

    public void setVcfInfoType(VcfInfoType vcfInfoType) {
        this.vcfInfoType = vcfInfoType;
    }

    @Override
    public String toString() {
        if (this.line != null) {
            return this.line;
        }
        return "##INFO=<ID=" + this.id + ",Number=" + (this.number >= 0 ? Integer.valueOf(this.number) : this.vcfInfoNumber) + ",Type=" + (Object)((Object)this.vcfInfoType) + ",Description=\"" + this.description + "\">";
    }

    public static enum VcfInfoNumber {
        NUMBER,
        UNLIMITED,
        ALLELE,
        ALL_ALLELES,
        GENOTYPE;


        public String toString() {
            switch (this) {
                case ALLELE: {
                    return "A";
                }
                case ALL_ALLELES: {
                    return "R";
                }
                case GENOTYPE: {
                    return "G";
                }
                case NUMBER: {
                    return "";
                }
                case UNLIMITED: {
                    return ".";
                }
            }
            throw new RuntimeException("Unimplemented method for type " + this.name());
        }
    }
}

