/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import java.util.Iterator;
import org.snpeff.util.CombinatorialIterator;

public class IubString
implements Iterable<String>,
Iterator<String> {
    public static final int MAX_IUB_BASES = 10;
    int[] idx2BaseNum;
    char[] bases;
    char[][] iubCodesByIndex;
    CombinatorialIterator combIt;

    public static int countIUB(String str) {
        char[] bases = str.toCharArray();
        int count2 = 0;
        for (int i = 0; i < bases.length; ++i) {
            if (!IubString.isUIB(bases[i])) continue;
            return count2++;
        }
        return count2;
    }

    public static boolean hasIUB(String str) {
        char[] bases = str.toCharArray();
        for (int i = 0; i < bases.length; ++i) {
            if (!IubString.isUIB(bases[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIUBMax(String str) {
        if (str.length() < 10) {
            return IubString.hasIUB(str);
        }
        int count2 = IubString.countIUB(str);
        return count2 > 0 && count2 <= 10;
    }

    public static boolean isUIB(char base) {
        switch (base) {
            case 'B': 
            case 'D': 
            case 'H': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'Y': {
                return true;
            }
        }
        return false;
    }

    public static char[] iub2bases(char alt) {
        char[] alts;
        switch (alt) {
            case 'N': {
                alts = new char[]{'A', 'C', 'G', 'T'};
                break;
            }
            case 'B': {
                alts = new char[]{'C', 'G', 'T'};
                break;
            }
            case 'D': {
                alts = new char[]{'A', 'G', 'T'};
                break;
            }
            case 'H': {
                alts = new char[]{'A', 'C', 'T'};
                break;
            }
            case 'V': {
                alts = new char[]{'A', 'C', 'G'};
                break;
            }
            case 'M': {
                alts = new char[]{'A', 'C'};
                break;
            }
            case 'R': {
                alts = new char[]{'A', 'G'};
                break;
            }
            case 'W': {
                alts = new char[]{'A', 'T'};
                break;
            }
            case 'S': {
                alts = new char[]{'C', 'G'};
                break;
            }
            case 'Y': {
                alts = new char[]{'C', 'T'};
                break;
            }
            case 'K': {
                alts = new char[]{'G', 'T'};
                break;
            }
            default: {
                throw new RuntimeException("WARNING: Unkown IUB code for SNP '" + alt + "'");
            }
        }
        return alts;
    }

    public IubString(String str) {
        this.bases = str.toCharArray();
        int size2 = 0;
        for (int i = 0; i < this.bases.length; ++i) {
            if (!IubString.isUIB(this.bases[i])) continue;
            ++size2;
        }
        this.combIt = new CombinatorialIterator(size2);
        this.iubCodesByIndex = new char[size2][];
        this.idx2BaseNum = new int[size2];
        int j = 0;
        for (int i = 0; i < this.bases.length; ++i) {
            if (!IubString.isUIB(this.bases[i])) continue;
            char[] iubCodes = IubString.iub2bases(this.bases[i]);
            this.combIt.set(j, 0, iubCodes.length - 1);
            this.iubCodesByIndex[j] = iubCodes;
            this.idx2BaseNum[j] = i;
            ++j;
        }
    }

    @Override
    public boolean hasNext() {
        return this.combIt.hasNext();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public String next() {
        int[] next2 = this.combIt.next();
        if (next2 == null) {
            return null;
        }
        for (int j = 0; j < this.idx2BaseNum.length; ++j) {
            int i = this.idx2BaseNum[j];
            char[] iubs = this.iubCodesByIndex[j];
            this.bases[i] = iubs[next2[j]];
        }
        return new String(this.bases);
    }

    @Override
    public void remove() {
    }
}

