/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.io.File;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.binseq.GenomicSequences;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesGenomicSequences {
    boolean verbose = false;

    int countSequenceBinFiles(String dir) {
        int count2 = 0;
        for (String fn : new File(dir).list()) {
            if (!fn.startsWith("sequence") || !fn.endsWith(".bin")) continue;
            ++count2;
            if (!this.verbose) continue;
            Gpr.debug("Found file (" + count2 + "): " + fn);
        }
        return count2;
    }

    void deleteAllBinFiles(String dir) {
        for (File f2 : new File(dir).listFiles()) {
            String fn = f2.getName();
            if (!fn.startsWith("sequence") || !fn.endsWith(".bin")) continue;
            if (this.verbose) {
                Gpr.debug("Deleting file: " + f2.getAbsolutePath());
            }
            f2.delete();
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        int numberOfChromos = 1000;
        String genomeVer = "test_too_many_chrs";
        Config config = new Config(genomeVer);
        Genome genome = config.getGenome();
        GenomicSequences gs = new GenomicSequences(genome);
        gs.setVerbose(this.verbose);
        String dir = config.getDirDataGenomeVersion();
        this.deleteAllBinFiles(dir);
        Assert.assertEquals("Sequence files have not been deleted from " + dir, 0L, this.countSequenceBinFiles(dir));
        String[] chrSeqs = new String[numberOfChromos];
        Random random = new Random(20151124L);
        for (int i = 0; i < numberOfChromos; ++i) {
            String chrSeq;
            chrSeqs[i] = chrSeq = GprSeq.randSequence(random, 100);
            gs.addChromosomeSequence("chr" + i, chrSeq);
        }
        gs.save(config);
        int countSeqFiles = this.countSequenceBinFiles(config.getDirDataGenomeVersion());
        Assert.assertEquals("Unexpected number of sequence*.bin files", 1L, countSeqFiles);
        Config configRead = new Config(genomeVer);
        Genome genomeRead = configRead.getGenome();
        GenomicSequences gsRead = new GenomicSequences(genomeRead);
        for (int i = 0; i < numberOfChromos; ++i) {
            Chromosome chr = genome.getChromosome("chr" + i);
            Marker marker = new Marker(chr, 0, chrSeqs[i].length() - 1);
            String seqRead = gsRead.querySequence(marker);
            if (this.verbose) {
                Gpr.debug("Query marker: " + marker + ", sequence: " + seqRead);
            }
            Assert.assertEquals("Chromosome sequences do not match", chrSeqs[i].toUpperCase(), seqRead.toUpperCase());
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        int numberOfLargeChromos = 10;
        int numberOfChromos = 1000;
        int longChrLen = 1000001;
        int shortChrLen = 100;
        String genomeVer = "test_too_many_chrs";
        Config config = new Config(genomeVer);
        Genome genome = config.getGenome();
        GenomicSequences gs = new GenomicSequences(genome);
        gs.setVerbose(this.verbose);
        String dir = config.getDirDataGenomeVersion();
        this.deleteAllBinFiles(dir);
        Assert.assertEquals("Sequence files have not been deleted from " + dir, 0L, this.countSequenceBinFiles(dir));
        String[] chrSeqs = new String[numberOfChromos];
        Random random = new Random(20151124L);
        for (int i = 0; i < numberOfChromos; ++i) {
            String chrSeq = "";
            chrSeq = i < numberOfLargeChromos ? GprSeq.randSequence(random, longChrLen) : GprSeq.randSequence(random, shortChrLen);
            chrSeqs[i] = chrSeq;
            gs.addChromosomeSequence("chr" + i, chrSeq);
        }
        gs.save(config);
        int countSeqFiles = this.countSequenceBinFiles(config.getDirDataGenomeVersion());
        Assert.assertEquals("Unexpected number of sequence*.bin files", numberOfLargeChromos + 1, countSeqFiles);
        Config configRead = new Config(genomeVer);
        Genome genomeRead = configRead.getGenome();
        GenomicSequences gsRead = new GenomicSequences(genomeRead);
        for (int i = 0; i < numberOfChromos; ++i) {
            Chromosome chr = genome.getChromosome("chr" + i);
            Marker marker = new Marker(chr, 0, chrSeqs[i].length() - 1);
            String seqRead = gsRead.querySequence(marker);
            if (this.verbose) {
                Gpr.debug("Query marker: " + marker + ", sequence: " + seqRead);
            }
            Assert.assertEquals("Chromosome sequences do not match", chrSeqs[i].toUpperCase(), seqRead.toUpperCase());
        }
    }
}

