/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.snpeff.interval.BioType;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;

public class TestCasesBaseApply
extends TestCasesBase {
    @Override
    protected void initSnpEffPredictor() {
        if (this.config == null || this.config.getGenome() == null || !this.config.getGenome().getGenomeName().equals(this.genomeName)) {
            this.config = new Config(this.genomeName, "snpEff.config");
        }
        this.genome = this.config.getGenome();
        this.snpEffectPredictor = new SnpEffectPredictor(this.genome);
        this.chromosome = new Chromosome(this.genome, 0, 1000, "1");
        this.chromoSequence = "ATTGGCTCGACGCTCATTCACTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGATGTCCGCAGGTGAAGGCATACACGCTGCGCGTATACTGATGTTACCTCGATGGATTTTGTCAGAAATATGGTGCCCAGGACGCGAAGGGCATATTATGGTTGCGCGAAGACATCATTTTGGAACTAACTACTAGAACTAATCAGTAAACATCCTACTGGACGGCTTGCCCCGCGATTCAAACCGCTAACTTTATCGTCCTGTTTGGGAATTCACGGGCACGGTTCTGCAGCAAGCTGAATTGGCAGCTCGGCATAAATCCCGACCCCATCGTCACGCACGGATCAATTCATCCTCAACGAAAGGGAGCTAGCGCTGTACGGCCACGGGAGGGTGTGCACCATATTCAACGACTTCTTAACCCGACCTTAAACCAATCTTCTTACGAATGTGCCGTCGAGCGGCACCTTTCAGATTTCAGTGTTGCAACTCTTACCAGTGCACTTAAACACTCCCTCAAATCACAGGCCTTGTTCTATAGCGCTCAGCACGTCGCCAGGATGCTGGTACGCCGGACTGTCCAGATACCGTTAGCACGGCATAGGGAGGATCGCGCAGGCTATACCCGATATCGGTTGGGCATCCTTTAATTCTTTGCGGATGCGAATACCCGTCACCCCTTGCGATTCTGTTTAACGCAGACTCAACCTAACGATTGACCTACATAGTAATGAGTTTTGTTGGTCCGTAAGACTTCGCCCAAAACCGCGCATGGTGGTCGTAGAAACGTACTCACAGGCCACTAAATCCGCTTAGGACATACAGTCTCCTTCGGTCACATTAACCCCATATGATTAGTACGGTAGAGGAAAAGCACCTAACCCCCATTGAGCAGGATCTCTTTCGTAATACTCTGTATCGATTACCGATTTATTTGATTCCCCACATTTATTTCATCGGG";
        this.chromoBases = this.chromoSequence.toCharArray();
        this.codonTable = this.genome.codonTable();
        this.gene = new Gene(this.chromosome, 0, 999, false, "gene1", "gene1", BioType.protein_coding);
        this.transcript = new Transcript(this.gene, this.gene.getStart(), this.gene.getEnd(), this.gene.isStrandMinus(), "transcript1");
        this.transcript.setProteinCoding(true);
        Exon[] exons = new Exon[]{new Exon(this.transcript, 100, 199, false, "exon1", 0), new Exon(this.transcript, 300, 399, false, "exon2", 0), new Exon(this.transcript, 900, 999, false, "exon3", 0)};
        for (Exon ex : exons) {
            ex.setSequence(this.chromoSequence.substring(ex.getStart(), ex.getEnd() + 1));
            this.transcript.add(ex);
        }
        this.genome.getGenomicSequences().addGeneSequences(this.chromosome.getId(), this.chromoSequence);
        this.snpEffectPredictor.setSpliceRegionExonSize(this.spliceRegionExonSize);
        this.snpEffectPredictor.setSpliceRegionIntronMin(this.spliceRegionIntronMin);
        this.snpEffectPredictor.setSpliceRegionIntronMax(this.spliceRegionIntronMax);
        this.snpEffectPredictor.setUpDownStreamLength(0);
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.setHgvsShift(this.shiftHgvs);
        this.snpEffectPredictor.buildForest();
    }
}

