/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CircularCorrection;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.GffType;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public abstract class SnpEffPredictorFactory {
    public static final int MARK = 100;
    public static int MIN_TOTAL_FRAME_COUNT = 10;
    boolean debug = false;
    boolean verbose = false;
    boolean readSequences = true;
    boolean createRandSequences = false;
    boolean frameCorrection;
    boolean storeSequences = false;
    int lineNum;
    int inOffset;
    int totalSeqsAdded = 0;
    int totalSeqsIgnored = 0;
    String fileName;
    String fastaFile;
    String line;
    Config config;
    Genome genome;
    SnpEffectPredictor snpEffectPredictor;
    FrameType frameType;
    Set<String> chromoNamesReference;
    Map<String, Integer> exonsByChromo;
    Map<String, Marker> markersById;
    Map<String, Gene> genesById;
    Map<String, Transcript> transcriptsById;
    Random random = new Random(20140410L);

    public SnpEffPredictorFactory(Config config, int inOffset) {
        this.config = config;
        this.inOffset = inOffset;
        this.genome = config.getGenome();
        this.snpEffectPredictor = new SnpEffectPredictor(config.getGenome());
        this.exonsByChromo = new HashMap<String, Integer>();
        this.markersById = new HashMap<String, Marker>();
        this.genesById = new HashMap<String, Gene>();
        this.transcriptsById = new HashMap<String, Transcript>();
        this.chromoNamesReference = new HashSet<String>();
        this.frameCorrection = false;
        this.frameType = FrameType.UNKNOWN;
    }

    protected void add(Cds cds) {
        Transcript tr = (Transcript)cds.getParent();
        tr.add(cds);
        this.addMarker(cds, false);
    }

    protected void add(Chromosome chromo) {
        this.genome.add(chromo);
    }

    protected void add(Exon exon) {
        Transcript tr = (Transcript)exon.getParent();
        Exon oldex = (Exon)tr.get(exon.getId());
        if (oldex != null) {
            if (oldex.includes(exon)) {
                return;
            }
            exon = new Exon(tr, exon.getStart(), exon.getEnd(), exon.isStrandMinus(), exon.getId() + "_" + tr.subIntervals().size(), exon.getRank());
        }
        tr.add(exon);
        this.addMarker(exon, false);
    }

    protected void add(Gene gene) {
        if (this.debug) {
            Gpr.debug("\tAdding gene\tID: '" + gene.getId() + "'\tname: '" + gene.getGeneName() + "'\t" + gene.toStr());
        }
        this.snpEffectPredictor.add(gene);
        if (this.genesById.containsKey(gene.getId())) {
            throw new RuntimeException("Gene  '" + gene.getId() + "' already exists");
        }
        this.genesById.put(gene.getId(), gene);
    }

    protected void add(Marker marker) {
        if (this.debug) {
            Gpr.debug("\tAdding " + marker.getClass().getSimpleName() + ":\tID: '" + marker.getId() + "'\t" + marker.toStr());
        }
        this.addMarker(marker, false);
    }

    protected void add(Transcript tr) {
        Gene gene = (Gene)tr.getParent();
        if (this.debug) {
            Gpr.debug("\tAdding transcript :\tID: '" + tr.getId() + "' to gene '" + gene.getId() + "'\t" + tr.toStr());
        }
        gene.add(tr);
        if (this.transcriptsById.containsKey(tr.getId())) {
            throw new RuntimeException("Transcript  '" + tr.getId() + "' already exists");
        }
        this.transcriptsById.put(tr.getId(), tr);
    }

    protected void addMarker(Marker marker, boolean unique2) {
        String key = marker.getId();
        if (unique2 && this.markersById.containsKey(key)) {
            throw new RuntimeException("Marker '" + key + "' already exists");
        }
        this.markersById.put(key, marker);
    }

    protected void addSequences(String chr, String chrSeq) {
        this.chromoLen(chr, chrSeq.length());
        int seqsAdded = 0;
        int seqsIgnored = 0;
        if (this.storeSequences) {
            if (this.verbose) {
                System.out.print("\t\tAdding genomic sequences to genes: ");
            }
            int count2 = this.genome.getGenomicSequences().addGeneSequences(chr, chrSeq);
            if (this.verbose) {
                System.out.println("\tDone (" + count2 + " sequences added).");
            }
        }
        if (this.verbose) {
            System.out.print("\t\tAdding genomic sequences to exons: ");
        }
        int chrLen = chrSeq.length();
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.getChromosomeName().equalsIgnoreCase(chr)) continue;
            for (Transcript tr : gene) {
                CircularCorrection cc = new CircularCorrection(tr, chrLen);
                cc.correct();
                for (Exon exon : tr) {
                    int ssStart = exon.getStart();
                    int ssEnd = exon.getEnd() + 1;
                    String seq2 = null;
                    if (ssStart >= 0 && ssEnd <= chrLen) {
                        try {
                            seq2 = chrSeq.substring(ssStart, ssEnd);
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                            throw new RuntimeException("Error trying to add sequence to exon:\n\tChromosome sequence length: " + chrSeq.length() + "\n\tExon: " + exon);
                        }
                    } else if (ssStart < 0 && ssEnd > 0) {
                        seq2 = chrSeq.substring(ssStart += chrLen, chrLen) + chrSeq.substring(0, ssEnd);
                    } else if (ssStart < 0 && ssEnd < 0) {
                        seq2 = chrSeq.substring(ssStart += chrLen, ssEnd += chrLen);
                    }
                    if (seq2 == null) continue;
                    if (seq2.length() != exon.size()) {
                        this.warning("Exon sequence length does not match exon.size()\n" + exon);
                    }
                    if (exon.isStrandMinus()) {
                        seq2 = GprSeq.reverseWc(seq2);
                    }
                    seq2 = seq2.toUpperCase();
                    exon.setSequence(seq2);
                    ++seqsAdded;
                }
            }
        }
        if (this.verbose) {
            System.out.println("\tDone (" + seqsAdded + " sequences added, " + seqsIgnored + " ignored).");
        }
        this.totalSeqsAdded += seqsAdded;
        this.totalSeqsIgnored += seqsIgnored;
    }

    protected void adjustChromosomes() {
        if (this.verbose) {
            System.out.print("\n\tAdjusting chromosomes lengths: ");
        }
        HashMap<String, Integer> lenByChr = new HashMap<String, Integer>();
        for (Gene gene : this.config.getGenome().getGenes()) {
            String chrName = gene.getChromosomeName();
            Integer len = (Integer)lenByChr.get(chrName);
            int max2 = Math.max(gene.getEnd(), len != null ? len : 0);
            lenByChr.put(chrName, max2);
        }
        int adjusted = 0;
        for (String chrName : lenByChr.keySet()) {
            Chromosome chr = this.config.getGenome().getChromosome(chrName);
            int newEnd = (Integer)lenByChr.get(chrName);
            if (chr.getEnd() >= newEnd) continue;
            if (chr.size() <= 1) {
                chr.setEnd((Integer)lenByChr.get(chrName));
                this.mark(adjusted++);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("\t\tChromosome '" + chr.getId() + "' has length of " + chr.size() + ", but genes end at " + lenByChr.get(chrName) + ". Assuming circular genome, not adjusting");
        }
    }

    void adjustGenes() {
        int i = 1;
        if (this.verbose) {
            System.out.print("\n\tAdjusting genes: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            if (!gene.adjust()) continue;
            this.mark(i++);
        }
    }

    protected void adjustTranscripts() {
        int i = 1;
        if (this.verbose) {
            System.out.print("\n\tAdjusting transcripts: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.adjust()) continue;
                this.mark(i++);
            }
        }
    }

    protected void beforeExonSequences() {
        this.exonsFromCds();
        this.deleteRedundant();
        this.collapseZeroLenIntrons();
    }

    void chromoLen(String chromoName, int len) {
        Chromosome chromo = this.getOrCreateChromosome(chromoName);
        chromo.setLength(len);
    }

    protected void codingFromCds() {
        int i = 0;
        if (this.verbose) {
            System.out.print("\n\tMarking as 'coding' from CDS information: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (tr.getCds() == null || tr.getCds().isEmpty() || tr.isProteinCoding() || tr.getBioType() != null) continue;
                tr.setProteinCoding(true);
                ++i;
                if (!this.debug) continue;
                System.err.println("\t\tMarking as protein coding transcript " + tr.getId());
            }
        }
        if (this.verbose) {
            System.out.print("\n\tDone: " + i + " transcripts marked");
        }
    }

    protected void collapseZeroLenIntrons() {
        if (this.verbose) {
            System.out.print("\n\tCollapsing zero length introns (if needed): ");
        }
        int count2 = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.collapseZeroGap()) continue;
                this.mark(count2++);
            }
        }
        if (this.verbose) {
            System.out.println("\n\t\tTotal collapsed transcripts: " + count2);
        }
    }

    void countExonsByChromo() {
        this.exonsByChromo = new HashMap<String, Integer>();
        for (Gene gint : this.genome.getGenes()) {
            Chromosome chromo = gint.getChromosome();
            for (Transcript tint : gint) {
                for (Exon eint : tint) {
                    String chromoName = chromo.getId();
                    Integer count2 = this.exonsByChromo.get(chromoName);
                    if (count2 == null) {
                        count2 = 1;
                    } else {
                        Integer n = count2;
                        Integer n2 = count2 = Integer.valueOf(count2 + 1);
                    }
                    this.exonsByChromo.put(chromoName, count2);
                }
            }
        }
    }

    public abstract SnpEffectPredictor create();

    protected void createRandSequences() {
        for (Gene g : this.genome.getGenes()) {
            for (Transcript tr : g) {
                for (Exon ex : tr) {
                    String sequence2 = GprSeq.randSequence(this.random, ex.size());
                    ex.setSequence(sequence2);
                }
            }
        }
    }

    protected void deleteRedundant() {
        if (this.verbose) {
            System.out.print("\n\tDeleting redundant exons (if needed): ");
        }
        int count2 = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.deleteRedundant()) continue;
                this.mark(count2++);
            }
        }
        if (this.verbose) {
            System.out.println("\n\t\tTotal transcripts with deleted exons: " + count2);
        }
    }

    void error(String msg) {
        throw new RuntimeException("FATAL ERROR: " + msg + ". File '" + this.fileName + "' line " + this.lineNum + "\n\t'" + this.line + "'\n");
    }

    void error(String msg, Throwable t2) {
        throw new RuntimeException("FATAL ERROR: " + msg + ". File '" + this.fileName + "' line " + this.lineNum + "\n\t'" + this.line + "'\n", t2);
    }

    protected void exonsFromCds() {
        if (this.verbose) {
            System.out.print("\n\tCreate exons from CDS (if needed): ");
        }
        int count2 = 0;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                int lenCds = 0;
                for (Cds cds : tr.getCds()) {
                    lenCds += cds.size();
                }
                int lenExons = 0;
                for (Exon ex : tr) {
                    lenExons += ex.size();
                }
                if (lenCds <= lenExons) continue;
                this.exonsFromCds(tr);
                ++count2;
            }
        }
        if (this.verbose) {
            System.out.println("\n\tExons created for " + count2 + " transcripts.");
        }
    }

    protected void exonsFromCds(Transcript tr) {
        boolean cdsStrandMinus;
        List<Cds> cdss = tr.getCds();
        boolean trStrandMinus = tr.isStrandMinus();
        int cdsStrandSum = 0;
        for (Cds cds : cdss) {
            cdsStrandSum += cds.isStrandMinus() ? -1 : 1;
        }
        boolean bl = cdsStrandMinus = cdsStrandSum < 0;
        if (cdsStrandMinus != trStrandMinus) {
            if (this.verbose) {
                System.out.print(cdsStrandMinus ? (char)'-' : '+');
            }
            tr.setStrandMinus(cdsStrandMinus);
        }
        if (tr.isStrandPlus()) {
            Collections.sort(cdss, new IntervalComparatorByStart());
        } else {
            Collections.sort(cdss, new IntervalComparatorByEnd(true));
        }
        int rank = 1;
        for (Cds cds : cdss) {
            String id = (Object)((Object)GffType.EXON) + "_" + cds.getChromosomeName() + "_" + cds.getStart() + "_" + cds.getEnd();
            if (tr.get(id) == null) {
                Exon exon = new Exon(tr, cds.getStart(), cds.getEnd(), trStrandMinus, id, rank);
                tr.add(exon);
            }
            ++rank;
            if (!this.verbose) continue;
            System.out.print('.');
        }
    }

    protected Gene findGene(String id) {
        Gene gene = this.genesById.get(id);
        if (gene != null) {
            return gene;
        }
        return this.genesById.get((Object)((Object)GffType.GENE) + "_" + id);
    }

    protected Gene findGene(String geneId, String id) {
        Gene gene = this.findGene(geneId);
        if (gene != null) {
            return gene;
        }
        return this.genesById.get((Object)((Object)GffType.GENE) + "_" + id);
    }

    protected Marker findMarker(String id) {
        return this.markersById.get(id);
    }

    protected Transcript findTranscript(String id) {
        Transcript tr = this.transcriptsById.get(id);
        if (tr != null) {
            return tr;
        }
        return this.transcriptsById.get((Object)((Object)GffType.TRANSCRIPT) + "_" + id);
    }

    protected Transcript findTranscript(String trId, String id) {
        Transcript tr = this.findTranscript(trId);
        if (tr != null) {
            return tr;
        }
        return this.transcriptsById.get((Object)((Object)GffType.TRANSCRIPT) + "_" + id);
    }

    void finishUp() {
        this.adjustTranscripts();
        this.adjustGenes();
        this.adjustChromosomes();
        this.rankExons();
        if (this.verbose) {
            System.out.print("\n\tCreate UTRs from CDS (if needed): ");
        }
        this.utrFromCds();
        if (this.frameCorrection) {
            this.frameCorrection();
        }
        this.removeEmptyChromos();
        this.codingFromCds();
        if (this.readSequences) {
            boolean error;
            boolean bl = error = !this.config.getGenome().isMostExonsHaveSequence();
            if (error) {
                this.error("Most Exons do not have sequences!\n" + this.showChromoNamesDifferences() + "\n\n");
            }
        }
        if (this.verbose) {
            System.out.println("");
        }
    }

    void frameCorrection() {
        if (this.verbose) {
            System.out.print("\n\tCorrecting exons based on frame information.\n\t");
        }
        int[] countByFrame = new int[3];
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                int frame;
                for (Exon ex : tr) {
                    frame = ex.getFrame();
                    if (frame < 0 || frame > 2) continue;
                    int n = frame;
                    countByFrame[n] = countByFrame[n] + 1;
                }
                for (Cds cds : tr.getCds()) {
                    frame = cds.getFrame();
                    if (frame < 0 || frame > 2) continue;
                    int n = frame;
                    countByFrame[n] = countByFrame[n] + 1;
                }
            }
        }
        int countByFrameTotal = countByFrame[0] + countByFrame[1] + countByFrame[2];
        int countByFrameNonZero = countByFrame[1] + countByFrame[2];
        if (countByFrameTotal >= MIN_TOTAL_FRAME_COUNT && countByFrameNonZero <= 0) {
            System.err.println("WARNING: All frames are zero! This seems rather odd, please check that 'frame' information in your 'genes' file is accurate.");
        }
        int i = 1;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                boolean corrected = tr.frameCorrection();
                if (!corrected) continue;
                if (this.debug) {
                    System.err.println("\tTranscript " + tr.getId() + " corrected using frame (exons: " + tr.numChilds() + ").");
                    continue;
                }
                if (!this.verbose) continue;
                Gpr.showMark(i++, 1);
            }
        }
        if (this.verbose) {
            System.out.print("");
        }
    }

    protected Chromosome getOrCreateChromosome(String chromoName) {
        Chromosome chromo = this.genome.getChromosome(chromoName);
        if (chromo == null) {
            chromo = new Chromosome(this.genome, 0, 0, chromoName);
            this.genome.add(chromo);
        }
        return chromo;
    }

    public Map<String, String> getProteinByTrId() {
        return null;
    }

    boolean hasExons(String chromoName) {
        Integer count2 = this.exonsByChromo.get(chromoName);
        return count2 != null && count2 > 0;
    }

    void mark(int count2) {
        if (this.verbose) {
            Gpr.showMark(count2, 100, "\t\t");
        }
    }

    protected int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - this.inOffset;
    }

    void rankExons() {
        int i = 1;
        if (this.verbose) {
            System.out.print("\n\tRanking exons: ");
        }
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.rankExons()) continue;
                this.mark(i++);
            }
        }
    }

    protected void readExonSequences() {
        List<String> files = this.config.getFileListGenomeFasta();
        if (this.fastaFile != null) {
            files.clear();
            files.add(this.fastaFile);
        }
        for (String file : files) {
            if (Gpr.canRead(file)) {
                if (this.verbose) {
                    System.out.println("\tReading FASTA file: '" + file + "'");
                }
                FastaFileIterator ffi = new FastaFileIterator(file);
                for (String seq2 : ffi) {
                    String chromo = ffi.getName();
                    this.chromoNamesReference.add(chromo);
                    if (this.verbose) {
                        System.out.println("\t\tReading sequence '" + chromo + "', length: " + seq2.length());
                    }
                    this.addSequences(chromo, seq2);
                }
                return;
            }
            if (!this.verbose) continue;
            System.out.println("\tFASTA file: '" + file + "' not found.");
        }
        throw new RuntimeException("Cannot find reference sequence.");
    }

    void removeEmptyChromos() {
        if (this.verbose) {
            System.out.println("\n\tRemove empty chromosomes: ");
        }
        ArrayList<Chromosome> chrToDelete = new ArrayList<Chromosome>();
        for (Chromosome chr : this.config.getGenome()) {
            if (chr.size() > 1) continue;
            chrToDelete.add(chr);
        }
        for (Chromosome chr : chrToDelete) {
            if (this.verbose) {
                System.out.println("\t\tRemoving empty chromosome: '" + chr.getId() + "'");
            }
            this.config.getGenome().remove(chr);
        }
        if (this.verbose && chrToDelete.size() > 0) {
            System.out.print("\t\tChromosome left: ");
            for (Chromosome chr : this.config.getGenome()) {
                System.out.print(chr.getId() + " ");
            }
            System.out.println("");
        }
    }

    protected void replaceTranscript(Transcript trOld, Transcript trNew) {
        this.transcriptsById.remove(trOld.getId());
        this.transcriptsById.put(trNew.getId(), trNew);
    }

    public void setCreateRandSequences(boolean createRandSequences) {
        this.createRandSequences = createRandSequences;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFastaFile(String fastaFile) {
        this.fastaFile = fastaFile;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setReadSequences(boolean readSequences) {
        this.readSequences = readSequences;
    }

    public void setStoreSequences(boolean storeSequences) {
        this.storeSequences = storeSequences;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected String showChromoNamesDifferences() {
        if (this.chromoNamesReference.isEmpty()) {
            return "";
        }
        HashSet<String> chrs = new HashSet<String>();
        for (Gene g : this.config.getGenome().getGenes()) {
            chrs.add(g.getChromosomeName());
        }
        int counMissinfRef = 0;
        StringBuilder sbMissingRef = new StringBuilder();
        ArrayList<String> chrsSorted = new ArrayList<String>();
        chrsSorted.addAll(chrs);
        Collections.sort(chrsSorted);
        for (String chr : chrsSorted) {
            if (this.chromoNamesReference.contains(chr)) continue;
            ++counMissinfRef;
            if (sbMissingRef.length() > 0) {
                sbMissingRef.append(", ");
            }
            sbMissingRef.append("'" + chr + "'");
        }
        int counMissinfGenes = 0;
        StringBuilder sbMissingGenes = new StringBuilder();
        ArrayList<String> chrsRefSorted = new ArrayList<String>();
        chrsRefSorted.addAll(this.chromoNamesReference);
        Collections.sort(chrsRefSorted);
        for (String chr : chrsRefSorted) {
            if (chrs.contains(chr)) continue;
            ++counMissinfGenes;
            if (sbMissingGenes.length() > 0) {
                sbMissingRef.append(", ");
            }
            sbMissingGenes.append("'" + chr + "'");
        }
        String msg = "";
        if (counMissinfRef > 0 && counMissinfGenes > 0) {
            msg = "There might be differences in the chromosome names used in the genes file ('" + this.fileName + "')\nand the chromosme names used in the 'reference sequence' file" + (this.fastaFile != null ? " ('" + this.fastaFile + "')" : "") + ".\nPlease check that chromosome names in both files match.\n";
        }
        return msg + (sbMissingRef.length() > 0 ? "\tChromosome names missing in 'reference sequence' file:\t" + sbMissingRef.toString() : "") + (sbMissingGenes.length() > 0 ? "\n\tChromosome names missing in 'genes' file             :\t" + sbMissingGenes.toString() : "");
    }

    String unquote(String qstr) {
        return qstr.replaceAll("\"", "");
    }

    void utrFromCds() {
        int i = 1;
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.utrFromCds(this.debug)) continue;
                this.mark(i++);
            }
        }
    }

    void warning(String msg) {
        if (this.verbose) {
            System.err.println("WARNING: " + msg + ". File '" + this.fileName + "' line " + this.lineNum + "\t'" + this.line + "'");
        }
    }
}

