/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.HashMap;
import java.util.List;
import org.snpeff.SnpEff;
import org.snpeff.align.SmithWaterman;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdCds
extends SnpEff {
    public static boolean onlyOneError = false;
    public static double maxErrorPercentage = 0.01;
    public static int MAX_ALIGN_LENGTH = 33000;
    boolean storeAlignments;
    boolean checkNumOk = true;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;
    String cdsFile = "";
    HashMap<String, String> cdsByTrId;

    public SnpEffCmdCds() {
    }

    public SnpEffCmdCds(Config config) {
        this.config = config;
        this.cdsFile = config.getFileNameCds();
    }

    public SnpEffCmdCds(String genomeVer, String configFile, String cdsFile) {
        this.configFile = configFile;
        this.genomeVer = genomeVer;
        this.cdsFile = cdsFile;
    }

    void add(String trId, String seq2, int lineNum, boolean check2) {
        if (check2 && this.cdsByTrId.get(trId) != null && !this.cdsByTrId.get(trId).equals(seq2)) {
            System.err.println("ERROR: Different CDS for the same transcript ID. This should never happen!!!\n\tLine number   : " + lineNum + "\n\tTranscript ID : '" + trId + "'\n\tProtein       : " + this.cdsByTrId.get(trId) + "\n\tProtein (new) : " + seq2);
        }
        this.cdsByTrId.put(trId, seq2);
        if (this.debug) {
            Gpr.debug("Adding cdsByTrId{'" + trId + "'} :\t" + seq2);
        }
    }

    double cdsCompare() {
        int i = 0;
        if (this.verbose) {
            System.err.println("\tLabels:");
            System.err.println("\t\t'+' : OK");
            System.err.println("\t\t'.' : Missing");
            System.err.println("\t\t'*' : Error");
            System.err.print("\t");
        }
        for (Gene gene : this.config.getGenome().getGenes()) {
            for (Transcript tr : gene) {
                int status = 32;
                boolean ok = false;
                String cds = tr.cds().toUpperCase();
                String mRna = tr.mRna().toUpperCase();
                String cdsReference = this.cdsByTrId.get(tr.getId());
                if (cdsReference != null) {
                    cdsReference = cdsReference.toUpperCase();
                }
                if (cdsReference == null) {
                    status = 46;
                    if (this.debug) {
                        System.err.println("\nWARNING:Cannot find reference CDS for transcript '" + tr.getId() + "'");
                    }
                } else if (cds.isEmpty()) {
                    status = 46;
                    if (this.debug) {
                        System.err.println("\nWARNING:Empty CDS for transcript '" + tr.getId() + "'");
                    }
                } else if (cds.equals(cdsReference)) {
                    status = 43;
                    if (cds != null && cds.length() >= 3) {
                        String stopCodon;
                        String startCodon;
                        CodonTable ctable = CodonTables.getInstance().getTable(this.config.getGenome(), tr.getChromosomeName());
                        if (!ctable.isStart(startCodon = cds.substring(0, 3))) {
                            if (this.debug) {
                                System.err.println("\nWARNING: CDS for transcript '" + tr.getId() + "' does not start with a start codon:\t" + startCodon + "\t" + cds);
                            }
                            ++this.totalWarnings;
                        }
                        if (!ctable.isStop(stopCodon = cds.substring(cds.length() - 3, cds.length()))) {
                            if (this.debug) {
                                System.err.println("\nWARNING: CDS for transcript '" + tr.getId() + "' does not end with a stop codon:\t" + stopCodon + "\t" + cds);
                            }
                            ++this.totalWarnings;
                        }
                    }
                } else if (mRna.equals(cdsReference)) {
                    status = 43;
                } else if (mRna.length() < cdsReference.length() && cdsReference.substring(mRna.length()).replace('A', ' ').trim().isEmpty() && cdsReference.substring(0, mRna.length()).equals(mRna)) {
                    status = 43;
                } else if (mRna.length() > cdsReference.length() && mRna.substring(cdsReference.length()).replace('A', ' ').trim().isEmpty() && mRna.substring(0, cdsReference.length()).equals(mRna)) {
                    status = 43;
                } else if (cdsReference.indexOf(cds) >= 0) {
                    status = 43;
                } else {
                    status = 42;
                    if (this.debug || this.storeAlignments || onlyOneError) {
                        SmithWaterman sw = new SmithWaterman(cds, cdsReference);
                        if (Math.max(cds.length(), cdsReference.length()) < MAX_ALIGN_LENGTH) {
                            sw.align();
                        }
                        int maxScore = Math.min(cds.length(), cdsReference.length());
                        int score = sw.getAlignmentScore();
                        if (this.debug || onlyOneError) {
                            System.err.println("\nERROR: CDSs do not match for transcript " + tr.getId() + "\tStrand:" + tr.isStrandMinus() + "\tExons: " + tr.numChilds() + "\n" + String.format("\tSnpEff CDS  (%6d) : '%s'\n", cds.length(), cds.toLowerCase()) + String.format("\tReference   (%6d) : '%s'\n", cdsReference.length(), cdsReference.toLowerCase()) + "\tAlignment (Snpeff CDS vs Reference CDS).\tScore: " + score + "\tMax. possible score: " + maxScore + "\tDiff: " + (maxScore - score) + "\n" + sw);
                            System.err.println("Transcript details:\n" + tr);
                        }
                        if (onlyOneError) {
                            System.err.println("Transcript details:\n" + tr);
                            throw new RuntimeException("Showing only one error!");
                        }
                    }
                }
                switch (status) {
                    case 46: {
                        ++this.totalNotFound;
                        break;
                    }
                    case 43: {
                        ++this.totalOk;
                        ok = true;
                        break;
                    }
                    case 42: {
                        ++this.totalErrors;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown status '" + (char)status + "'");
                    }
                }
                if (ok) {
                    tr.setDnaCheck(true);
                }
                if (!this.verbose || status == 32 || status == 46 && !tr.isProteinCoding()) continue;
                System.out.print((char)status);
                if (++i % 100 != 0) continue;
                System.out.print("\n\t");
            }
        }
        double perc = (double)this.totalErrors / (double)(this.totalErrors + this.totalOk);
        System.out.println("\n\tCDS check:\t" + this.config.getGenome().getVersion() + "\tOK: " + this.totalOk + "\tWarnings: " + this.totalWarnings + "\tNot found: " + this.totalNotFound + "\tErrors: " + this.totalErrors + "\tError percentage: " + 100.0 * perc + "%");
        if (this.checkNumOk && this.totalOk <= 0) {
            this.fatalErrorNoTranscriptsChecked();
        }
        return perc;
    }

    void fatalErrorNoTranscriptsChecked() {
        StringBuilder sb = new StringBuilder();
        int maxTrIds = 20;
        sb.append("Transcript IDs from database (sample):\n" + this.sampleTrIds(maxTrIds));
        sb.append("Transcript IDs from database (fasta file):\n" + this.sampleTrIdsFasta(maxTrIds));
        this.fatalError("No CDS checked. This is might be caused by differences in FASTA file transcript IDs respect to database's transcript's IDs.\n" + sb);
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                        continue;
                    }
                    this.usage("Option '-c' without config file argument");
                    continue;
                }
                if (args[i].equals("-v") || args[i].equalsIgnoreCase("-debug")) {
                    this.debug = true;
                    continue;
                }
                this.usage("Unknown option '" + args[i] + "'");
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            if (this.cdsFile.isEmpty()) {
                this.cdsFile = args[i];
                continue;
            }
            this.usage("Unknown parameter '" + args[i] + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.cdsFile.isEmpty()) {
            this.usage("Missing cds_file parameter");
        }
    }

    void readCdsFile() {
        this.cdsByTrId = new HashMap();
        if (this.cdsFile.endsWith("txt") || this.cdsFile.endsWith("txt.gz")) {
            this.readCdsFileTxt();
        } else {
            this.readCdsFileFasta();
        }
        if (this.cdsByTrId.isEmpty()) {
            this.fatalError("CDS file is empty!");
        }
    }

    void readCdsFileFasta() {
        FastaFileIterator ffi = new FastaFileIterator(this.cdsFile);
        for (String seq2 : ffi) {
            String trId = ffi.getName();
            this.add(trId, seq2, ffi.getLineNum(), true);
            List<String> ids = ffi.fastaHeader2Ids();
            for (String id : ids) {
                this.add(id, seq2, ffi.getLineNum(), false);
            }
        }
    }

    void readCdsFileTxt() {
        String cdsData = Gpr.readFile(this.cdsFile);
        String[] cdsLines = cdsData.split("\n");
        int lineNum = 1;
        for (String cdsLine : cdsLines) {
            String[] field2 = cdsLine.split("\\s+");
            if (field2.length >= 2) {
                String seq2 = field2[1].trim();
                String trId = field2[0].trim();
                if (this.cdsByTrId.get(trId) != null && !this.cdsByTrId.get(trId).equals(seq2)) {
                    System.err.println("ERROR: Different CDS for the same transcript ID. This should never happen!!!\n\tLine number: " + lineNum + "\n\tTranscript ID:\t" + trId + "\n\tCDS:\t\t" + this.cdsByTrId.get(trId) + "\n\tCDS (new):\t" + seq2);
                }
                this.cdsByTrId.put(trId, seq2);
            }
            ++lineNum;
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Checking database using CDS sequences");
        }
        if (this.config == null) {
            this.loadConfig();
        }
        if (this.verbose) {
            Timer.showStdErr("Reading CDSs from file '" + this.cdsFile + "'...");
        }
        this.readCdsFile();
        if (this.verbose) {
            Timer.showStdErr("done (" + this.cdsByTrId.size() + " CDSs).");
        }
        if (this.config.getSnpEffectPredictor() == null) {
            this.loadDb();
        }
        if (this.verbose) {
            Timer.showStdErr("Comparing CDS...");
        }
        this.cdsCompare();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        return true;
    }

    String sampleTrIds(int maxTrIds) {
        StringBuilder sb = new StringBuilder();
        int count2 = 0;
        for (Gene g : this.config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                sb.append("\t'" + tr.getId() + "'\n");
                if (count2++ <= maxTrIds) continue;
                return sb.toString();
            }
        }
        return sb.toString();
    }

    String sampleTrIdsFasta(int maxTrIds) {
        StringBuilder sb = new StringBuilder();
        int count2 = 0;
        for (String trid : this.cdsByTrId.keySet()) {
            sb.append("\t'" + trid + "'\n");
            if (count2++ <= maxTrIds) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    public void setCheckNumOk(boolean checkNumOk) {
        this.checkNumOk = checkNumOk;
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + SnpEff.VERSION);
        System.err.println("Usage: snpEff cds [options] genome_version cds_file");
        System.err.println("\nOptions:");
        System.err.println("\t-c , -config <file> : Specify config file");
        System.err.println("\t-noLog              : Do not report usage statistics to server");
        System.err.println("\t-v                  : Verbose mode");
        System.err.println("\t-d                  : Debug mode");
        System.exit(-1);
    }
}

