/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.probablility;

import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import org.snpeff.util.Gpr;

public class Hypergeometric {
    private static Hypergeometric hypergeometric = null;
    public static double EPSILON = 1.0E-20;
    double[] sumLog = new double[]{0.0};

    public static Hypergeometric get() {
        if (hypergeometric == null) {
            hypergeometric = new Hypergeometric();
        }
        return hypergeometric;
    }

    public static void main(String[] args) {
        int numTests = 1000;
        Random rand = new Random(20110122L);
        Date start = new Date();
        for (int i = 0; i < numTests; ++i) {
            int N = rand.nextInt(100000) + 1;
            int D = rand.nextInt(N) + 1;
            int n = rand.nextInt(N) + 1;
            int k = rand.nextInt(Math.min(n, D));
            Hypergeometric.get().hypergeometric(k, N, D, n);
        }
        Date end = new Date();
        Gpr.debug("Elapsed:" + (end.getTime() - start.getTime()));
    }

    private Hypergeometric() {
    }

    public boolean checkHypergeometricParams(int k, int N, int D, int n) {
        if (k < 0 || N < 0 || D < 0 || n < 0) {
            return false;
        }
        int a = k;
        int b = D - k;
        int c = n - k;
        int d = N + k - n - D;
        return a >= 0 && b >= 0 && c >= 0 && d >= 0 && N >= 0;
    }

    public double hypergeometric(int k, int N, int D, int n) {
        double hypergeometric2 = 1.0;
        double numeratorLog = 0.0;
        double denominatorLog = 0.0;
        int a = k;
        int b = D - k;
        int c = n - k;
        int d = N + k - n - D;
        int ab = a + b;
        int cd = c + d;
        int ac = a + c;
        int bd = b + d;
        if (a < 0 || b < 0 || c < 0 || d < 0 || N < 0 || D < 0 || n < 0 || k < 0) {
            Gpr.debug("WARNING: Invalid values. k:" + k + ", N:" + N + ", D:" + D + ", n:" + n + "\t=> a:" + a + ", b:" + b + ", c:" + c + ", d:" + d);
            return 0.0;
        }
        denominatorLog += this.sumLog(N);
        denominatorLog += this.sumLog(a);
        denominatorLog += this.sumLog(b);
        denominatorLog += this.sumLog(c);
        denominatorLog += this.sumLog(d);
        numeratorLog += this.sumLog(ab);
        numeratorLog += this.sumLog(cd);
        numeratorLog += this.sumLog(ac);
        double hypergeometricLog = (numeratorLog += this.sumLog(bd)) - denominatorLog;
        hypergeometric2 = Math.exp(hypergeometricLog);
        if (hypergeometric2 < 0.0) {
            throw new RuntimeException("Negative cumulativeHG = " + hypergeometric2 + "\n\t\t\t\t\tcalculating hypergeometric(" + k + ", " + N + ", " + D + ", " + n + ")");
        }
        if (hypergeometricLog < 0.0 && hypergeometric2 == 0.0) {
            return Double.MIN_VALUE;
        }
        return hypergeometric2;
    }

    synchronized void newSumLog(int n) {
        if (n >= this.sumLog.length) {
            double[] sumLogNew = Arrays.copyOf(this.sumLog, n + 1);
            for (int i = this.sumLog.length; i < sumLogNew.length; ++i) {
                sumLogNew[i] = sumLogNew[i - 1] + Math.log(i);
            }
            this.sumLog = sumLogNew;
        }
    }

    double sumLog(int n) {
        if (n >= this.sumLog.length) {
            this.newSumLog(n);
        }
        return this.sumLog[n];
    }

    public String toR(int k, int N, int D, int n) {
        return "dhyper( " + k + ", " + D + ", " + (N - D) + ", " + n + " )";
    }
}

