/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets.algorithm;

import org.snpeff.geneSets.GeneSet;
import org.snpeff.geneSets.GeneSets;
import org.snpeff.geneSets.Result;
import org.snpeff.geneSets.algorithm.EnrichmentAlgorithmGreedy;

public abstract class EnrichmentAlgorithmGreedyVariableSize
extends EnrichmentAlgorithmGreedy {
    int sizeGrowthFactor = 2;
    int initialSize = 50;
    int maxSize = -1;

    public EnrichmentAlgorithmGreedyVariableSize(GeneSets geneSets, int numberToSelect) {
        super(geneSets, numberToSelect);
        for (GeneSet gs : geneSets) {
            this.maxSize = Math.max(this.maxSize, gs.size());
        }
    }

    @Override
    protected Result greedyPvalue(Result prevResult) {
        if (this.maxGeneSetSize < Integer.MAX_VALUE || this.minGeneSetSize > 0) {
            return super.greedyPvalue(prevResult);
        }
        int minGeneSetSize = 1;
        int maxGeneSetSize = this.initialSize;
        while (minGeneSetSize < this.maxSize) {
            Result best;
            if (this.debug) {
                System.err.println("Trying size range [ " + minGeneSetSize + " , " + maxGeneSetSize + " ]");
            }
            if (!(best = this.greedyPvalue(prevResult, minGeneSetSize, maxGeneSetSize)).isEmpty()) {
                best.setGeneSetCountLast(this.geneSets.getGeneSetCount() - best.getGeneSets().size());
                double bestPval = best.getPvalueAdjusted();
                if (bestPval <= prevResult.getPvalueAdjusted() && bestPval <= this.maxPvalueAjusted) {
                    return best;
                }
            }
            minGeneSetSize = maxGeneSetSize + 1;
            maxGeneSetSize = this.sizeGrowthFactor * maxGeneSetSize;
        }
        return null;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setSizeGrowthFactor(int sizeGrowthFactor) {
        this.sizeGrowthFactor = sizeGrowthFactor;
    }
}

