/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.storage.ArrayListSequenceReader;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceView;
import org.biojava3.core.sequence.views.ComplementSequenceView;
import org.biojava3.core.sequence.views.ReversedSequenceView;
import org.biojava3.core.sequence.views.WindowedSequence;
import org.biojava3.core.util.CRC64Checksum;

public class SequenceMixin {
    public static <C extends Compound> int countCompounds(Sequence<C> sequence2, C ... compounds) {
        int count2 = 0;
        Map<C, Integer> compositon = SequenceMixin.getComposition(sequence2);
        for (C compound : compounds) {
            if (!compositon.containsKey(compound)) continue;
            count2 = compositon.get(compound) + count2;
        }
        return count2;
    }

    public static int countGC(Sequence<NucleotideCompound> sequence2) {
        CompoundSet<NucleotideCompound> cs = sequence2.getCompoundSet();
        NucleotideCompound G = cs.getCompoundForString("G");
        NucleotideCompound C = cs.getCompoundForString("C");
        NucleotideCompound g = cs.getCompoundForString("g");
        NucleotideCompound c = cs.getCompoundForString("c");
        return SequenceMixin.countCompounds(sequence2, (Compound[])new NucleotideCompound[]{G, C, g, c});
    }

    public static int countAT(Sequence<NucleotideCompound> sequence2) {
        CompoundSet<NucleotideCompound> cs = sequence2.getCompoundSet();
        NucleotideCompound A = cs.getCompoundForString("A");
        NucleotideCompound T = cs.getCompoundForString("T");
        NucleotideCompound a = cs.getCompoundForString("a");
        NucleotideCompound t2 = cs.getCompoundForString("t");
        return SequenceMixin.countCompounds(sequence2, (Compound[])new NucleotideCompound[]{A, T, a, t2});
    }

    public static <C extends Compound> Map<C, Double> getDistribution(Sequence<C> sequence2) {
        HashMap<C, Double> results = new HashMap<C, Double>();
        Map<C, Integer> composition = SequenceMixin.getComposition(sequence2);
        double length = sequence2.getLength();
        for (Map.Entry<C, Integer> entry : composition.entrySet()) {
            double dist = entry.getValue().doubleValue() / length;
            results.put(entry.getKey(), dist);
        }
        return results;
    }

    public static <C extends Compound> Map<C, Integer> getComposition(Sequence<C> sequence2) {
        HashMap<Compound, Integer> results = new HashMap<Compound, Integer>();
        for (Compound currentCompound : sequence2) {
            Integer currentInteger = (Integer)results.get(currentCompound);
            if (currentInteger == null) {
                currentInteger = 0;
            }
            Integer n = currentInteger;
            Integer n2 = currentInteger = Integer.valueOf(currentInteger + 1);
            results.put(currentCompound, currentInteger);
        }
        return results;
    }

    public static <C extends Compound> void write(Appendable appendable, Sequence<C> sequence2) throws IOException {
        for (Compound compound : sequence2) {
            appendable.append(compound.toString());
        }
    }

    public static <C extends Compound> StringBuilder toStringBuilder(Sequence<C> sequence2) {
        StringBuilder sb = new StringBuilder(sequence2.getLength());
        for (Compound compound : sequence2) {
            sb.append(compound.toString());
        }
        return sb;
    }

    public static <C extends Compound> String toString(Sequence<C> sequence2) {
        return SequenceMixin.toStringBuilder(sequence2).toString();
    }

    public static <C extends Compound> List<C> toList(Sequence<C> sequence2) {
        ArrayList<Compound> list2 = new ArrayList<Compound>(sequence2.getLength());
        for (Compound compound : sequence2) {
            list2.add(compound);
        }
        return list2;
    }

    public static <C extends Compound> int indexOf(Sequence<C> sequence2, C compound) {
        int index2 = 1;
        for (Compound currentCompound : sequence2) {
            if (currentCompound.equals(compound)) {
                return index2;
            }
            ++index2;
        }
        return 0;
    }

    public static <C extends Compound> int lastIndexOf(Sequence<C> sequence2, C compound) {
        int index2 = SequenceMixin.indexOf(new ReversedSequenceView<C>(sequence2), compound);
        return sequence2.getLength() - index2 + 1;
    }

    public static <C extends Compound> Iterator<C> createIterator(Sequence<C> sequence2) {
        return new SequenceIterator<C>(sequence2);
    }

    public static <C extends Compound> SequenceView<C> createSubSequence(Sequence<C> sequence2, int start, int end) {
        return new SequenceProxyView<C>(sequence2, start, end);
    }

    public static <C extends Compound> Sequence<C> shuffle(Sequence<C> sequence2) {
        List<C> compounds = sequence2.getAsList();
        Collections.shuffle(compounds);
        return new ArrayListSequenceReader<C>(compounds, sequence2.getCompoundSet());
    }

    public static <C extends Compound> String checksum(Sequence<C> sequence2) {
        CRC64Checksum checksum = new CRC64Checksum();
        for (Compound compound : sequence2) {
            checksum.update(compound.getShortName());
        }
        return checksum.toString();
    }

    public static <C extends Compound> List<SequenceView<C>> nonOverlappingKmers(Sequence<C> sequence2, int kmer) {
        ArrayList<SequenceView<C>> l = new ArrayList<SequenceView<C>>();
        WindowedSequence<C> w = new WindowedSequence<C>(sequence2, kmer);
        for (SequenceView<C> view : w) {
            l.add(view);
        }
        return l;
    }

    public static <C extends Compound> List<SequenceView<C>> overlappingKmers(Sequence<C> sequence2, int kmer) {
        int i;
        ArrayList<SequenceView<C>> l = new ArrayList<SequenceView<C>>();
        ArrayList<Iterator<SequenceView<C>>> windows = new ArrayList<Iterator<SequenceView<C>>>();
        for (i = 1; i <= kmer; ++i) {
            if (i == 1) {
                windows.add(new WindowedSequence<C>(sequence2, kmer).iterator());
                continue;
            }
            SequenceView<C> sv = sequence2.getSubSequence(i, sequence2.getLength());
            windows.add(new WindowedSequence<C>(sv, kmer).iterator());
        }
        block1: while (true) {
            i = 0;
            while (true) {
                if (i >= kmer) continue block1;
                Iterator iterator2 = (Iterator)windows.get(i);
                boolean breakLoop = true;
                if (iterator2.hasNext()) {
                    l.add((SequenceView<C>)iterator2.next());
                    breakLoop = false;
                }
                if (breakLoop) break block1;
                ++i;
            }
            break;
        }
        return l;
    }

    public static <C extends Compound> SequenceView<C> inverse(Sequence<C> sequence2) {
        ReversedSequenceView<C> reverse2 = new ReversedSequenceView<C>(sequence2);
        if (sequence2.getCompoundSet().isComplementable()) {
            return new ComplementSequenceView<C>(reverse2);
        }
        return reverse2;
    }

    public static <C extends Compound> boolean sequenceEqualityIgnoreCase(Sequence<C> source, Sequence<C> target) {
        return SequenceMixin.baseSequenceEquality(source, target, true);
    }

    public static <C extends Compound> boolean sequenceEquality(Sequence<C> source, Sequence<C> target) {
        return SequenceMixin.baseSequenceEquality(source, target, false);
    }

    private static <C extends Compound> boolean baseSequenceEquality(Sequence<C> source, Sequence<C> target, boolean ignoreCase) {
        boolean equal = true;
        if (source.getLength() == target.getLength() && source.getCompoundSet().equals(target.getCompoundSet())) {
            Iterator sIter = source.iterator();
            Iterator tIter = target.iterator();
            while (sIter.hasNext()) {
                Compound s = (Compound)sIter.next();
                Compound t2 = (Compound)tIter.next();
                boolean cEqual = ignoreCase ? s.equalsIgnoreCase(t2) : s.equals(t2);
                if (cEqual) continue;
                equal = false;
                break;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public static class SequenceIterator<C extends Compound>
    implements Iterator<C> {
        private final Sequence<C> sequence;
        private final int length;
        private int currentPosition = 0;

        public SequenceIterator(Sequence<C> sequence2) {
            this.sequence = sequence2;
            this.length = sequence2.getLength();
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition < this.length;
        }

        @Override
        public C next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Exhausted sequence of elements");
            }
            return this.sequence.getCompoundAt(++this.currentPosition);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove() on a SequenceIterator");
        }
    }
}

