/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.rcsb;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.biojava.bio.structure.rcsb.RCSBLigand;
import org.biojava.bio.structure.rcsb.RCSBLigands;
import org.biojava.bio.structure.rcsb.ReadUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RCSBLigandsFactory {
    private static final String HET_URL_STUB = "http://www.pdb.org/pdb/rest/describeHet?chemicalID=";
    private static final Logger logger = LogManager.getLogger((String)RCSBLigandsFactory.class.getPackage().getName());
    private static final String PDB_URL_STUB = "http://www.pdb.org/pdb/rest/ligandInfo?structureId=";

    public static RCSBLigand getFromHeteroAtomId(InputStream stream) {
        return RCSBLigandsFactory.getFromHeteroAtomIds(stream).get(0);
    }

    public static RCSBLigand getFromHeteroAtomId(String heteroAtomId) {
        return RCSBLigandsFactory.getFromHeteroAtomIds(heteroAtomId).get(0);
    }

    public static List<RCSBLigand> getFromHeteroAtomIds(InputStream stream) {
        NodeList data2;
        try {
            data2 = ReadUtils.getNodes(stream);
        }
        catch (IOException e) {
            logger.error("Couldn't parse XML", (Throwable)e);
            return null;
        }
        ArrayList<RCSBLigand> ligands = new ArrayList<RCSBLigand>();
        Node structureIdE = null;
        for (int i = 0; !(i >= data2.getLength() || data2.item(i).getNodeType() == 1 && (structureIdE = (Element)data2.item(i)).getNodeName().equals("ligandInfo")); ++i) {
        }
        data2 = structureIdE.getChildNodes();
        Element ligandE = null;
        for (int i = 0; i < data2.getLength(); ++i) {
            if (data2.item(i).getNodeType() != 1 || !(ligandE = (Element)data2.item(i)).getNodeName().equals("ligand")) continue;
            RCSBLigand ligand = RCSBLigandsFactory.makeLigand(ligandE);
            ligands.add(ligand);
        }
        return ligands;
    }

    public static List<RCSBLigand> getFromHeteroAtomIds(List<String> heteroAtomIds) {
        String[] x2 = new String[heteroAtomIds.size()];
        heteroAtomIds.toArray(x2);
        return RCSBLigandsFactory.getFromHeteroAtomIds(x2);
    }

    public static List<RCSBLigand> getFromHeteroAtomIds(String ... heteroAtomIds) {
        InputStream is;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < heteroAtomIds.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(heteroAtomIds[i]);
        }
        try {
            URL url = new URL(HET_URL_STUB + sb.toString());
            is = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            logger.error("Couldn't open connection", (Throwable)e);
            return null;
        }
        return RCSBLigandsFactory.getFromHeteroAtomIds(is);
    }

    public static RCSBLigands getFromPdbId(InputStream stream) {
        NodeList data2;
        try {
            data2 = ReadUtils.getNodes(stream);
        }
        catch (IOException e) {
            logger.error("Couldn't parse XML", (Throwable)e);
            return null;
        }
        RCSBLigands ligands = new RCSBLigands();
        Node structureIdE = null;
        for (int i = 0; !(i >= data2.getLength() || data2.item(i).getNodeType() == 1 && (structureIdE = (Element)data2.item(i)).getNodeName().equals("ligandInfo")); ++i) {
        }
        data2 = structureIdE.getChildNodes();
        Element ligandE = null;
        for (int i = 0; i < data2.getLength(); ++i) {
            if (data2.item(i).getNodeType() != 1 || !(ligandE = (Element)data2.item(i)).getNodeName().equals("ligand")) continue;
            if (ligands.getPdbId() == null) {
                ligands.setPdbId(ligandE.getAttribute("structureId"));
            }
            RCSBLigand ligand = RCSBLigandsFactory.makeLigand(ligandE);
            ligands.addLigand(ligand);
        }
        return ligands;
    }

    public static RCSBLigands getFromPdbId(String pdbId) {
        InputStream is;
        try {
            URL url = new URL(PDB_URL_STUB + pdbId);
            is = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            logger.error("Couldn't open connection", (Throwable)e);
            return null;
        }
        return RCSBLigandsFactory.getFromPdbId(is);
    }

    public static List<RCSBLigands> getFromPdbIds(InputStream stream) {
        NodeList dataaa;
        try {
            dataaa = ReadUtils.getNodes(stream);
        }
        catch (IOException e) {
            logger.error("Couldn't parse XML", (Throwable)e);
            return null;
        }
        ArrayList<RCSBLigands> ligandsList = new ArrayList<RCSBLigands>();
        Element structureIdE = null;
        for (int k = 0; k < dataaa.getLength(); ++k) {
            if (dataaa.item(k).getNodeType() != 1 || !(structureIdE = (Element)dataaa.item(k)).getNodeName().equals("structureId")) continue;
            NodeList data2 = structureIdE.getChildNodes();
            RCSBLigands ligands = new RCSBLigands();
            Node ligandIdE = null;
            for (int i = 0; !(i >= data2.getLength() || data2.item(i).getNodeType() == 1 && (ligandIdE = (Element)data2.item(i)).getNodeName().equals("ligandInfo")); ++i) {
            }
            data2 = ligandIdE.getChildNodes();
            Element ligandE = null;
            for (int i = 0; i < data2.getLength(); ++i) {
                if (data2.item(i).getNodeType() != 1 || !(ligandE = (Element)data2.item(i)).getNodeName().equals("ligand")) continue;
                if (ligands.getPdbId() == null) {
                    ligands.setPdbId(ligandE.getAttribute("structureId"));
                }
                RCSBLigand ligand = RCSBLigandsFactory.makeLigand(ligandE);
                ligands.addLigand(ligand);
            }
            ligandsList.add(ligands);
        }
        return ligandsList;
    }

    public static List<RCSBLigands> getFromPdbIds(List<String> pdbIds) {
        String[] x2 = new String[pdbIds.size()];
        pdbIds.toArray(x2);
        return RCSBLigandsFactory.getFromPdbIds(x2);
    }

    public static RCSBLigands getFromPdbIds(String pdbId) {
        InputStream is;
        try {
            URL url = new URL(PDB_URL_STUB + pdbId);
            is = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            logger.error("Couldn't open connection", (Throwable)e);
            return null;
        }
        return RCSBLigandsFactory.getFromPdbId(is);
    }

    public static List<RCSBLigands> getFromPdbIds(String ... pdbIds) {
        InputStream is;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pdbIds.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(pdbIds[i]);
        }
        try {
            URL url = new URL(PDB_URL_STUB + sb.toString());
            is = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            logger.error("Couldn't open connection", (Throwable)e);
            return null;
        }
        return RCSBLigandsFactory.getFromPdbIds(is);
    }

    private static RCSBLigand makeLigand(Element ligandE) {
        RCSBLigand ligand = new RCSBLigand();
        ligand.setId(ligandE.getAttribute("chemicalID"));
        ligand.setType(ligandE.getAttribute("type"));
        ligand.setWeight(ReadUtils.toDouble(ligandE.getAttribute("molecularWeight")));
        Element element = null;
        NodeList data2 = ligandE.getChildNodes();
        for (int i = 0; i < data2.getLength(); ++i) {
            if (data2.item(i).getNodeType() != 1) continue;
            element = (Element)data2.item(i);
            if (element.getNodeName().equals("chemicalName")) {
                ligand.setName(element.getTextContent());
                continue;
            }
            if (element.getNodeName().equals("formula")) {
                ligand.setFormula(element.getTextContent());
                continue;
            }
            if (element.getNodeName().equals("InChIKey")) {
                ligand.setInChIKey(element.getTextContent());
                continue;
            }
            if (element.getNodeName().equals("InChI")) {
                ligand.setInChI(element.getTextContent());
                continue;
            }
            if (!element.getNodeName().equals("smiles")) continue;
            ligand.setSmiles(element.getTextContent());
        }
        return ligand;
    }
}

