/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary.io;

import java.io.IOException;
import java.util.List;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;
import org.biojava.bio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.bio.structure.quaternary.io.PDBBioUnitDataProvider;
import org.biojava3.core.util.SoftHashMap;

public class FileBasedPDBBioUnitDataProvider
implements BioUnitDataProvider {
    SoftHashMap<String, PDBHeader> headerCache = new SoftHashMap(0);
    Structure s = null;
    AtomCache cache = new AtomCache();

    public Structure getBioUnit(String pdbId, int bioUnit) throws IOException {
        if (bioUnit == 0) {
            PDBBioUnitDataProvider fprov = new PDBBioUnitDataProvider();
            Structure s = fprov.getAsymUnit(pdbId);
            return s;
        }
        PDBFileReader reader = new PDBFileReader();
        reader.setAutoFetch(this.cache.isAutoFetch());
        reader.setFetchCurrent(this.cache.isFetchCurrent());
        reader.setFetchFileEvenIfObsolete(this.cache.isFetchFileEvenIfObsolete());
        reader.setPath(this.cache.getPath());
        FileParsingParameters params = this.cache.getFileParsingParams();
        if (bioUnit > 0) {
            params.setParseBioAssembly(true);
            reader.setBioAssemblyId(bioUnit);
            reader.setBioAssemblyFallback(false);
        }
        params.setHeaderOnly(false);
        reader.setFileParsingParameters(params);
        return reader.getStructureById(pdbId);
    }

    public PDBHeader loadPDB(String pdbId, int bioUnit) {
        if (this.cache == null) {
            this.cache = new AtomCache();
        }
        PDBHeader header = null;
        try {
            this.s = this.getBioUnit(pdbId, bioUnit);
            header = this.s.getPDBHeader();
            this.headerCache.put(this.s.getPDBCode(), header);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return header;
    }

    @Override
    public Structure getAsymUnit(String pdbId) {
        if (this.s == null || !this.s.getPDBCode().equalsIgnoreCase(pdbId)) {
            this.loadPDB(pdbId, 0);
        }
        if (this.s.nrModels() > 1) {
            this.s = StructureTools.removeModels(this.s);
        }
        return this.s;
    }

    @Override
    public void setAsymUnit(Structure s) {
        this.s = s;
    }

    @Override
    public List<ModelTransformationMatrix> getBioUnitTransformationList(String pdbId, int biolAssemblyNr) {
        PDBHeader header = this.headerCache.get(pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId, biolAssemblyNr);
        }
        return header.getBioUnitTranformationMap().get(biolAssemblyNr);
    }

    @Override
    public int getNrBiolAssemblies(String pdbId) {
        PDBHeader header = this.headerCache.get(pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId, 0);
        }
        return header.getNrBioAssemblies();
    }

    @Override
    public boolean hasBiolAssembly(String pdbId) {
        PDBHeader header = this.headerCache.get(pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId, 0);
        }
        return header.getNrBioAssemblies() > 0;
    }

    @Override
    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
    }

    @Override
    public AtomCache getAtomCache() {
        return this.cache;
    }
}

