/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Author;
import org.biojava.bio.structure.Bond;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Element;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.JournalArticle;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.PDBCrystallographicInfo;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.SSBond;
import org.biojava.bio.structure.Site;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.io.CAConverter;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBBioAssemblyParser;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.structure.io.SeqRes2AtomAligner;
import org.biojava.bio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.bio.structure.io.mmcif.ReducedChemCompProvider;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava.bio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.bio.structure.io.util.PDBTemporaryStorageUtils;

public class PDBFileParser {
    private final boolean DEBUG = false;
    private Logger logger = Logger.getLogger(PDBFileParser.class.getName());
    private String pdbId;
    private Structure structure = null;
    private List<Chain> current_model;
    private Chain current_chain = null;
    private Group current_group = null;
    private List<Chain> seqResChains;
    private boolean isLegacyFormat = false;
    private static final String NEWLINE;
    private PDBBioAssemblyParser bioAssemblyParser = null;
    @Deprecated
    private Map<String, Object> header;
    private PDBHeader pdbHeader;
    private PDBCrystallographicInfo crystallographicInfo;
    private JournalArticle journalArticle;
    private List<Map<String, Integer>> connects;
    private List<Map<String, String>> helixList;
    private List<Map<String, String>> strandList;
    private List<Map<String, String>> turnList;
    private int lengthCheck;
    private boolean isLastCompndLine = false;
    private boolean isLastSourceLine = false;
    private Compound current_compound;
    private List<Compound> compounds = new ArrayList<Compound>();
    private List<String> compndLines = new ArrayList<String>();
    private List<String> sourceLines = new ArrayList<String>();
    private List<String> journalLines = new ArrayList<String>();
    private List<DBRef> dbrefs;
    private Map<String, Site> siteMap = null;
    private Map<String, List<ResidueNumber>> siteToResidueMap = new LinkedHashMap<String, List<ResidueNumber>>();
    private List<PDBTemporaryStorageUtils.LinkRecord> linkRecords;
    private int molTypeCounter = 1;
    private String continuationField;
    private String continuationString = "";
    private DateFormat dateFormat;
    private static final List<String> compndFieldValues;
    private static final List<String> ignoreCompndFieldValues;
    private static final List<String> sourceFieldValues;
    private String previousContinuationField = "";
    public static final String PDB_AUTHOR_ASSIGNMENT = "PDB_AUTHOR_ASSIGNMENT";
    public static final String HELIX = "HELIX";
    public static final String STRAND = "STRAND";
    public static final String TURN = "TURN";
    int atomCount = 0;
    private int my_ATOM_CA_THRESHOLD;
    private int load_max_atoms;
    private boolean atomOverflow = false;
    boolean parseCAonly = false;
    FileParsingParameters params = new FileParsingParameters();
    Site site;
    private static final double MAX_PEPTIDE_BOND_LENGTH = 1.8;

    public PDBFileParser() {
        this.current_model = new ArrayList<Chain>();
        this.header = this.init_header();
        this.pdbHeader = new PDBHeader();
        this.crystallographicInfo = new PDBCrystallographicInfo();
        this.connects = new ArrayList<Map<String, Integer>>();
        this.helixList = new ArrayList<Map<String, String>>();
        this.strandList = new ArrayList<Map<String, String>>();
        this.turnList = new ArrayList<Map<String, String>>();
        this.current_compound = new Compound();
        this.dbrefs = new ArrayList<DBRef>();
        this.dateFormat = new SimpleDateFormat("dd-MMM-yy", Locale.US);
        this.load_max_atoms = this.params.getMaxAtoms();
        this.my_ATOM_CA_THRESHOLD = this.params.getAtomCaThreshold();
        this.linkRecords = new ArrayList<PDBTemporaryStorageUtils.LinkRecord>();
    }

    private Map<String, Object> init_header() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("idCode", "");
        header.put("classification", "");
        header.put("depDate", "0000-00-00");
        header.put("title", "");
        header.put("technique", "");
        header.put("resolution", null);
        header.put("modDate", "0000-00-00");
        return header;
    }

    protected String getTimeStamp() {
        Calendar cal = Calendar.getInstance();
        int hour24 = cal.get(11);
        int min2 = cal.get(12);
        int sec = cal.get(13);
        String s = "time: " + hour24 + " " + min2 + " " + sec;
        return s;
    }

    private Group getNewGroup(String recordName, Character aminoCode1, String aminoCode3) {
        HetatomImpl group;
        Group g;
        if (this.params.isLoadChemCompInfo() && (g = ChemCompGroupFactory.getGroupFromChemCompDictionary(aminoCode3)) != null) {
            return g;
        }
        if (recordName.equals("ATOM")) {
            if (aminoCode1 == null) {
                NucleotideImpl nu = new NucleotideImpl();
                group = nu;
            } else if (aminoCode1 == StructureTools.UNKNOWN_GROUP_LABEL) {
                group = new HetatomImpl();
            } else {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(aminoCode1);
                group = aa;
            }
        } else if (aminoCode1 != null) {
            AminoAcidImpl aa = new AminoAcidImpl();
            aa.setAminoType(aminoCode1);
            group = aa;
        } else {
            group = new HetatomImpl();
        }
        return group;
    }

    private void pdb_HEADER_Handler(String line) {
        String pdbCode;
        String classification = line.substring(10, 50).trim();
        String deposition_date = line.substring(50, 59).trim();
        this.pdbId = pdbCode = line.substring(62, 66).trim();
        if (line.trim().length() > 66 && this.pdbId.equals(line.substring(72, 76))) {
            this.isLegacyFormat = true;
            System.out.println(this.pdbId + " is a LEGACY entry - this will most likely not parse correctly.");
        }
        this.header.put("idCode", pdbCode);
        this.structure.setPDBCode(pdbCode);
        this.header.put("classification", classification);
        this.header.put("depDate", deposition_date);
        this.pdbHeader.setIdCode(pdbCode);
        this.pdbHeader.setClassification(classification);
        try {
            Date dep = this.dateFormat.parse(deposition_date);
            this.pdbHeader.setDepDate(dep);
            this.header.put("depDate", deposition_date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void pdb_AUTHOR_Handler(String line) {
        String authors = line.substring(10).trim();
        String auth = this.pdbHeader.getAuthors();
        if (auth == null) {
            this.pdbHeader.setAuthors(authors);
        } else {
            auth = auth + authors;
            this.pdbHeader.setAuthors(auth);
        }
    }

    private void pdb_HELIX_Handler(String line) {
        String initResName = line.substring(15, 18).trim();
        String initChainId = line.substring(19, 20);
        String initSeqNum = line.substring(21, 25).trim();
        String initICode = line.substring(25, 26);
        String endResName = line.substring(27, 30).trim();
        String endChainId = line.substring(31, 32);
        String endSeqNum = line.substring(33, 37).trim();
        String endICode = line.substring(37, 38);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.helixList.add(m);
    }

    private void pdb_SHEET_Handler(String line) {
        String initResName = line.substring(17, 20).trim();
        String initChainId = line.substring(21, 22);
        String initSeqNum = line.substring(22, 26).trim();
        String initICode = line.substring(26, 27);
        String endResName = line.substring(28, 31).trim();
        String endChainId = line.substring(32, 33);
        String endSeqNum = line.substring(33, 37).trim();
        String endICode = line.substring(37, 38);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.strandList.add(m);
    }

    private void pdb_TURN_Handler(String line) {
        String initResName = line.substring(15, 18).trim();
        String initChainId = line.substring(19, 20);
        String initSeqNum = line.substring(20, 24).trim();
        String initICode = line.substring(24, 25);
        String endResName = line.substring(26, 29).trim();
        String endChainId = line.substring(30, 31);
        String endSeqNum = line.substring(31, 35).trim();
        String endICode = line.substring(35, 36);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.turnList.add(m);
    }

    private void pdb_REVDAT_Handler(String line) {
        String modDate = (String)this.header.get("modDate");
        if (modDate.equals("0000-00-00")) {
            String modificationDate = line.substring(13, 22).trim();
            this.header.put("modDate", modificationDate);
            try {
                Date dep = this.dateFormat.parse(modificationDate);
                this.pdbHeader.setModDate(dep);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void pdb_SEQRES_Handler(String line) throws PDBParseException {
        String recordName = line.substring(0, 6).trim();
        String chainID = line.substring(11, 12);
        String newLength = line.substring(13, 17).trim();
        String subSequence = line.substring(18);
        if (this.lengthCheck == -1) {
            this.lengthCheck = Integer.parseInt(newLength);
        }
        StringTokenizer subSequenceResidues = new StringTokenizer(subSequence);
        Character aminoCode1 = null;
        if (!recordName.equals("SEQRES")) {
            return;
        }
        this.current_chain = this.isKnownChain(chainID, this.seqResChains);
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setChainID(chainID);
        }
        while (subSequenceResidues.hasMoreTokens()) {
            String threeLetter = subSequenceResidues.nextToken();
            aminoCode1 = StructureTools.get1LetterCode(threeLetter);
            this.current_group = this.getNewGroup("ATOM", aminoCode1, threeLetter);
            try {
                this.current_group.setPDBName(threeLetter);
            }
            catch (PDBParseException p) {
                this.logger.fine(p.getMessage());
            }
            if (this.current_group instanceof AminoAcid) {
                AminoAcid aa = (AminoAcid)this.current_group;
                aa.setRecordType("SEQRES");
            }
            this.current_chain.addGroup(this.current_group);
        }
        Chain test2 = this.isKnownChain(chainID, this.seqResChains);
        if (test2 == null) {
            this.seqResChains.add(this.current_chain);
        }
        this.current_group = null;
        this.current_chain = null;
        this.lengthCheck = Integer.parseInt(newLength);
    }

    private void pdb_TITLE_Handler(String line) {
        String title = line.length() > 79 ? line.substring(10, 80).trim() : line.substring(10, line.length()).trim();
        String t2 = (String)this.header.get("title");
        if (t2 != null && !t2.equals("")) {
            t2 = t2 + " ";
        }
        t2 = t2 + title;
        this.header.put("title", t2);
        this.pdbHeader.setTitle(t2);
    }

    private void pdb_JRNL_Handler(String line) {
        if (line.substring(line.length() - 8, line.length() - 4).equals(this.pdbId)) {
            line = line.substring(0, line.length() - 8);
            this.journalLines.add(line);
        } else {
            this.journalLines.add(line);
        }
    }

    private void pdb_COMPND_Handler(String line) {
        String[] fieldList;
        int fl;
        String continuationNr = line.substring(9, 10).trim();
        if (this.isLegacyFormat) {
            line = line.substring(0, 72);
        }
        if ((fl = (fieldList = (line = line.substring(10, line.length())).split("\\s+")).length) > 0 && !fieldList[0].equals("") && compndFieldValues.contains(fieldList[0])) {
            this.continuationField = fieldList[0];
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (fl > 1 && compndFieldValues.contains(fieldList[1])) {
            this.continuationField = fieldList[1];
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (continuationNr.equals("")) {
            this.continuationField = "MOLECULE:";
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        }
        line = line.replace(this.continuationField, "").trim();
        StringTokenizer compndTokens = new StringTokenizer(line);
        while (compndTokens.hasMoreTokens()) {
            String token2 = compndTokens.nextToken();
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
            if (this.previousContinuationField.equals(this.continuationField) && compndFieldValues.contains(this.continuationField)) {
                this.continuationString = this.continuationString.concat(token2 + " ");
            }
            if (!this.continuationField.equals(this.previousContinuationField)) {
                if (this.continuationString.equals("")) {
                    this.continuationString = token2;
                    continue;
                }
                this.compndValueSetter(this.previousContinuationField, this.continuationString);
                this.previousContinuationField = this.continuationField;
                this.continuationString = token2 + " ";
                continue;
            }
            if (!ignoreCompndFieldValues.contains(token2)) continue;
        }
        if (this.isLastCompndLine) {
            this.compndValueSetter(this.continuationField, this.continuationString);
            this.continuationString = "";
            this.compounds.add(this.current_compound);
        }
    }

    private void compndValueSetter(String field2, String value2) {
        value2 = value2.trim().replace(";", "");
        if (field2.equals("MOL_ID:")) {
            int i = -1;
            try {
                i = Integer.valueOf(value2);
            }
            catch (NumberFormatException e) {
                this.logger.fine(e.getMessage() + " while trying to parse COMPND line.");
            }
            if (this.molTypeCounter != i) {
                ++this.molTypeCounter;
                this.compounds.add(this.current_compound);
                this.current_compound = null;
                this.current_compound = new Compound();
            }
            this.current_compound.setMolId(value2);
        }
        if (field2.equals("MOLECULE:")) {
            this.current_compound.setMolName(value2);
        }
        if (field2.equals("CHAIN:")) {
            StringTokenizer chainTokens = new StringTokenizer(value2, ",");
            ArrayList<String> chains = new ArrayList<String>();
            while (chainTokens.hasMoreTokens()) {
                String chainID = chainTokens.nextToken().trim();
                if (chainID.equals("NULL")) {
                    chainID = " ";
                }
                chains.add(chainID);
            }
            this.current_compound.setChainId(chains);
        }
        if (field2.equals("SYNONYM:")) {
            StringTokenizer synonyms = new StringTokenizer(value2, ",");
            ArrayList<String> names = new ArrayList<String>();
            while (synonyms.hasMoreTokens()) {
                names.add(synonyms.nextToken());
                this.current_compound.setSynonyms(names);
            }
        }
        if (field2.equals("EC:")) {
            StringTokenizer ecNumTokens = new StringTokenizer(value2, ",");
            ArrayList<String> ecNums = new ArrayList<String>();
            while (ecNumTokens.hasMoreTokens()) {
                ecNums.add(ecNumTokens.nextToken());
                this.current_compound.setEcNums(ecNums);
            }
        }
        if (field2.equals("FRAGMENT:")) {
            this.current_compound.setFragment(value2);
        }
        if (field2.equals("ENGINEERED:")) {
            this.current_compound.setEngineered(value2);
        }
        if (field2.equals("MUTATION:")) {
            this.current_compound.setMutation(value2);
        }
        if (field2.equals("BIOLOGICAL_UNIT:")) {
            this.current_compound.setBiologicalUnit(value2);
        }
        if (field2.equals("OTHER_DETAILS:")) {
            this.current_compound.setDetails(value2);
        }
    }

    private void pdb_SOURCE_Handler(String line) {
        String[] fieldList;
        boolean sourceDebug = false;
        String continuationNr = line.substring(9, 10).trim();
        if (sourceDebug) {
            System.out.println("current continuationNo     is " + continuationNr);
            System.out.println("previousContinuationField  is " + this.previousContinuationField);
            System.out.println("current continuationField  is " + this.continuationField);
            System.out.println("current continuationString is " + this.continuationString);
            System.out.println("current compound           is " + this.current_compound);
        }
        if (line.length() > 72) {
            line = line.substring(0, 72);
        }
        line = line.substring(10, line.length());
        if (sourceDebug) {
            System.out.println("LINE: >" + line + "<");
        }
        if (!(fieldList = line.split("\\s+"))[0].equals("") && sourceFieldValues.contains(fieldList[0])) {
            this.continuationField = fieldList[0];
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (fieldList.length > 1 && sourceFieldValues.contains(fieldList[1])) {
            this.continuationField = fieldList[1];
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (continuationNr.equals("")) {
            if (sourceDebug) {
                System.out.println("looks like an old PDB file");
            }
            this.continuationField = "MOLECULE:";
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
        }
        line = line.replace(this.continuationField, "").trim();
        StringTokenizer compndTokens = new StringTokenizer(line);
        while (compndTokens.hasMoreTokens()) {
            String token2 = compndTokens.nextToken();
            if (this.previousContinuationField.equals("")) {
                this.previousContinuationField = this.continuationField;
            }
            if (this.previousContinuationField.equals(this.continuationField) && sourceFieldValues.contains(this.continuationField)) {
                if (sourceDebug) {
                    System.out.println("Still in field " + this.continuationField);
                }
                this.continuationString = this.continuationString.concat(token2 + " ");
                if (sourceDebug) {
                    System.out.println("continuationString = " + this.continuationString);
                }
            }
            if (!this.continuationField.equals(this.previousContinuationField)) {
                if (this.continuationString.equals("")) {
                    this.continuationString = token2;
                    continue;
                }
                this.sourceValueSetter(this.previousContinuationField, this.continuationString);
                this.previousContinuationField = this.continuationField;
                this.continuationString = token2 + " ";
                continue;
            }
            if (!ignoreCompndFieldValues.contains(token2)) continue;
        }
        if (this.isLastSourceLine) {
            this.sourceValueSetter(this.continuationField, this.continuationString);
            this.continuationString = "";
        }
    }

    private void sourceValueSetter(String field2, String value2) {
        value2 = value2.trim().replace(";", "");
        if (field2.equals("MOL_ID:")) {
            try {
                this.current_compound = this.compounds.get(Integer.valueOf(value2) - 1);
            }
            catch (Exception e) {
                this.logger.fine("could not process SOURCE MOL_ID record correctly:" + e.getMessage());
                return;
            }
        }
        if (field2.equals("SYNTHETIC:")) {
            this.current_compound.setSynthetic(value2);
        } else if (field2.equals("FRAGMENT:")) {
            this.current_compound.setFragment(value2);
        } else if (field2.equals("ORGANISM_SCIENTIFIC:")) {
            this.current_compound.setOrganismScientific(value2);
        } else if (field2.equals("ORGANISM_TAXID:")) {
            this.current_compound.setOrganismTaxId(value2);
        } else if (field2.equals("ORGANISM_COMMON:")) {
            this.current_compound.setOrganismCommon(value2);
        } else if (field2.equals("STRAIN:")) {
            this.current_compound.setStrain(value2);
        } else if (field2.equals("VARIANT:")) {
            this.current_compound.setVariant(value2);
        } else if (field2.equals("CELL_LINE:")) {
            this.current_compound.setCellLine(value2);
        } else if (field2.equals("ATCC:")) {
            this.current_compound.setAtcc(value2);
        } else if (field2.equals("ORGAN:")) {
            this.current_compound.setOrgan(value2);
        } else if (field2.equals("TISSUE:")) {
            this.current_compound.setTissue(value2);
        } else if (field2.equals("CELL:")) {
            this.current_compound.setCell(value2);
        } else if (field2.equals("ORGANELLE:")) {
            this.current_compound.setOrganelle(value2);
        } else if (field2.equals("SECRETION:")) {
            this.current_compound.setSecretion(value2);
        } else if (field2.equals("GENE:")) {
            this.current_compound.setGene(value2);
        } else if (field2.equals("CELLULAR_LOCATION:")) {
            this.current_compound.setCellularLocation(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM:")) {
            this.current_compound.setExpressionSystem(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_TAXID:")) {
            this.current_compound.setExpressionSystemTaxId(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_STRAIN:")) {
            this.current_compound.setExpressionSystemStrain(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_VARIANT:")) {
            this.current_compound.setExpressionSystemVariant(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_CELL_LINE:")) {
            this.current_compound.setExpressionSystemCellLine(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_ATCC_NUMBER:")) {
            this.current_compound.setExpressionSystemAtccNumber(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_ORGAN:")) {
            this.current_compound.setExpressionSystemOrgan(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_TISSUE:")) {
            this.current_compound.setExpressionSystemTissue(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_CELL:")) {
            this.current_compound.setExpressionSystemCell(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_ORGANELLE:")) {
            this.current_compound.setExpressionSystemOrganelle(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_CELLULAR_LOCATION:")) {
            this.current_compound.setExpressionSystemCellularLocation(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_VECTOR_TYPE:")) {
            this.current_compound.setExpressionSystemVectorType(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_VECTOR:")) {
            this.current_compound.setExpressionSystemVector(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_PLASMID:")) {
            this.current_compound.setExpressionSystemPlasmid(value2);
        } else if (field2.equals("EXPRESSION_SYSTEM_GENE:")) {
            this.current_compound.setExpressionSystemGene(value2);
        } else if (field2.equals("OTHER_DETAILS:")) {
            this.current_compound.setExpressionSystemOtherDetails(value2);
        }
    }

    private void pdb_REMARK_2_Handler(String line) {
        int i = line.indexOf("ANGSTROM");
        if (i != -1) {
            String resolution = line.substring(22, i).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                this.logger.fine(e.getMessage());
                this.logger.fine("could not parse resolution from line and ignoring it " + line);
                return;
            }
            this.header.put("resolution", new Float(res));
            this.pdbHeader.setResolution(res);
        }
    }

    private void pdb_REMARK_Handler(String line) {
        String l = line.substring(0, 11).trim();
        if (l.equals("REMARK   2")) {
            this.pdb_REMARK_2_Handler(line);
        }
        if (line.startsWith("REMARK 800")) {
            this.pdb_REMARK_800_Handler(line);
        } else if (line.startsWith("REMARK 350") && this.params.isParseBioAssembly()) {
            if (this.bioAssemblyParser == null) {
                this.bioAssemblyParser = new PDBBioAssemblyParser();
            }
            this.bioAssemblyParser.pdb_REMARK_350_Handler(line);
        }
    }

    private void pdb_EXPDTA_Handler(String line) {
        String technique = line.length() > 69 ? line.substring(10, 70).trim() : line.substring(10).trim();
        String t2 = (String)this.header.get("technique");
        t2 = t2 + technique + " ";
        this.header.put("technique", t2);
        this.pdbHeader.setTechnique(t2);
        int nmr = technique.indexOf("NMR");
        if (nmr != -1) {
            this.structure.setNmr(true);
        }
    }

    private void pdb_CRYST1_Handler(String line) {
        int z;
        float gamma2;
        float beta2;
        float alpha;
        float c;
        float b;
        float a;
        if (line.length() < 69) {
            return;
        }
        String spaceGroup = "";
        try {
            a = Float.parseFloat(line.substring(6, 15).trim());
            b = Float.parseFloat(line.substring(15, 24).trim());
            c = Float.parseFloat(line.substring(24, 33).trim());
            alpha = Float.parseFloat(line.substring(33, 40).trim());
            beta2 = Float.parseFloat(line.substring(40, 47).trim());
            gamma2 = Float.parseFloat(line.substring(47, 54).trim());
            z = Integer.parseInt(line.substring(66, 70).trim());
        }
        catch (NumberFormatException e) {
            this.logger.fine(e.getMessage());
            this.logger.fine("could not parse CRYST1 record from line and ignoring it " + line);
            return;
        }
        spaceGroup = line.substring(55, 66).trim();
        if (a == 1.0f && b == 1.0f && c == 1.0f && alpha == 90.0f && beta2 == 90.0f && gamma2 == 90.0f && spaceGroup.equals("P 1") && z == 1) {
            return;
        }
        this.crystallographicInfo.setA(a);
        this.crystallographicInfo.setB(b);
        this.crystallographicInfo.setC(c);
        this.crystallographicInfo.setAlpha(alpha);
        this.crystallographicInfo.setBeta(beta2);
        this.crystallographicInfo.setGamma(gamma2);
        this.crystallographicInfo.setSpaceGroup(spaceGroup);
        this.crystallographicInfo.setZ(z);
    }

    private void addTohetGroupsDecider(Group group) {
        boolean wanted = false;
        if (group.getPDBName().equals("HOH")) {
            return;
        }
        if (group.getChemComp() == null) {
            if (group.getType().equals("hetatm")) {
                wanted = true;
            }
        } else if (!group.getChemComp().isStandard()) {
            wanted = true;
        }
        if (wanted && !this.structure.getHetGroups().contains(group)) {
            this.structure.getHetGroups().add(group);
        }
    }

    private void pdb_ATOM_Handler(String line) throws PDBParseException {
        boolean startOfNewChain = false;
        String chain_id = line.substring(21, 22);
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setChainID(chain_id);
            startOfNewChain = true;
            this.current_model.add(this.current_chain);
        }
        if (!chain_id.equals(this.current_chain.getChainID())) {
            startOfNewChain = true;
            this.current_chain.addGroup(this.current_group);
            Chain testchain = this.isKnownChain(this.current_chain.getChainID(), this.current_model);
            if (testchain == null || !testchain.getChainID().equals(chain_id)) {
                testchain = this.isKnownChain(chain_id, this.current_model);
            }
            if (testchain == null) {
                this.current_chain = new ChainImpl();
                this.current_chain.setChainID(chain_id);
            } else {
                this.current_chain = testchain;
            }
            if (!this.current_model.contains(this.current_chain)) {
                this.current_model.add(this.current_chain);
            }
        }
        String recordName = line.substring(0, 6).trim();
        String groupCode3 = line.substring(17, 20);
        String resNum = line.substring(22, 26).trim();
        Character iCode = Character.valueOf(line.substring(26, 27).charAt(0));
        if (iCode.charValue() == ' ') {
            iCode = null;
        }
        ResidueNumber residueNumber = new ResidueNumber(chain_id, Integer.valueOf(resNum), iCode);
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            aminoCode1 = StructureTools.get1LetterCode(groupCode3);
        } else {
            aminoCode1 = StructureTools.get1LetterCode(groupCode3);
            if (aminoCode1 != null && aminoCode1.equals(StructureTools.UNKNOWN_GROUP_LABEL)) {
                aminoCode1 = null;
            }
        }
        if (this.current_group == null) {
            this.current_group = this.getNewGroup(recordName, aminoCode1, groupCode3);
            this.current_group.setPDBName(groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            this.addTohetGroupsDecider(this.current_group);
        }
        if (startOfNewChain) {
            this.current_group = this.getNewGroup(recordName, aminoCode1, groupCode3);
            this.current_group.setPDBName(groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            this.addTohetGroupsDecider(this.current_group);
        }
        Character altLoc = new Character(line.substring(16, 17).charAt(0));
        Group altGroup = null;
        if (!residueNumber.equals(this.current_group.getResidueNumber())) {
            this.current_chain.addGroup(this.current_group);
            this.current_group = this.getNewGroup(recordName, aminoCode1, groupCode3);
            this.current_group.setPDBName(groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            this.addTohetGroupsDecider(this.current_group);
        } else if (!altLoc.equals(Character.valueOf(' ')) && (altGroup = this.getCorrectAltLocGroup(altLoc, recordName, aminoCode1, groupCode3)).getChain() == null) {
            altGroup.setChain(this.current_chain);
        }
        if (this.params.isHeaderOnly()) {
            return;
        }
        ++this.atomCount;
        if (this.atomCount == this.my_ATOM_CA_THRESHOLD) {
            System.err.println("more than " + this.my_ATOM_CA_THRESHOLD + " atoms in this structure, ignoring the SEQRES lines");
            this.seqResChains.clear();
            this.switchCAOnly();
        }
        if (this.atomCount == this.load_max_atoms) {
            System.err.println("too many atoms (>" + this.load_max_atoms + "in this protein structure.");
            System.err.println("ignoring lines after: " + line);
            return;
        }
        if (this.atomCount > this.load_max_atoms) {
            return;
        }
        String fullname = line.substring(12, 16);
        if (this.parseCAonly && !fullname.equals(" CA ")) {
            --this.atomCount;
            return;
        }
        if (this.params.getAcceptedAtomNames() != null) {
            boolean found = false;
            for (String ok : this.params.getAcceptedAtomNames()) {
                if (!ok.equals(fullname)) continue;
                found = true;
                break;
            }
            if (!found) {
                --this.atomCount;
                return;
            }
        }
        int pdbnumber = Integer.parseInt(line.substring(6, 11).trim());
        AtomImpl atom = new AtomImpl();
        atom.setPDBserial(pdbnumber);
        atom.setAltLoc(altLoc);
        atom.setFullName(fullname);
        atom.setName(fullname.trim());
        double x2 = Double.parseDouble(line.substring(30, 38).trim());
        double y = Double.parseDouble(line.substring(38, 46).trim());
        double z = Double.parseDouble(line.substring(46, 54).trim());
        double[] coords = new double[]{x2, y, z};
        atom.setCoords(coords);
        double occu = 1.0;
        if (line.length() > 59) {
            try {
                occu = Double.parseDouble(line.substring(54, 60).trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double tempf = 0.0;
        if (line.length() > 65) {
            try {
                tempf = Double.parseDouble(line.substring(60, 66).trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        atom.setOccupancy(occu);
        atom.setTempFactor(tempf);
        Element element = Element.R;
        if (line.length() > 77) {
            try {
                element = Element.valueOfIgnoreCase(line.substring(76, 78).trim());
            }
            catch (IllegalArgumentException e) {}
        } else {
            String elementSymbol = null;
            elementSymbol = fullname.trim().length() == 4 ? fullname.substring(0, 1) : (fullname.trim().length() > 1 ? fullname.substring(0, 2).trim() : "R");
            try {
                element = Element.valueOfIgnoreCase(elementSymbol);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        atom.setElement(element);
        if (altGroup != null) {
            altGroup.addAtom(atom);
            altGroup = null;
        } else {
            this.current_group.addAtom(atom);
        }
    }

    private Group getCorrectAltLocGroup(Character altLoc, String recordName, Character aminoCode1, String groupCode3) {
        Group altLocG;
        Atom a1;
        List<Atom> atoms = this.current_group.getAtoms();
        if (atoms.size() > 0 && (a1 = atoms.get(0)).getAltLoc().equals(altLoc)) {
            return this.current_group;
        }
        List<Group> altLocs = this.current_group.getAltLocs();
        for (Group altLocG2 : altLocs) {
            atoms = altLocG2.getAtoms();
            if (atoms.size() <= 0) continue;
            for (Atom a12 : atoms) {
                if (!a12.getAltLoc().equals(altLoc)) continue;
                return altLocG2;
            }
        }
        if (groupCode3.equals(this.current_group.getPDBName())) {
            if (this.current_group.getAtoms().size() == 0) {
                return this.current_group;
            }
            altLocG = (Group)this.current_group.clone();
            altLocG.setAtoms(new ArrayList<Atom>());
            this.current_group.addAltLoc(altLocG);
            return altLocG;
        }
        altLocG = this.getNewGroup(recordName, aminoCode1, groupCode3);
        try {
            altLocG.setPDBName(groupCode3);
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        altLocG.setResidueNumber(this.current_group.getResidueNumber());
        this.current_group.addAltLoc(altLocG);
        return altLocG;
    }

    private void switchCAOnly() {
        this.parseCAonly = true;
        this.current_model = CAConverter.getCAOnly(this.current_model);
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            model = CAConverter.getCAOnly(model);
            this.structure.setModel(i, model);
        }
        this.current_chain = CAConverter.getCAOnly(this.current_chain);
    }

    private Integer conect_helper(String line, int start, int end) {
        String sbond = line.substring(start, end).trim();
        int bond = -1;
        Integer b = null;
        if (!sbond.equals("")) {
            bond = Integer.parseInt(sbond);
            b = new Integer(bond);
        }
        return b;
    }

    private void pdb_CONECT_Handler(String line) {
        if (this.atomOverflow) {
            return;
        }
        try {
            int atomserial = Integer.parseInt(line.substring(6, 11).trim());
            Integer bond1 = this.conect_helper(line, 11, 16);
            Integer bond2 = this.conect_helper(line, 16, 21);
            Integer bond3 = this.conect_helper(line, 21, 26);
            Integer bond4 = this.conect_helper(line, 26, 31);
            Integer hyd1 = this.conect_helper(line, 31, 36);
            Integer hyd2 = this.conect_helper(line, 36, 41);
            Integer salt1 = this.conect_helper(line, 41, 46);
            Integer hyd3 = this.conect_helper(line, 46, 51);
            Integer hyd4 = this.conect_helper(line, 51, 56);
            Integer salt2 = this.conect_helper(line, 56, 61);
            HashMap<String, Integer> cons = new HashMap<String, Integer>();
            cons.put("atomserial", new Integer(atomserial));
            if (bond1 != null) {
                cons.put("bond1", bond1);
            }
            if (bond2 != null) {
                cons.put("bond2", bond2);
            }
            if (bond3 != null) {
                cons.put("bond3", bond3);
            }
            if (bond4 != null) {
                cons.put("bond4", bond4);
            }
            if (hyd1 != null) {
                cons.put("hydrogen1", hyd1);
            }
            if (hyd2 != null) {
                cons.put("hydrogen2", hyd2);
            }
            if (salt1 != null) {
                cons.put("salt1", salt1);
            }
            if (hyd3 != null) {
                cons.put("hydrogen3", hyd3);
            }
            if (hyd4 != null) {
                cons.put("hydrogen4", hyd4);
            }
            if (salt2 != null) {
                cons.put("salt2", salt2);
            }
            this.connects.add(cons);
        }
        catch (Exception e) {
            this.logger.fine("could not parse CONECT line correctly.");
            this.logger.fine(e.getMessage() + " at line " + line);
            return;
        }
    }

    private void pdb_MODEL_Handler(String line) {
        if (this.current_chain != null) {
            Chain ch;
            if (this.current_group != null) {
                this.current_chain.addGroup(this.current_group);
            }
            if ((ch = this.isKnownChain(this.current_chain.getChainID(), this.current_model)) == null) {
                this.current_model.add(this.current_chain);
            }
            this.structure.addModel(this.current_model);
            this.current_model = new ArrayList<Chain>();
            this.current_chain = null;
            this.current_group = null;
        }
    }

    private void pdb_DBREF_Handler(String line) {
        DBRef dbref = new DBRef();
        String idCode = line.substring(7, 11);
        String chainId = line.substring(12, 13);
        String seqBegin = line.substring(14, 18);
        String insertBegin = line.substring(18, 19);
        String seqEnd = line.substring(20, 24);
        String insertEnd = line.substring(24, 25);
        String database = line.substring(26, 32);
        String dbAccession = line.substring(33, 41);
        String dbIdCode = line.substring(42, 54);
        String dbseqBegin = line.substring(55, 60);
        String idbnsBeg = line.substring(60, 61);
        String dbseqEnd = line.substring(62, 67);
        String dbinsEnd = line.substring(67, 68);
        dbref.setIdCode(idCode);
        dbref.setChainId(chainId);
        dbref.setSeqBegin(this.intFromString(seqBegin));
        dbref.setInsertBegin(insertBegin.charAt(0));
        dbref.setSeqEnd(this.intFromString(seqEnd));
        dbref.setInsertEnd(insertEnd.charAt(0));
        dbref.setDatabase(database.trim());
        dbref.setDbAccession(dbAccession.trim());
        dbref.setDbIdCode(dbIdCode.trim());
        dbref.setDbSeqBegin(this.intFromString(dbseqBegin));
        dbref.setIdbnsBegin(idbnsBeg.charAt(0));
        dbref.setDbSeqEnd(this.intFromString(dbseqEnd));
        dbref.setIdbnsEnd(dbinsEnd.charAt(0));
        this.dbrefs.add(dbref);
    }

    private void pdb_SSBOND_Handler(String line) {
        String chain1 = line.substring(15, 16);
        String seqNum1 = line.substring(17, 21).trim();
        String icode1 = line.substring(21, 22);
        String chain2 = line.substring(29, 30);
        String seqNum2 = line.substring(31, 35).trim();
        String icode2 = line.substring(35, 36);
        if (icode1.equals(" ")) {
            icode1 = "";
        }
        if (icode2.equals(" ")) {
            icode2 = "";
        }
        SSBond ssbond = new SSBond();
        ssbond.setChainID1(chain1);
        ssbond.setResnum1(seqNum1);
        ssbond.setChainID2(chain2);
        ssbond.setResnum2(seqNum2);
        ssbond.setInsCode1(icode1);
        ssbond.setInsCode2(icode2);
        this.structure.addSSBond(ssbond);
    }

    private void pdb_LINK_Handler(String line) {
        String name1 = line.substring(12, 16).trim();
        String altLoc1 = line.substring(16, 17).trim();
        String resName1 = line.substring(17, 20).trim();
        String chainID1 = line.substring(21, 22).trim();
        String resSeq1 = line.substring(22, 26).trim();
        String iCode1 = line.substring(26, 27).trim();
        String name2 = line.substring(42, 46).trim();
        String altLoc2 = line.substring(46, 47).trim();
        String resName2 = line.substring(47, 50).trim();
        String chainID2 = line.substring(51, 52).trim();
        String resSeq2 = line.substring(52, 56).trim();
        String iCode2 = line.substring(56, 57).trim();
        String sym1 = line.substring(59, 65).trim();
        String sym2 = line.substring(66, 72).trim();
        this.linkRecords.add(new PDBTemporaryStorageUtils.LinkRecord(name1, altLoc1, resName1, chainID1, resSeq1, iCode1, name2, altLoc2, resName2, chainID2, resSeq2, iCode2, sym1, sym2));
    }

    private void pdb_SITE_Handler(String line) {
        String siteID;
        List<ResidueNumber> siteResidues;
        boolean siteDebug = false;
        if (siteDebug) {
            System.out.println("Site Line:" + line);
        }
        if ((siteResidues = this.siteToResidueMap.get(siteID = line.substring(11, 14))) == null | !this.siteToResidueMap.containsKey(siteID.trim())) {
            siteResidues = new ArrayList<ResidueNumber>();
            this.siteToResidueMap.put(siteID.trim(), siteResidues);
            if (siteDebug) {
                System.out.println(String.format("New Site made: %s %s", siteID, siteResidues));
                System.out.println("Now made " + this.siteMap.size() + " sites");
            }
        }
        if (siteDebug) {
            System.out.println(String.format("SiteId: %s", siteID));
        }
        line = line.substring(18);
        String groupString = null;
        while (!(groupString = line.substring(0, 10)).equals("          ")) {
            String residueName;
            Character aminoCode1;
            if (siteDebug) {
                System.out.println("groupString: '" + groupString + "'");
            }
            if ((aminoCode1 = StructureTools.get1LetterCode(residueName = groupString.substring(0, 3))) != null && aminoCode1.equals(StructureTools.UNKNOWN_GROUP_LABEL)) {
                aminoCode1 = null;
            }
            String chainId = groupString.substring(4, 5);
            Integer resNum = Integer.valueOf(groupString.substring(5, 9).trim());
            Character insCode = Character.valueOf(groupString.substring(9, 10).charAt(0));
            if (siteDebug) {
                System.out.println(String.format("Site: %s: 'resName:%s resNum:%s insCode:%s'", siteID, residueName, resNum, insCode));
            }
            ResidueNumber residueNumber = new ResidueNumber();
            if (siteDebug) {
                System.out.println("pdbCode: '" + resNum + insCode + "'");
            }
            residueNumber.setChainId(chainId);
            residueNumber.setSeqNum(resNum);
            residueNumber.setInsCode(insCode);
            siteResidues.add(residueNumber);
            if (siteDebug) {
                System.out.println("Adding residueNumber " + residueNumber + " to site " + siteID);
            }
            line = line.substring(11);
        }
        if (siteDebug) {
            System.out.println("Current SiteMap (contains " + this.siteToResidueMap.keySet().size() + " sites):");
            for (String key : this.siteToResidueMap.keySet()) {
                System.out.println(key + " : " + this.siteToResidueMap.get(key));
            }
        }
    }

    private void pdb_REMARK_800_Handler(String line) {
        String[] fields;
        boolean remark800debug = false;
        if (remark800debug) {
            // empty if block
        }
        if ((fields = (line = line.substring(11)).split(": ")).length == 2) {
            if (fields[0].equals("SITE_IDENTIFIER")) {
                String siteID = fields[1].trim();
                if (remark800debug) {
                    System.out.println("siteID: '" + siteID + "'");
                }
                this.site = this.siteMap.get(siteID);
                if (this.site == null || !siteID.equals(this.site.getSiteID())) {
                    this.site = new Site(siteID, new ArrayList<Group>());
                    this.siteMap.put(this.site.getSiteID(), this.site);
                    if (remark800debug) {
                        System.out.print("New Site made: " + this.site);
                        System.out.println("Now made " + this.siteMap.size() + " sites");
                    }
                }
            }
            if (fields[0].equals("EVIDENCE_CODE")) {
                String evCode = fields[1].trim();
                if (remark800debug) {
                    System.out.println("evCode: '" + evCode + "'");
                }
                this.site.setEvCode(evCode);
            }
            if (fields[0].equals("SITE_DESCRIPTION")) {
                String desc = fields[1].trim();
                if (remark800debug) {
                    System.out.println("desc: '" + desc + "'");
                }
                this.site.setDescription(desc);
                if (remark800debug) {
                    System.out.println("Finished making REMARK 800 for site " + this.site.getSiteID());
                    System.out.print(this.site.remark800toPDB());
                }
            }
        }
    }

    private int intFromString(String intString) {
        int val = Integer.MIN_VALUE;
        try {
            val = Integer.parseInt(intString.trim());
        }
        catch (NumberFormatException ex) {
            this.logger.fine("NumberformatException: " + ex.getMessage());
        }
        return val;
    }

    private Chain isKnownChain(String chainID, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!chainID.equals(testchain.getChainID())) continue;
            return testchain;
        }
        return null;
    }

    private BufferedReader getBufferedReader(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new IOException("input stream is null!");
        }
        BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
        return buf;
    }

    public Structure parsePDBFile(InputStream inStream) throws IOException {
        BufferedReader buf;
        try {
            buf = this.getBufferedReader(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("error initializing BufferedReader");
        }
        return this.parsePDBFile(buf);
    }

    public Structure parsePDBFile(BufferedReader buf) throws IOException {
        this.load_max_atoms = this.params.getMaxAtoms();
        this.my_ATOM_CA_THRESHOLD = this.params.getAtomCaThreshold();
        this.structure = new StructureImpl();
        this.current_model = new ArrayList<Chain>();
        this.seqResChains = new ArrayList<Chain>();
        this.siteMap = new LinkedHashMap<String, Site>();
        this.current_chain = null;
        this.current_group = null;
        this.header = this.init_header();
        this.pdbHeader = new PDBHeader();
        this.connects = new ArrayList<Map<String, Integer>>();
        this.continuationField = "";
        this.continuationString = "";
        this.current_compound = new Compound();
        this.sourceLines.clear();
        this.compndLines.clear();
        this.isLastCompndLine = false;
        this.isLastSourceLine = false;
        this.molTypeCounter = 1;
        this.compounds.clear();
        this.helixList.clear();
        this.strandList.clear();
        this.turnList.clear();
        this.lengthCheck = -1;
        this.atomCount = 0;
        this.atomOverflow = false;
        this.linkRecords = new ArrayList<PDBTemporaryStorageUtils.LinkRecord>();
        this.parseCAonly = this.params.isParseCAOnly();
        String line = null;
        try {
            line = buf.readLine();
            String recordName = "";
            if (line == null) {
                throw new IOException("could not parse PDB File, BufferedReader returns null!");
            }
            while (line != null) {
                if (line.equals("") || line.equals(NEWLINE)) {
                    line = buf.readLine();
                    continue;
                }
                if (line.startsWith("TER") || line.startsWith("END")) {
                    line = buf.readLine();
                    continue;
                }
                if (line.length() < 6) {
                    System.err.println("found line length < 6. ignoring it. >" + line + "<");
                    line = buf.readLine();
                    continue;
                }
                try {
                    recordName = line.substring(0, 6).trim();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("StringIndexOutOfBoundsException at line >" + line + "<" + NEWLINE + "this does not look like an expected PDB file");
                    e.printStackTrace();
                    throw new StringIndexOutOfBoundsException(e.getMessage());
                }
                try {
                    if (recordName.equals("ATOM")) {
                        this.pdb_ATOM_Handler(line);
                    } else if (recordName.equals("SEQRES")) {
                        this.pdb_SEQRES_Handler(line);
                    } else if (recordName.equals("HETATM")) {
                        this.pdb_ATOM_Handler(line);
                    } else if (recordName.equals("MODEL")) {
                        this.pdb_MODEL_Handler(line);
                    } else if (recordName.equals("HEADER")) {
                        this.pdb_HEADER_Handler(line);
                    } else if (recordName.equals("AUTHOR")) {
                        this.pdb_AUTHOR_Handler(line);
                    } else if (recordName.equals("TITLE")) {
                        this.pdb_TITLE_Handler(line);
                    } else if (recordName.equals("SOURCE")) {
                        this.sourceLines.add(line);
                    } else if (recordName.equals("COMPND")) {
                        this.compndLines.add(line);
                    } else if (recordName.equals("JRNL")) {
                        this.pdb_JRNL_Handler(line);
                    } else if (recordName.equals("EXPDTA")) {
                        this.pdb_EXPDTA_Handler(line);
                    } else if (recordName.equals("CRYST1")) {
                        this.pdb_CRYST1_Handler(line);
                    } else if (recordName.equals("REMARK")) {
                        this.pdb_REMARK_Handler(line);
                    } else if (recordName.equals("CONECT")) {
                        this.pdb_CONECT_Handler(line);
                    } else if (recordName.equals("REVDAT")) {
                        this.pdb_REVDAT_Handler(line);
                    } else if (recordName.equals("DBREF")) {
                        this.pdb_DBREF_Handler(line);
                    } else if (recordName.equals("SITE")) {
                        this.pdb_SITE_Handler(line);
                    } else if (recordName.equals("SSBOND")) {
                        this.pdb_SSBOND_Handler(line);
                    } else if (recordName.equals("LINK")) {
                        this.pdb_LINK_Handler(line);
                    } else if (this.params.isParseSecStruc()) {
                        if (recordName.equals(HELIX)) {
                            this.pdb_HELIX_Handler(line);
                        } else if (recordName.equals("SHEET")) {
                            this.pdb_SHEET_Handler(line);
                        } else if (recordName.equals(TURN)) {
                            this.pdb_TURN_Handler(line);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("badly formatted line ... " + this.pdbId + ": " + line);
                }
                line = buf.readLine();
            }
            this.makeCompounds(this.compndLines, this.sourceLines);
            this.triggerEndFileChecks();
            if (this.params.shouldCreateAtomBonds()) {
                this.formBonds();
            }
        }
        catch (Exception e) {
            System.err.println(line);
            e.printStackTrace();
            throw new IOException("Error parsing PDB file " + this.structure.getPDBCode() + " at line: " + line);
        }
        if (this.params.isParseSecStruc()) {
            this.setSecStruc();
        }
        return this.structure;
    }

    private void makeCompounds(List<String> compoundList, List<String> sourceList) {
        for (String line : compoundList) {
            if (compoundList.indexOf(line) + 1 == compoundList.size()) {
                this.isLastCompndLine = true;
            }
            this.pdb_COMPND_Handler(line);
        }
        this.current_compound = this.compounds.size() == 0 ? new Compound() : this.compounds.get(0);
        for (String line : sourceList) {
            if (sourceList.indexOf(line) + 1 == sourceList.size()) {
                this.isLastSourceLine = true;
            }
            this.pdb_SOURCE_Handler(line);
        }
    }

    private void formBonds() {
        try {
            for (PDBTemporaryStorageUtils.LinkRecord linkRecord : this.linkRecords) {
                this.formLinkRecordBond(linkRecord);
            }
            for (SSBond disulfideBond : this.structure.getSSBonds()) {
                this.formDisulfideBond(disulfideBond);
            }
            this.formPeptideBonds();
            this.formIntraResidueBonds();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while forming bonds for " + this.pdbId, e);
        }
        this.trimAtomBondLists();
    }

    private void formLinkRecordBond(PDBTemporaryStorageUtils.LinkRecord linkRecord) {
        if (linkRecord.getAltLoc1().equals(" ") || linkRecord.getAltLoc2().equals(" ")) {
            return;
        }
        try {
            Atom a = this.getAtomFromRecord(linkRecord.getName1(), linkRecord.getAltLoc1(), linkRecord.getResName1(), linkRecord.getChainID1(), linkRecord.getResSeq1(), linkRecord.getiCode1());
            Atom b = this.getAtomFromRecord(linkRecord.getName2(), linkRecord.getAltLoc2(), linkRecord.getResName2(), linkRecord.getChainID2(), linkRecord.getResSeq2(), linkRecord.getiCode2());
            new Bond(a, b, 1);
        }
        catch (Exception e) {
            System.out.println("Error with the following link record: ");
            System.out.println(linkRecord);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void formDisulfideBond(SSBond disulfideBond) {
        try {
            Atom a = this.getAtomFromRecord("SG", "", "CYS", disulfideBond.getChainID1(), disulfideBond.getResnum1(), disulfideBond.getInsCode1());
            Atom b = this.getAtomFromRecord("SG", "", "CYS", disulfideBond.getChainID2(), disulfideBond.getResnum2(), disulfideBond.getInsCode2());
            new Bond(a, b, 1);
        }
        catch (StructureException e) {
            System.out.println("Error with the following SSBond: ");
            System.out.println(disulfideBond);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Atom getAtomFromRecord(String name, String altLoc, String resName, String chainID, String resSeq, String iCode) throws StructureException {
        if (iCode.isEmpty()) {
            iCode = " ";
        }
        Chain chain2 = this.structure.getChainByPDB(chainID);
        ResidueNumber resNum = new ResidueNumber(chainID, Integer.parseInt(resSeq), Character.valueOf(iCode.charAt(0)));
        Group group = chain2.getGroupByPDB(resNum);
        if (!altLoc.isEmpty()) {
            group = group.getAltLocGroup(Character.valueOf(altLoc.charAt(0)));
        }
        return group.getAtom(name);
    }

    private void formPeptideBonds() throws StructureException {
        for (Chain chain2 : this.structure.getChains()) {
            List<Group> groups = chain2.getSeqResGroups();
            for (int i = 0; i < groups.size() - 1; ++i) {
                Atom aminoN;
                Atom carboxylC;
                if (!(groups.get(i) instanceof AminoAcidImpl) || !(groups.get(i + 1) instanceof AminoAcidImpl)) continue;
                AminoAcidImpl current = (AminoAcidImpl)groups.get(i);
                AminoAcidImpl next2 = (AminoAcidImpl)groups.get(i + 1);
                if (current.getResidueNumber() == null || next2.getResidueNumber() == null) continue;
                try {
                    carboxylC = current.getC();
                    aminoN = next2.getN();
                }
                catch (StructureException e) {
                    continue;
                }
                if (!(Calc.getDistance(carboxylC, aminoN) < 1.8)) continue;
                new Bond(carboxylC, aminoN, 1);
            }
        }
    }

    private void formIntraResidueBonds() {
        for (Chain chain2 : this.structure.getChains()) {
            List<Group> groups = chain2.getAtomGroups();
            for (Group group : groups) {
                if (group.getResidueNumber() == null || group.isWater()) continue;
                ChemComp aminoChemComp = ChemCompGroupFactory.getChemComp(group.getPDBName());
                for (ChemCompBond chemCompBond : aminoChemComp.getBonds()) {
                    try {
                        Atom a = group.getAtom(chemCompBond.getAtom_id_1());
                        Atom b = group.getAtom(chemCompBond.getAtom_id_2());
                        int bondOrder = chemCompBond.getNumericalBondOrder();
                        new Bond(a, b, bondOrder);
                    }
                    catch (StructureException e) {}
                }
            }
        }
    }

    private void trimAtomBondLists() {
        for (Chain chain2 : this.structure.getChains()) {
            for (Group group : chain2.getAtomGroups()) {
                for (Atom atom : group.getAtoms()) {
                    ((ArrayList)atom.getBonds()).trimToSize();
                }
            }
        }
    }

    private void triggerEndFileChecks() {
        String modDate = (String)this.header.get("modDate");
        if (modDate.equals("0000-00-00")) {
            String depositionDate = (String)this.header.get("depDate");
            this.header.put("modDate", depositionDate);
            if (!depositionDate.equals(modDate)) {
                try {
                    Date dep = this.dateFormat.parse(depositionDate);
                    this.pdbHeader.setDepDate(dep);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.current_chain != null) {
            this.current_chain.addGroup(this.current_group);
            if (this.isKnownChain(this.current_chain.getChainID(), this.current_model) == null) {
                this.current_model.add(this.current_chain);
            }
        }
        if (!this.journalLines.isEmpty()) {
            this.buildjournalArticle();
            this.structure.setJournalArticle(this.journalArticle);
        }
        this.structure.addModel(this.current_model);
        this.structure.setHeader(this.header);
        this.structure.setPDBHeader(this.pdbHeader);
        this.structure.setCrystallographicInfo(this.crystallographicInfo);
        this.structure.setConnections(this.connects);
        this.structure.setCompounds(this.compounds);
        this.structure.setDBRefs(this.dbrefs);
        if (this.params.isAlignSeqRes()) {
            SeqRes2AtomAligner aligner = new SeqRes2AtomAligner();
            aligner.align(this.structure, this.seqResChains);
        } else if (this.params.getStoreEmptySeqRes()) {
            this.storeUnAlignedSeqRes(this.structure, this.seqResChains);
        }
        this.linkChains2Compound(this.structure);
        try {
            this.linkSitesToGroups();
        }
        catch (Exception e) {
            this.logger.fine("Error while linking SITE records to groups. ..");
            this.logger.fine(e.getMessage());
        }
        if (this.bioAssemblyParser != null) {
            this.bioAssemblyParser.finalizeCurrentBioMolecule();
            this.pdbHeader.setBioUnitTranformationMap(this.bioAssemblyParser.getTransformationMap());
            this.pdbHeader.setNrBioAssemblies(this.bioAssemblyParser.getNrBioAssemblies());
        }
    }

    private void storeUnAlignedSeqRes(Structure structure, List<Chain> seqResChains) {
        SeqRes2AtomAligner aligner = new SeqRes2AtomAligner();
        for (int i = 0; i < structure.nrModels(); ++i) {
            List<Chain> atomList = structure.getModel(i);
            for (Chain seqRes : seqResChains) {
                try {
                    Chain atomRes = aligner.getMatchingAtomRes(seqRes, atomList);
                    atomRes.setSeqResGroups(seqRes.getAtomGroups());
                }
                catch (StructureException e) {}
            }
        }
    }

    private void setSecStruc() {
        this.setSecElement(this.helixList, PDB_AUTHOR_ASSIGNMENT, HELIX);
        this.setSecElement(this.strandList, PDB_AUTHOR_ASSIGNMENT, STRAND);
        this.setSecElement(this.turnList, PDB_AUTHOR_ASSIGNMENT, TURN);
    }

    private void setSecElement(List<Map<String, String>> secList, String assignment, String type) {
        block0: for (Map<String, String> m : secList) {
            String initChainId = m.get("initChainId");
            String initSeqNum = m.get("initSeqNum");
            String initICode = m.get("initICode");
            String endChainId = m.get("endChainId");
            String endSeqNum = m.get("endSeqNum");
            String endICode = m.get("endICode");
            if (initICode.equals(" ")) {
                initICode = "";
            }
            if (endICode.equals(" ")) {
                endICode = "";
            }
            GroupIterator gi = new GroupIterator(this.structure);
            boolean inRange = false;
            while (gi.hasNext()) {
                String pdbCode;
                Group g = gi.next();
                Chain c = g.getChain();
                if (c.getChainID().equals(initChainId)) {
                    pdbCode = initSeqNum + initICode;
                    if (g.getResidueNumber().toString().equals(pdbCode)) {
                        inRange = true;
                    }
                }
                if (inRange && g instanceof AminoAcid) {
                    AminoAcid aa = (AminoAcid)g;
                    HashMap<String, String> assignmentMap = new HashMap<String, String>();
                    assignmentMap.put(assignment, type);
                    aa.setSecStruc(assignmentMap);
                }
                if (!c.getChainID().equals(endChainId) || !(pdbCode = endSeqNum + endICode).equals(g.getResidueNumber().toString())) continue;
                inRange = false;
                continue block0;
            }
        }
    }

    public void linkChains2Compound(Structure s) {
        List<Chain> chains;
        Compound comp;
        List<String> chainIds;
        List<Compound> compounds = s.getCompounds();
        for (Compound comp2 : compounds) {
            ArrayList<Chain> chains2 = new ArrayList<Chain>();
            chainIds = comp2.getChainId();
            if (chainIds == null) continue;
            for (String chainId : chainIds) {
                if (chainId.equals("NULL")) {
                    chainId = " ";
                }
                try {
                    Chain c = s.findChain(chainId);
                    chains2.add(c);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                }
            }
            comp2.setChains(chains2);
        }
        if (compounds.size() == 1 && (comp = compounds.get(0)).getChainId() == null && (chains = s.getChains(0)).size() == 1) {
            Chain ch = chains.get(0);
            chainIds = new ArrayList<String>();
            chainIds.add(ch.getChainID());
            comp.setChainId(chainIds);
            comp.addChain(ch);
        }
        for (Compound comp2 : compounds) {
            if (comp2.getChainId() == null) continue;
            for (String chainId : comp2.getChainId()) {
                if (chainId.equals("NULL")) continue;
                try {
                    Chain c = s.getChainByPDB(chainId);
                    c.setHeader(comp2);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void linkSitesToGroups() {
        if (this.siteMap == null || this.siteToResidueMap == null) {
            this.logger.fine("Sites can not be linked to residues!");
            return;
        }
        ArrayList<Site> sites = null;
        if (this.structure.getChains().isEmpty()) {
            sites = new ArrayList<Site>(this.siteMap.values());
            this.logger.fine("No chains to link Site Groups with - Sites will not be present in the Structure");
            return;
        }
        if (!this.siteMap.keySet().equals(this.siteToResidueMap.keySet())) {
            this.logger.fine("Not all sites have been properly described in the PDB " + this.pdbId + " header - some Sites will not be present in the Structure");
            this.logger.fine(this.siteMap.keySet() + " | " + this.siteToResidueMap.keySet());
        }
        for (String key : this.siteMap.keySet()) {
            Site currentSite = this.siteMap.get(key);
            List<ResidueNumber> linkedGroups = this.siteToResidueMap.get(key);
            if (linkedGroups == null) continue;
            for (ResidueNumber residueNumber : linkedGroups) {
                String pdbCode = residueNumber.toString();
                String chain2 = residueNumber.getChainId();
                Group linkedGroup = null;
                try {
                    linkedGroup = this.structure.findGroup(chain2, pdbCode);
                }
                catch (StructureException ex) {
                    Logger.getLogger(PDBFileParser.class.getName()).log(Level.FINE, "Can't find group " + pdbCode + " in chain " + chain2 + " in order to link up SITE records (PDB ID " + this.pdbId + ")");
                    continue;
                }
                currentSite.getGroups().add(linkedGroup);
            }
        }
        sites = new ArrayList<Site>(this.siteMap.values());
        this.structure.setSites(sites);
    }

    private void buildjournalArticle() {
        this.journalArticle = new JournalArticle();
        StringBuffer auth = new StringBuffer();
        StringBuffer titl = new StringBuffer();
        StringBuffer edit = new StringBuffer();
        StringBuffer ref = new StringBuffer();
        StringBuffer publ = new StringBuffer();
        StringBuffer refn = new StringBuffer();
        StringBuffer pmid = new StringBuffer();
        StringBuffer doi = new StringBuffer();
        for (String line : this.journalLines) {
            if (line.length() < 19) {
                this.logger.fine("can not process Journal line: " + line);
                continue;
            }
            String subField = line.substring(12, 16);
            if (subField.equals("AUTH")) {
                auth.append(line.substring(19, line.length()).trim());
            }
            if (subField.equals("TITL")) {
                titl.append(line.substring(19, line.length()).trim()).append(" ");
            }
            if (subField.equals("EDIT")) {
                edit.append(line.substring(19, line.length()).trim());
            }
            if (subField.equals("REF ")) {
                ref.append(line.substring(19, line.length()).trim()).append(" ");
            }
            if (subField.equals("PUBL")) {
                publ.append(line.substring(19, line.length()).trim()).append(" ");
            }
            if (subField.equals("REFN")) {
                if (line.length() < 35) {
                    this.logger.fine("can not process Journal REFN line: " + line);
                    continue;
                }
                refn.append(line.substring(35, line.length()).trim());
            }
            if (subField.equals("PMID")) {
                pmid.append(line.substring(19, line.length()).trim());
            }
            if (!subField.equals("DOI ")) continue;
            doi.append(line.substring(19, line.length()).trim());
        }
        this.journalArticle.setAuthorList(this.authorBuilder(auth.toString()));
        this.journalArticle.setEditorList(this.authorBuilder(edit.toString()));
        this.journalArticle.setRef(ref.toString());
        JournalParser journalParser = new JournalParser(ref.toString());
        this.journalArticle.setJournalName(journalParser.getJournalName());
        if (!this.journalArticle.getJournalName().equals("TO BE PUBLISHED")) {
            this.journalArticle.setIsPublished(true);
        }
        this.journalArticle.setVolume(journalParser.getVolume());
        this.journalArticle.setStartPage(journalParser.getStartPage());
        this.journalArticle.setPublicationDate(journalParser.getPublicationDate());
        this.journalArticle.setPublisher(publ.toString().trim());
        this.journalArticle.setTitle(titl.toString().trim());
        this.journalArticle.setRefn(refn.toString().trim());
        this.journalArticle.setPmid(pmid.toString().trim());
        this.journalArticle.setDoi(doi.toString().trim());
    }

    private List<Author> authorBuilder(String authorString) {
        ArrayList<Author> authorList = new ArrayList<Author>();
        if (authorString.equals("")) {
            return authorList;
        }
        String[] authors = authorString.split(",");
        if (authors.length == 1) {
            Author author = new Author();
            author.setSurname(authors[0]);
            authorList.add(author);
        } else {
            for (int i = 0; i < authors.length; ++i) {
                String authorFullName = authors[i];
                Author author = new Author();
                String regex = "\\.";
                String[] authorNames = authorFullName.split(regex);
                if (authorNames.length == 0) {
                    author.setSurname(authorFullName);
                } else if (authorNames.length == 1) {
                    author.setSurname(authorNames[0]);
                } else {
                    String initials = "";
                    for (int j = 0; j < authorNames.length - 1; ++j) {
                        String initial = authorNames[j];
                        initials = initials + initial + ".";
                    }
                    author.setInitials(initials);
                    int lastName = authorNames.length - 1;
                    String surname = authorNames[lastName];
                    author.setSurname(surname);
                }
                authorList.add(author);
            }
        }
        return authorList;
    }

    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
        this.load_max_atoms = params.getMaxAtoms();
        this.my_ATOM_CA_THRESHOLD = params.getAtomCaThreshold();
        if (!params.isLoadChemCompInfo()) {
            ChemCompGroupFactory.setChemCompProvider(new ReducedChemCompProvider());
        }
    }

    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    static {
        compndFieldValues = new ArrayList<String>(Arrays.asList("MOL_ID:", "MOLECULE:", "CHAIN:", "SYNONYM:", "EC:", "FRAGMENT:", "ENGINEERED:", "MUTATION:", "BIOLOGICAL_UNIT:", "OTHER_DETAILS:"));
        ignoreCompndFieldValues = new ArrayList<String>(Arrays.asList("HETEROGEN:", "ENGINEEREED:", "FRAGMENT,", "MUTANT:", "SYNTHETIC:"));
        sourceFieldValues = new ArrayList<String>(Arrays.asList("ENGINEERED:", "MOL_ID:", "SYNTHETIC:", "FRAGMENT:", "ORGANISM_SCIENTIFIC:", "ORGANISM_COMMON:", "ORGANISM_TAXID:", "STRAIN:", "VARIANT:", "CELL_LINE:", "ATCC:", "ORGAN:", "TISSUE:", "CELL:", "ORGANELLE:", "SECRETION:", "GENE:", "CELLULAR_LOCATION:", "EXPRESSION_SYSTEM:", "EXPRESSION_SYSTEM_TAXID:", "EXPRESSION_SYSTEM_STRAIN:", "EXPRESSION_SYSTEM_VARIANT:", "EXPRESSION_SYSTEM_CELL_LINE:", "EXPRESSION_SYSTEM_ATCC_NUMBER:", "EXPRESSION_SYSTEM_ORGAN:", "EXPRESSION_SYSTEM_TISSUE:", "EXPRESSION_SYSTEM_CELL:", "EXPRESSION_SYSTEM_ORGANELLE:", "EXPRESSION_SYSTEM_CELLULAR_LOCATION:", "EXPRESSION_SYSTEM_VECTOR_TYPE:", "EXPRESSION_SYSTEM_VECTOR:", "EXPRESSION_SYSTEM_PLASMID:", "EXPRESSION_SYSTEM_GENE:", "OTHER_DETAILS:"));
        NEWLINE = System.getProperty("line.separator");
    }

    private class JournalParser {
        private String journalName;
        private String volume;
        private String startPage;
        private int publicationDate;

        public JournalParser(String ref) {
            if (ref.equals("TO BE PUBLISHED ")) {
                this.journalName = ref.trim();
                return;
            }
            if (ref.length() < 48) {
                PDBFileParser.this.logger.fine("REF line too short - must be at least 48 characters to be valid for parsing.");
                this.journalName = "";
                this.volume = "";
                this.startPage = "";
                this.publicationDate = 0;
                return;
            }
            String volumeInformation = ref.substring(30, 48);
            String dateString = volumeInformation.substring(volumeInformation.length() - 5, volumeInformation.length() - 1).trim();
            String startPageString = volumeInformation.substring(volumeInformation.length() - 11, volumeInformation.length() - 6).trim();
            String volumeString = volumeInformation.substring(volumeInformation.length() - 16, volumeInformation.length() - 12).trim();
            String journalString = ref.substring(0, 29).trim() + " " + ref.substring(30, ref.length() - 1).replace(volumeInformation.trim(), "").trim();
            journalString = journalString.trim();
            if (!dateString.equals("    ")) {
                try {
                    this.publicationDate = Integer.valueOf(dateString);
                }
                catch (NumberFormatException nfe) {
                    PDBFileParser.this.logger.fine(dateString + " is not a valid integer for a date in JRNL sub-section REF line 1");
                }
            }
            if (!startPageString.equals("    ")) {
                this.startPage = startPageString;
            }
            if (!volumeString.equals("    ")) {
                this.volume = volumeString;
            }
            if (!journalString.equals("    ")) {
                this.journalName = journalString;
            }
        }

        private String getJournalName() {
            return this.journalName;
        }

        private int getPublicationDate() {
            return this.publicationDate;
        }

        private String getStartPage() {
            return this.startPage;
        }

        private String getVolume() {
            return this.volume;
        }
    }
}

