/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.fatcat;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.fatcat.FatCatFlexible;
import org.biojava.bio.structure.align.fatcat.FatCatRigid;
import org.biojava.bio.structure.align.fatcat.FatCatUserArgumentProcessor;
import org.biojava.bio.structure.align.fatcat.calc.FatCatAligner;
import org.biojava.bio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.bio.structure.align.model.AFPChain;

public class FatCat {
    public static final float VERSION = 1.0f;
    public static String newline = System.getProperty("line.separator");
    FatCatAligner aligner;

    public static void main(String[] argv) {
        FatCat cat2 = new FatCat();
        if (argv.length == 0) {
            System.out.println(cat2.printHelp());
            return;
        }
        if (argv.length == 1 && (argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("-help") || argv[0].equalsIgnoreCase("--help"))) {
            System.out.println(cat2.printHelp());
            return;
        }
        FatCatUserArgumentProcessor processor = new FatCatUserArgumentProcessor();
        processor.process(argv);
    }

    public String toString() {
        return "JFatCat v. 1.0";
    }

    public String printHelp() {
        StringBuffer buf = new StringBuffer();
        buf.append("-------------------").append(newline);
        buf.append("jFatCat v.1.0 help: " + newline);
        buf.append("-------------------").append(newline);
        buf.append(newline);
        buf.append("JFatCat accepts the following parameters:").append(newline);
        buf.append(newline);
        buf.append("--- pairwise alignents ---");
        buf.append("-pdbFilePath (mandatory) Path to the directory in your file system that contains the PDB files.").append(newline);
        buf.append("-pdb1 (mandatory) PDB ID of target structure. Chain IDs are optional. In order to specify chain IDs write e.g: 5pti.A").append(newline);
        buf.append("-pdb2 (mandatory) PDB ID of query structure. Chain IDs are optional. In order to specify chain IDs write e.g: 5pti.A").append(newline);
        buf.append("-h / -help / --help : print this help string.").append(newline);
        buf.append("-printXML true/false print the XML representation of the alignment on stdout.").append(newline);
        buf.append("-printFatCat true/false print the original FATCAT output to stdout.").append(newline);
        buf.append("-printCE true/false print the result in CE style").append(newline);
        buf.append("-show3d print a 3D visualisation of the alignment (requires jmolapplet.jar in classpath)").append(newline);
        buf.append("-outFile file to write the output to (writes XML representation).").append(newline);
        buf.append("-autoFetch true/false if set to true PDB files will automatically get downloaded and stored in the right location. (default: false)").append(newline);
        buf.append("-flexible true/false run flexible alignment (default: rigid body alignment, false). ").append(newline);
        buf.append("-pdbDirSplit true/false the directory containing PDB files has all PDBs in one level or is split into multiple subdirs, like the ftp site. (default: true)").append(newline);
        buf.append("-showMenu displays the menu that allows to run alignments through a user interface.");
        buf.append(newline);
        buf.append("--- database searches ---");
        buf.append("-alignPairs (mandatory) path to a file that contains a set of pairs to compair");
        buf.append("-outFile (mandatory) a file that will contain the summary of all the pairwise alignments");
        buf.append("-pdbFilePath (mandatory) Path to the directory in your file system that contains the PDB files.").append(newline);
        buf.append(newline);
        buf.append("For boolean arguments: if neither the text >true< or >false< is provided it is assumed to mean >true<. Instead of >-argument false< it is also possible to write -noArgument.").append(newline);
        buf.append("--- How to specify what to align ---");
        buf.append(newline);
        buf.append(" If only a PDB code is provided, the whole structure will be used for the alignment.").append(newline);
        buf.append(" To specify a particular chain write as: 4hhb.A (chain IDs are case sensitive, PDB ids are not)").append(newline);
        buf.append(" To specify that the 1st chain in a structure should be used write: 4hhb:0 .").append(newline);
        return buf.toString();
    }

    public AFPChain alignRigid(Atom[] ca1, Atom[] ca2) throws StructureException {
        FatCatRigid fatCat = new FatCatRigid();
        return fatCat.align(ca1, ca2);
    }

    public AFPChain alignRigid(Atom[] ca1, Atom[] ca2, FatCatParameters params) throws StructureException {
        AFPChain afpChain = this.align(ca1, ca2, params, true);
        afpChain.setAlgorithmName(FatCatRigid.algorithmName);
        afpChain.setVersion("1.0");
        return afpChain;
    }

    public AFPChain alignFlexible(Atom[] ca1, Atom[] ca2, FatCatParameters params) throws StructureException {
        AFPChain afpChain = this.align(ca1, ca2, params, false);
        afpChain.setAlgorithmName(FatCatFlexible.algorithmName);
        afpChain.setVersion("1.0");
        return afpChain;
    }

    protected AFPChain align(Atom[] ca1, Atom[] ca2, FatCatParameters params, boolean doRigid) throws StructureException {
        this.aligner = new FatCatAligner();
        this.aligner.align(ca1, ca2, doRigid, params);
        return this.aligner.getAfpChain();
    }

    public FatCatAligner getFatCatAligner() {
        if (this.aligner == null) {
            this.aligner = new FatCatAligner();
        }
        return this.aligner;
    }
}

