/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.GCDHelper;

public class ApintMath {
    private ApintMath() {
    }

    public static Apint pow(Apint x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (x2.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, x2.radix());
        }
        if (n < 0L) {
            return Apint.ZERO;
        }
        int b2pow = 0;
        while ((n & 1L) == 0L) {
            ++b2pow;
            n >>= 1;
        }
        Apint r = x2;
        while ((n >>= 1) > 0L) {
            x2 = x2.multiply(x2);
            if ((n & 1L) == 0L) continue;
            r = r.multiply(x2);
        }
        while (b2pow-- > 0) {
            r = r.multiply(r);
        }
        return r;
    }

    public static Apint[] sqrt(Apint x2) throws ArithmeticException, ApfloatRuntimeException {
        return ApintMath.root(x2, 2L);
    }

    public static Apint[] cbrt(Apint x2) throws ApfloatRuntimeException {
        return ApintMath.root(x2, 3L);
    }

    public static Apint[] root(Apint x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (x2.signum() == 0) {
                throw new ArithmeticException("Zeroth root of zero");
            }
            Apint one = new Apint(1L, x2.radix());
            return new Apint[]{one, x2.subtract(one)};
        }
        if (x2.signum() == 0) {
            return new Apint[]{x2, x2};
        }
        if (x2.equals(Apint.ONE) || n == 1L) {
            return new Apint[]{x2, Apint.ZERO};
        }
        if (n < 0L) {
            return new Apint[]{Apint.ZERO, x2};
        }
        long precision = x2.scale() / n + 20L;
        Apfloat approxX = x2.precision(precision);
        Apfloat approxRoot = ApfloatMath.root(approxX, n);
        Apint root2 = approxRoot.truncate();
        Apint pow = ApintMath.pow(root2, n);
        if (ApintMath.abs(pow).compareTo(ApintMath.abs(x2)) > 0) {
            pow = x2.signum() >= 0 ? ApintMath.powXMinus1(pow, root2, n) : ApintMath.powXPlus1(pow, root2, n);
            root2 = root2.subtract(new Apint((long)x2.signum(), x2.radix()));
        } else {
            Apint powPlus1;
            Apint apint = powPlus1 = x2.signum() >= 0 ? ApintMath.powXPlus1(pow, root2, n) : ApintMath.powXMinus1(pow, root2, n);
            if (ApintMath.abs(powPlus1).compareTo(ApintMath.abs(x2)) <= 0) {
                pow = powPlus1;
                root2 = root2.add(new Apint((long)x2.signum(), x2.radix()));
            }
        }
        Apint remainder = x2.subtract(pow);
        assert (remainder.signum() * x2.signum() >= 0);
        return new Apint[]{root2, remainder};
    }

    private static Apint powXMinus1(Apint pow, Apint x2, long n) throws ApfloatRuntimeException {
        Apint one = new Apint(1L, x2.radix());
        pow = n == 2L ? pow.subtract(x2).subtract(x2).add(one) : (n == 3L ? pow.subtract(new Apint(3L, x2.radix()).multiply(x2).multiply(x2.subtract(one))).subtract(one) : ApintMath.pow(x2.subtract(one), n));
        return pow;
    }

    private static Apint powXPlus1(Apint pow, Apint x2, long n) throws ApfloatRuntimeException {
        Apint one = new Apint(1L, x2.radix());
        pow = n == 2L ? pow.add(x2).add(x2).add(one) : (n == 3L ? pow.add(new Apint(3L, x2.radix()).multiply(x2).multiply(x2.add(one))).add(one) : ApintMath.pow(x2.add(one), n));
        return pow;
    }

    @Deprecated
    public static Apint negate(Apint x2) throws ApfloatRuntimeException {
        return x2.negate();
    }

    public static Apint abs(Apint x2) throws ApfloatRuntimeException {
        if (x2.signum() >= 0) {
            return x2;
        }
        return x2.negate();
    }

    public static Apint copySign(Apint x2, Apint y) throws ApfloatRuntimeException {
        if (y.signum() == 0) {
            return y;
        }
        if (x2.signum() != y.signum()) {
            return x2.negate();
        }
        return x2;
    }

    public static Apint scale(Apint x2, long scale) throws ApfloatRuntimeException {
        return ApfloatMath.scale(x2, scale).truncate();
    }

    public static Apint[] div(Apint x2, Apint y) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat ty;
        Apint b;
        if (y.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (x2.signum() == 0) {
            return new Apint[]{x2, x2};
        }
        if (y.equals(Apint.ONE)) {
            return new Apint[]{x2, Apint.ZERO};
        }
        Apint a = ApintMath.abs(x2);
        if (a.compareTo(b = ApintMath.abs(y)) < 0) {
            return new Apint[]{Apint.ZERO, x2};
        }
        long precision = x2.scale() - y.scale() + 20L;
        Apfloat tx = x2.precision(precision);
        Apint q = tx.divide(ty = y.precision(precision)).truncate();
        if ((a = a.subtract(ApintMath.abs(q.multiply(y)))).compareTo(b) >= 0) {
            q = q.add(new Apint((long)(x2.signum() * y.signum()), x2.radix()));
            a = a.subtract(b);
        } else if (a.signum() < 0) {
            q = q.subtract(new Apint((long)(x2.signum() * y.signum()), x2.radix()));
            a = a.add(b);
        }
        Apint r = ApintMath.copySign(a, x2);
        return new Apint[]{q, r};
    }

    public static Apint gcd(Apint a, Apint b) throws ApfloatRuntimeException {
        return GCDHelper.gcd(a, b);
    }

    public static Apint lcm(Apint a, Apint b) throws ApfloatRuntimeException {
        if (a.signum() == 0 && b.signum() == 0) {
            return Apint.ZERO;
        }
        return ApintMath.abs(a.multiply(b)).divide(ApintMath.gcd(a, b));
    }

    public static Apint modMultiply(Apint a, Apint b, Apint m) throws ApfloatRuntimeException {
        return a.multiply(b).mod(m);
    }

    private static Apint modMultiply(Apint x1, Apint x2, Apint y, Apfloat inverseY) throws ApfloatRuntimeException {
        Apint b;
        Apint x3 = x1.multiply(x2);
        if (x3.signum() == 0) {
            return x3;
        }
        long precision = x3.scale() - y.scale() + 20L;
        Apint a = ApintMath.abs(x3);
        if (a.compareTo(b = ApintMath.abs(y)) < 0) {
            return x3;
        }
        Apint t2 = x3.multiply(inverseY.precision(precision)).truncate();
        if ((a = a.subtract(ApintMath.abs(t2.multiply(y)))).compareTo(b) >= 0) {
            a = a.subtract(b);
        } else if (a.signum() < 0) {
            a = a.add(b);
        }
        t2 = ApintMath.copySign(a, x3);
        return t2;
    }

    public static Apint modPow(Apint a, Apint b, Apint m) throws ArithmeticException, ApfloatRuntimeException {
        Apint[] qr;
        if (b.signum() == 0) {
            if (a.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, a.radix());
        }
        if (m.signum() == 0) {
            return m;
        }
        m = ApintMath.abs(m);
        Apfloat inverseModulus = ApfloatMath.inverseRoot(m, 1L, m.scale() + 20L);
        a = a.mod(m);
        if (b.signum() < 0) {
            a = ApintMath.modInverse(a, m);
            b = b.negate();
        }
        Apint two = new Apint(2L, b.radix());
        while ((qr = ApintMath.div(b, two))[1].signum() == 0) {
            a = ApintMath.modMultiply(a, a, m, inverseModulus);
            b = qr[0];
        }
        Apint r = a;
        qr = ApintMath.div(b, two);
        while ((b = qr[0]).signum() > 0) {
            a = ApintMath.modMultiply(a, a, m, inverseModulus);
            qr = ApintMath.div(b, two);
            if (qr[1].signum() == 0) continue;
            r = ApintMath.modMultiply(r, a, m, inverseModulus);
        }
        return r;
    }

    private static Apint modInverse(Apint a, Apint m) throws ArithmeticException, ApfloatRuntimeException {
        Apint one = new Apint(1L, m.radix());
        Apint x2 = Apint.ZERO;
        Apint y = one;
        Apint oldX = one;
        Apint oldY = Apint.ZERO;
        Apint oldA = a;
        Apint b = m;
        while (b.signum() != 0) {
            Apint q = a.divide(b);
            Apint tmp = b;
            b = a.mod(b);
            a = tmp;
            tmp = x2;
            x2 = oldX.subtract(q.multiply(x2));
            oldX = tmp;
            tmp = y;
            y = oldY.subtract(q.multiply(y));
            oldY = tmp;
        }
        if (!ApintMath.abs(a).equals(one)) {
            throw new ArithmeticException("Modular inverse does not exist");
        }
        if (oldX.signum() != oldA.signum()) {
            oldX = oldX.add(ApintMath.copySign(m, oldA));
        }
        return oldX;
    }

    public static Apint factorial(long n) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        return new Apint(ApfloatMath.factorial(n, Long.MAX_VALUE));
    }

    public static Apint factorial(long n, int radix) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        return new Apint(ApfloatMath.factorial(n, Long.MAX_VALUE, radix));
    }

    public static Apint product(Apint ... x2) throws ApfloatRuntimeException {
        return new Apint(ApfloatMath.product(x2));
    }

    public static Apint sum(Apint ... x2) throws ApfloatRuntimeException {
        return new Apint(ApfloatMath.sum(x2));
    }
}

