/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigInteger;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formatter;
import java.util.IllegalFormatPrecisionException;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Aprational;
import org.apfloat.spi.ApfloatImpl;

public class Apint
extends Aprational {
    private static final long serialVersionUID = 5409721945040465491L;
    private Apfloat value;

    protected Apint() {
    }

    Apint(Apfloat value2) {
        this.value = value2;
    }

    public Apint(String value2) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(value2, true));
    }

    public Apint(String value2, int radix) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(value2, Long.MAX_VALUE, radix, true));
    }

    public Apint(long value2) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(value2));
    }

    public Apint(long value2, int radix) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(value2, Long.MAX_VALUE, radix));
    }

    public Apint(PushbackReader in) throws IOException, NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(in, Long.MAX_VALUE, true));
    }

    public Apint(PushbackReader in, int radix) throws IOException, NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(in, Long.MAX_VALUE, radix, true));
    }

    public Apint(BigInteger value2) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(value2);
    }

    public Apint(BigInteger value2, int radix) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(value2, Long.MAX_VALUE, radix);
    }

    public Apint numerator() {
        return this;
    }

    public Apint denominator() {
        return ONE;
    }

    public int radix() {
        return this.value.radix();
    }

    public long scale() throws ApfloatRuntimeException {
        return this.value.scale();
    }

    public long size() throws ApfloatRuntimeException {
        return this.value.size();
    }

    public int signum() {
        return this.value.signum();
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.value.isShort();
    }

    public Apint negate() throws ApfloatRuntimeException {
        return new Apint(this.value.negate());
    }

    public Apint add(Apint x2) throws ApfloatRuntimeException {
        return new Apint(this.value.add(x2.value));
    }

    public Apint subtract(Apint x2) throws ApfloatRuntimeException {
        return new Apint(this.value.subtract(x2.value));
    }

    public Apint multiply(Apint x2) throws ApfloatRuntimeException {
        return new Apint(this.value.multiply(x2.value));
    }

    public Apint divide(Apint x2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat ty;
        Apfloat b;
        if (x2.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.signum() == 0) {
            return this;
        }
        if (x2.equals(ONE)) {
            return this;
        }
        Apfloat a = ApfloatMath.abs(this.value);
        if (a.compareTo(b = ApfloatMath.abs(x2.value)) < 0) {
            return ZERO;
        }
        long precision = this.scale() - x2.scale() + 20L;
        Apfloat tx = this.value.precision(precision);
        Apint t2 = tx.divide(ty = x2.value.precision(precision)).truncate();
        if ((a = a.subtract(ApfloatMath.abs(t2.multiply(x2.value)))).compareTo(b) >= 0) {
            t2 = t2.add(new Apint((long)(this.signum() * x2.signum()), x2.radix()));
        } else if (a.signum() < 0) {
            t2 = t2.subtract(new Apint((long)(this.signum() * x2.signum()), x2.radix()));
        }
        return t2;
    }

    public Apint mod(Apint x2) throws ApfloatRuntimeException {
        return new Apint(this.value.mod(x2.value));
    }

    public Apint floor() {
        return this;
    }

    public Apint ceil() {
        return this;
    }

    public Apint truncate() {
        return this;
    }

    public BigInteger toBigInteger() throws IllegalArgumentException {
        if (this.signum() == 0) {
            return BigInteger.ZERO;
        }
        return ApfloatHelper.toBigInteger(this);
    }

    public Apint toRadix(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return new Apint(this.value.toRadix(radix));
    }

    public int compareTo(Apint x2) {
        return this.value.compareTo(x2.value);
    }

    public int compareTo(Aprational x2) {
        if (x2 instanceof Apint) {
            return this.compareTo((Apint)x2);
        }
        return super.compareTo(x2);
    }

    public int compareTo(Apfloat x2) {
        if (x2 instanceof Aprational) {
            return this.compareTo((Aprational)x2);
        }
        return this.value.compareTo(x2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Apint) {
            Apint that = (Apint)obj;
            return this.value.equals(that.value);
        }
        if (obj instanceof Apfloat && !(obj instanceof Aprational)) {
            Apfloat that = (Apfloat)obj;
            return this.value.equals(that);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString(boolean pretty) throws ApfloatRuntimeException {
        return this.value.toString(pretty);
    }

    public void writeTo(Writer out, boolean pretty) throws IOException, ApfloatRuntimeException {
        this.value.writeTo(out, pretty);
    }

    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if ((flags & 4) == 4) {
            throw new FormatFlagsConversionMismatchException("#", 's');
        }
        if (precision != -1) {
            throw new IllegalFormatPrecisionException(precision);
        }
        this.value.formatTo(formatter, flags | 4, width, precision);
    }

    protected ApfloatImpl getImpl(long precision) throws ApfloatRuntimeException {
        return this.value.getImpl(precision);
    }
}

