/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.NonNumericalException;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.Date;

class EvaluationUtil {
    private EvaluationUtil() {
    }

    static String getString(TemplateScalarModel model, Expression expr, Environment env) throws TemplateException {
        String value2 = model.getAsString();
        if (value2 == null) {
            if (env.isClassicCompatible()) {
                return "";
            }
            throw new TemplateException(expr + " evaluated to null string.", env);
        }
        return value2;
    }

    static Number getNumber(Expression expr, Environment env) throws TemplateException {
        TemplateModel model = expr.getAsTemplateModel(env);
        return EvaluationUtil.getNumber(model, expr, env);
    }

    static Number getNumber(TemplateModel model, Expression expr, Environment env) throws TemplateException {
        if (model instanceof TemplateNumberModel) {
            return EvaluationUtil.getNumber((TemplateNumberModel)model, expr, env);
        }
        if (model == null) {
            throw new InvalidReferenceException(expr + " is undefined.", env);
        }
        throw new NonNumericalException(expr + " is not a number, it is " + model.getClass().getName(), env);
    }

    static Number getNumber(TemplateNumberModel model, Expression expr, Environment env) throws TemplateModelException, TemplateException {
        Number value2 = model.getAsNumber();
        if (value2 == null) {
            throw new TemplateException(expr + " evaluated to null number.", env);
        }
        return value2;
    }

    static Date getDate(TemplateDateModel model, Expression expr, Environment env) throws TemplateModelException, TemplateException {
        Date value2 = model.getAsDate();
        if (value2 == null) {
            throw new TemplateException(expr + " evaluated to null date.", env);
        }
        return value2;
    }
}

