/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.util.List;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.MMCIFFileReader;
import org.biojava3.structure.StructureIO;

public class DemoMMCIFReader {
    public static void main(String[] args) {
        DemoMMCIFReader demo = new DemoMMCIFReader();
        demo.loadSimple();
    }

    public void loadSimple() {
        String pdbId = "4hhb";
        AtomCache cache = new AtomCache();
        cache.setUseMmCif(true);
        StructureIO.setAtomCache(cache);
        try {
            Structure s = StructureIO.getStructure(pdbId);
            System.out.println(pdbId + " has nr atoms: " + StructureTools.getNrAtoms(s));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFromDirectAccess() {
        String pdbId = "1A4W";
        MMCIFFileReader pdbreader = new MMCIFFileReader();
        try {
            pdbreader.setAutoFetch(true);
            Structure s = pdbreader.getStructureById(pdbId);
            Chain h = s.getChainByPDB("H");
            List<Group> ligands = h.getAtomLigands();
            System.out.println("These ligands have been found in chain " + h.getChainID());
            for (Group l : ligands) {
                System.out.println(l);
            }
            System.out.println("Accessing QWE directly: ");
            Group qwe = h.getGroupByPDB(new ResidueNumber("H", 373, null));
            System.out.println(qwe.getChemComp());
            System.out.println(h.getSeqResSequence());
            System.out.println(h.getAtomSequence());
            System.out.println(h.getAtomGroups("hetatm"));
            System.out.println("Compounds: " + s.getCompounds());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

