/*
 * Decompiled with CFR 0.152.
 */
package demo;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava3.structure.StructureIO;

public class DemoLoadStructure {
    public static void main(String[] args) {
        DemoLoadStructure demo = new DemoLoadStructure();
        demo.loadStructureIO();
    }

    public void loadStructureIO() {
        try {
            Structure s1 = StructureIO.getStructure("1gav");
            System.out.println(s1.getPDBCode() + " asym unit has nr atoms:");
            System.out.println(StructureTools.getNrAtoms(s1));
            Structure s2 = StructureIO.getBiologicalAssembly("1gav");
            System.out.println(s2.getPDBCode() + " biological assembly has nr atoms:");
            System.out.println(StructureTools.getNrAtoms(s2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void basicLoad() {
        try {
            PDBFileReader reader = new PDBFileReader();
            reader.setPath("/tmp");
            reader.setPdbDirectorySplit(true);
            reader.setAutoFetch(true);
            FileParsingParameters params = new FileParsingParameters();
            params.setAlignSeqRes(true);
            params.setParseSecStruc(false);
            reader.setFileParsingParameters(params);
            Structure structure = reader.getStructureById("4hhb");
            System.out.println(structure);
            Chain c = structure.getChainByPDB("C");
            System.out.print(c);
            System.out.println(c.getHeader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadStructureFromCache() {
        String pdbId = "4hhb";
        String chainName = "4hhb.A";
        String entityName = "4hhb:0";
        System.setProperty("biojava.cache.files", "true");
        AtomCache cache = new AtomCache();
        try {
            System.out.println("======================");
            Structure s = cache.getStructure(pdbId);
            System.out.println("Full Structure:" + s);
            Atom[] ca = cache.getAtoms(chainName);
            System.out.println("got " + ca.length + " CA atoms");
            Structure firstEntity = cache.getStructure(entityName);
            System.out.println("First entity: " + firstEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

