/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.Path;
import java.util.Stack;

final class PathBuilder {
    private final Stack<String> keys = new Stack();
    private Path result;

    PathBuilder() {
    }

    private void checkCanAppend() {
        if (this.result != null) {
            throw new ConfigException.BugOrBroken("Adding to PathBuilder after getting result");
        }
    }

    void appendKey(String string2) {
        this.checkCanAppend();
        this.keys.push(string2);
    }

    void appendPath(Path path) {
        this.checkCanAppend();
        String string2 = path.first();
        Path path2 = path.remainder();
        while (true) {
            this.keys.push(string2);
            if (path2 == null) break;
            string2 = path2.first();
            path2 = path2.remainder();
        }
    }

    Path result() {
        if (this.result == null) {
            Path path = null;
            while (!this.keys.isEmpty()) {
                String string2 = this.keys.pop();
                path = new Path(string2, path);
            }
            this.result = path;
        }
        return this.result;
    }
}

