/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.report;

import com.clineff.Workflow;
import com.clineff.commandLine.ClinEff;
import com.clineff.report.ReportFormat;
import com.clineff.report.VariantReport;
import com.clineff.report.VcfReport;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;

public abstract class ReportBase
implements VcfReport {
    public static final String SAMPLENAME_NULL_NAME = "ALL";
    protected String[] templateDirs = new String[]{"./report", "./resources", "./bin/resources"};
    protected boolean debug;
    protected Config config;
    protected int countVcfEntries = 0;
    protected int countVcfEntriesPass = 0;
    protected int countVcfEffPass = 0;
    protected boolean noCommas;
    protected ReportFormat reportFormat;
    protected List<String> sampleNames;
    protected Map<String, Integer> sampleNames2Num;
    protected List<VariantReport> variantsReport;
    protected List<VcfEntry> vcfEntries = new LinkedList<VcfEntry>();
    protected List<VcfEntry> vcfEntryReport;
    protected VcfFileIterator vcfFile;
    protected boolean verbose;
    protected Workflow workflow;

    public ReportBase() {
        this.variantsReport = new LinkedList<VariantReport>();
        this.vcfEntryReport = new LinkedList<VcfEntry>();
        this.reportFormat = ReportFormat.HTML;
    }

    @Override
    public boolean createReport(String outputFileNoExt, String sampleName) {
        try {
            String[] templateBaseDirs;
            String outputFile = String.valueOf(outputFileNoExt) + "." + this.reportFormat.toString().toLowerCase();
            if (this.verbose) {
                Timer.showStdErr("Creating report '" + this.getClass().getSimpleName() + "' " + (sampleName != null ? " for sample '" + sampleName + "'," : "") + " output file: " + outputFile);
            }
            if (this.reportFormat == ReportFormat.CSV) {
                this.noCommas = true;
            }
            Configuration cfg = new Configuration();
            String templateFileName = this.templateFileName();
            boolean found = false;
            String[] stringArray = templateBaseDirs = new String[]{".", this.config.getDirMain()};
            int n = templateBaseDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String templateBase = stringArray[n2];
                String[] stringArray2 = this.templateDirs;
                int n3 = this.templateDirs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String templateDir = stringArray2[n4];
                    String templateFile = String.valueOf(templateBase) + "/" + templateDir + "/" + templateFileName;
                    if (Gpr.exists(templateFile)) {
                        if (this.verbose) {
                            Timer.showStdErr("\tUsing template '" + templateFile + "'");
                        }
                        found = true;
                        cfg.setDirectoryForTemplateLoading(new File(templateFile).getParentFile());
                        break;
                    }
                    if (this.verbose) {
                        Timer.showStdErr("\tTemplate '" + templateFile + "' not found.");
                    }
                    ++n4;
                }
                if (found) break;
                ++n2;
            }
            if (!found) {
                cfg.setClassForTemplateLoading(ClinEff.class, "/");
            }
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            cfg.setLocale(Locale.US);
            if (this.noCommas) {
                cfg.setNumberFormat("0.######");
            }
            HashMap<String, Object> root2 = this.reportHash(sampleName);
            Template temp = cfg.getTemplate(this.templateFileName());
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(outputFile)));
            temp.process(root2, out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            this.error(e, "Error creating summary: " + e.getMessage());
            return false;
        }
        catch (TemplateException e) {
            this.error(e, "Error creating summary: " + e.getMessage());
            return false;
        }
        return true;
    }

    public void error(Throwable e, String message) {
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        System.err.println("Error: " + message);
    }

    public abstract boolean filter(VcfEntry var1);

    public List<VariantReport> getVariantsReport() {
        return this.variantsReport;
    }

    @Override
    public boolean report(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getVcfHeader().getSampleNames();
            int num = 0;
            this.sampleNames2Num = new HashMap<String, Integer>();
            for (String sn : this.sampleNames) {
                this.sampleNames2Num.put(sn, num++);
            }
        }
        if (this.filter(vcfEntry)) {
            this.vcfEntries.add(vcfEntry);
            return true;
        }
        return false;
    }

    @Override
    public boolean reportFinish() {
        return true;
    }

    protected HashMap<String, Object> reportHash(String sampleName) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        for (String key : this.config.keys()) {
            data2.put(key, this.config.getString(key));
        }
        for (String key : this.workflow.keys()) {
            data2.put(key, this.workflow.getString(key));
        }
        int sampleNum = this.sampleNum(sampleName);
        if (sampleName == null) {
            sampleName = SAMPLENAME_NULL_NAME;
        }
        data2.put("sampleName", sampleName);
        data2.put("sampleNumber", sampleNum);
        data2.put("moduleName", this.getClass().getSimpleName());
        data2.put("vcfEntriesCount", this.vcfEntries.size());
        data2.put("vcfEntriesTotalCount", this.countVcfEntries);
        data2.put("vcfEntriesPassCount", this.countVcfEntriesPass);
        data2.put("vcfEffectPassCount", this.countVcfEffPass);
        data2.put("vcfEntriesReportedCount", this.vcfEntryReport.size());
        return data2;
    }

    @Override
    public boolean reportInit(VcfFileIterator vcfFile) {
        this.vcfFile = vcfFile;
        return true;
    }

    protected int sampleNum(String sampleName) {
        if (sampleName == null) {
            return -1;
        }
        return this.sampleNames2Num.get(sampleName);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setReportFormat(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    protected String templateFileName() {
        return this.getClass().getSimpleName().toLowerCase() + "." + this.reportFormat.toString().toLowerCase() + ".flt";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reporter: " + this.getClass().getSimpleName() + ", size: " + this.vcfEntries.size() + "\n");
        for (VcfEntry ve : this.vcfEntries) {
            sb.append("\t" + ve.toStr() + "\n");
        }
        return sb.toString();
    }
}

