/*
 * Decompiled with CFR 0.152.
 */
package com.clineff;

import com.clineff.ModuleNamesMap;
import com.clineff.report.ReportFormat;
import com.clineff.report.VcfReport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.VcfAnnotator;
import org.snpeff.snpEffect.commandLine.CommandLine;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdDbNsfp;
import org.snpsift.SnpSiftCmdGeneSets;
import org.snpsift.SnpSiftCmdGwasCatalog;

public class Workflow {
    public static final String DEFAULT_WORKFLOW_FILE = "workflow.config";
    public static final String WORKFLOW_ANNOTATION_DBS_VCF = "annotation.db.vcf";
    public static final String WORKFLOW_DATABASE_DBNSFP = "database.dbnsfp";
    public static final String WORKFLOW_DATABASE_GENESETS = "database.geneSets";
    public static final String WORKFLOW_DATABASE_GWAS = "database.gwascatalog";
    public static final String WORKFLOW_DBNSFP_FIELDS = "dbnsfp.fields";
    public static final String WORKFLOW_FILTER = "filter";
    public static final String WORKFLOW_FILTERS = "filters";
    public static final String WORKFLOW_MODULES_ANNOTATION = "modules.annotation";
    public static final String WORKFLOW_MODULES_REPORT = "modules.report";
    boolean debug = false;
    boolean verbose = false;
    String workflowFile;
    Config config;
    Properties properties;
    ReportFormat reportFormat = ReportFormat.HTML;

    public Workflow(String workflowFile, Config config, boolean verbose) {
        this.workflowFile = workflowFile;
        this.config = config;
        this.verbose = verbose;
        this.readProperties(workflowFile);
    }

    public void configArguments(String moduleName, CommandLine commandLine) {
        String mod = commandLine.getClass().getName();
        Set<String> modNames = ModuleNamesMap.get().getModuleNames(mod);
        if (modNames == null) {
            throw new RuntimeException("Could not find names for module '" + mod + "'");
        }
        if (commandLine instanceof SnpSift) {
            SnpSift snpSift = (SnpSift)commandLine;
            snpSift.setShowVcfHeader(false);
            snpSift.setVcfHeaderAddProgramVersion(false);
        }
        switch (commandLine.getClass().getSimpleName()) {
            case "SnpSiftCmdGwasCatalog": {
                this.configArgumentsGwasCat((SnpSiftCmdGwasCatalog)commandLine);
                break;
            }
            case "SnpSiftCmdDbNsfp": {
                this.configArgumentsDbNsfp((SnpSiftCmdDbNsfp)commandLine);
                break;
            }
            case "SnpSiftCmdGeneSets": {
                this.configArgumentsGeneSets((SnpSiftCmdGeneSets)commandLine);
            }
        }
        for (String modName : modNames) {
            String argLine;
            String propertyName = "args." + modName;
            if (this.debug) {
                Timer.showStdErr("Looking for arguments for module '" + moduleName + "' (workflow entry '" + propertyName + "')");
            }
            if ((argLine = this.getString(propertyName)) == null || argLine.trim().isEmpty()) continue;
            String[] args = argLine.split("\\s+");
            if (this.verbose) {
                Timer.showStdErr("Found arguments for module '" + moduleName + "' (workflow entry '" + propertyName + "'):\t'" + argLine + "'");
            }
            commandLine.parseArgs(args);
            return;
        }
    }

    void configArgumentsDbNsfp(SnpSiftCmdDbNsfp cmd) {
        String dbNsfpFields;
        String dbNsfpFileName = this.getString(WORKFLOW_DATABASE_DBNSFP);
        if (dbNsfpFileName != null) {
            cmd.setDbFileName(dbNsfpFileName);
        }
        if ((dbNsfpFields = this.getString(WORKFLOW_DBNSFP_FIELDS)) != null) {
            cmd.setFieldsNamesToAdd(dbNsfpFields);
        }
    }

    void configArgumentsGeneSets(SnpSiftCmdGeneSets cmd) {
        String msigDb = this.getString(WORKFLOW_DATABASE_GENESETS);
        if (msigDb != null) {
            cmd.setMsigdb(msigDb);
        }
    }

    void configArgumentsGwasCat(SnpSiftCmdGwasCatalog cmd) {
        String dbFileName = this.getString(WORKFLOW_DATABASE_GWAS);
        if (dbFileName != null) {
            cmd.setDbFileName(dbFileName);
        }
    }

    public void configArgumentsReport(VcfReport vcfReport) {
        vcfReport.setWorkflow(this);
        vcfReport.setConfig(this.config);
        vcfReport.setVerbose(this.verbose);
        vcfReport.setDebug(this.debug);
        vcfReport.setReportFormat(this.reportFormat);
    }

    public List<String> getAnnotaionDbsVcf() {
        return this.getList(WORKFLOW_ANNOTATION_DBS_VCF, "", false);
    }

    public List<String> getFilters() {
        return this.getList(WORKFLOW_FILTERS, "", false);
    }

    public List<String> getList(String key, String defaultValue, boolean addEmpty) {
        ArrayList<String> vcfs = new ArrayList<String>();
        String vals = this.getString(key, defaultValue);
        String[] stringArray = vals.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value2 = stringArray[n2];
            value2 = value2.trim();
            if (addEmpty) {
                vcfs.add(value2);
            } else if (!value2.isEmpty()) {
                vcfs.add(value2);
            }
            ++n2;
        }
        return vcfs;
    }

    String getRelativeworkflowPath() {
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            File path = new File(url.toURI());
            return path.getParent();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get path '" + url + "'", e);
        }
    }

    public String getString(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public String getString(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public List<String> keys() {
        Set<Object> keyset = this.properties.keySet();
        ArrayList<String> l = new ArrayList<String>(keyset.size());
        for (Object o : keyset) {
            l.add(o.toString());
        }
        return l;
    }

    boolean load(String fileName) {
        try {
            File wfFile = new File(fileName);
            if (this.verbose) {
                Timer.showStdErr("Reading workflow file: " + wfFile.getCanonicalPath());
            }
            if (Gpr.canRead(fileName)) {
                this.properties.load(new FileReader(wfFile));
                return true;
            }
        }
        catch (Exception e) {
            this.properties = null;
        }
        return false;
    }

    public List<VcfAnnotator> modulesAnnotation() {
        List<String> moduleNames = this.getList(WORKFLOW_MODULES_ANNOTATION, "", false);
        ArrayList<VcfAnnotator> modules = new ArrayList<VcfAnnotator>();
        for (String moduleName : moduleNames) {
            if (this.verbose) {
                Timer.showStdErr("Adding annotation module : '" + moduleName + "'");
            }
            try {
                Class moduleClass = ModuleNamesMap.get().getModuleClass(moduleName);
                VcfAnnotator vcfAnnotator = (VcfAnnotator)moduleClass.newInstance();
                this.configArguments(moduleName, vcfAnnotator);
                modules.add(vcfAnnotator);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create annotation module '" + moduleName + "'", e);
            }
        }
        return modules;
    }

    public List<VcfReport> modulesReport() {
        List<String> moduleNames = this.getList(WORKFLOW_MODULES_REPORT, "", false);
        ArrayList<VcfReport> modules = new ArrayList<VcfReport>();
        for (String module : moduleNames) {
            if (this.verbose) {
                Timer.showStdErr("Adding annotation module : '" + module + "'");
            }
            try {
                Class<?> moduleClass = Class.forName(module);
                VcfReport vcfReport = (VcfReport)moduleClass.newInstance();
                this.configArgumentsReport(vcfReport);
                modules.add(vcfReport);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create annotation module '" + module + "'", e);
            }
        }
        return modules;
    }

    String readProperties(String fileName) {
        this.properties = new Properties();
        try {
            File wfFile = new File(fileName);
            if (this.load(fileName)) {
                return fileName;
            }
            if (wfFile.isAbsolute()) {
                throw new RuntimeException("Cannot read workflow file '" + wfFile.getCanonicalPath() + "'");
            }
            String confPath = String.valueOf(this.getRelativeworkflowPath()) + "/" + fileName;
            wfFile = new File(confPath);
            if (this.load(confPath)) {
                return confPath;
            }
            throw new RuntimeException("Cannot read workflow file '" + fileName + "'\n");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find workflow file '" + fileName + "'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String readProperties(String fileName, Map<String, String> override) {
        String workflowFile = this.readProperties(fileName);
        if (override != null) {
            for (String key : override.keySet()) {
                this.properties.setProperty(key, override.get(key));
            }
        }
        return workflowFile;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Workflow '" + this.workflowFile + "':");
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : this.properties.keySet()) {
            keys.add(object.toString());
        }
        Collections.sort(keys);
        for (String string2 : keys) {
            sb.append("\t" + string2 + " = '" + this.properties.getProperty(string2) + "'\n");
        }
        return sb.toString();
    }
}

