/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.genotypes;

import java.io.Serializable;
import org.snpeff.vcf.VcfGenotype;

public class GenotypeVector
implements Serializable {
    private static final long serialVersionUID = 4734574592894281057L;
    public static final byte[] mask = new byte[]{3, 3, 12, 12, 48, 48, -64, -64};
    public static final byte[] reverseMask = new byte[]{-4, -4, -13, -13, -49, -49, 63, 63};
    int size;
    byte[] genotype;

    public GenotypeVector(int size2) {
        this.size = size2;
        this.genotype = new byte[this.pos2byte(size2) + 1];
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = 0;
        }
    }

    public int get(int sampleNum) {
        int idx = this.pos2byte(sampleNum);
        int bitIdx = this.pos2bit(sampleNum);
        return this.genotype[idx] >> bitIdx & 3;
    }

    int pos2bit(int pos) {
        return (pos & 3) << 1;
    }

    int pos2bitMask(int pos) {
        return mask[pos & 3];
    }

    int pos2byte(int pos) {
        return pos / 4;
    }

    public void set(int sampleNum, int code) {
        int idx = this.pos2byte(sampleNum);
        int bitIdx = this.pos2bit(sampleNum);
        this.genotype[idx] = (byte)(this.genotype[idx] & reverseMask[bitIdx] | (3 & code) << this.pos2bit(sampleNum));
    }

    public void set(int sampleNum, VcfGenotype vg) {
        int code = vg.getGenotypeCode();
        if (code < 0) {
            code = 0;
        }
        this.set(sampleNum, code);
    }

    public int size() {
        return this.size;
    }
}

