/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.coder.Coder;
import org.snpeff.binseq.coder.DnaCoder;

public class DnaSequence
extends BinarySequence {
    private static final long serialVersionUID = 4523047339848048494L;
    private static DnaSequence EMPTY = null;
    DnaCoder coder = DnaCoder.get();
    int length;
    long[] codes;

    public static DnaSequence empty() {
        if (EMPTY == null) {
            EMPTY = new DnaSequence("");
        }
        return EMPTY;
    }

    public DnaSequence(int length, long[] codes) {
        this.length = length;
        this.codes = codes;
    }

    public DnaSequence(String seqStr) {
        if (seqStr != null) {
            this.set(seqStr);
        }
    }

    public DnaSequence(String seqStr, boolean ignoreErrors) {
        if (seqStr != null) {
            this.set(seqStr, ignoreErrors);
        }
    }

    @Override
    public DnaSequence clone() {
        DnaSequence clone2 = (DnaSequence)super.clone();
        return clone2;
    }

    @Override
    public int compareTo(BinarySequence o) {
        DnaSequence bs = (DnaSequence)o;
        int minlen = Math.min(this.length, bs.length);
        for (int i = 0; i < minlen; ++i) {
            if (this.codes[i] < bs.codes[i]) {
                return -1;
            }
            if (this.codes[i] <= bs.codes[i]) continue;
            return 1;
        }
        return 0;
    }

    protected DnaSequence factory() {
        return new DnaSequence(null);
    }

    DnaSequence factory(int length, long[] codes) {
        return new DnaSequence(length, codes);
    }

    @Override
    public char getBase(int index) {
        int idx = index / this.coder.basesPerWord();
        int pos = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
        int code = (int)((this.codes[idx] & this.coder.MASK_BASE[pos]) >>> (pos << 1));
        return this.coder.toBase(code);
    }

    public String getBases(int index, int len) {
        char[] bases = new char[len];
        int j = index / this.coder.basesPerWord();
        int k = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
        for (int i = 0; i < len; ++i) {
            bases[i] = this.coder.toBase(this.codes[j], k);
            if (--k >= 0) continue;
            k = this.coder.lastBaseinWord();
            ++j;
        }
        return new String(bases);
    }

    @Override
    public int getCode(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException("Index requested " + index + ", sequence length is " + this.length);
        }
        int idx = index / this.coder.basesPerWord();
        int off = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
        return this.coder.decodeWord(this.codes[idx], off);
    }

    @Override
    public Coder getCoder() {
        return this.coder;
    }

    public long[] getCodes() {
        return this.codes;
    }

    @Override
    public String getSequence() {
        return this.getBases(0, this.length);
    }

    @Override
    public int hashCode() {
        long hash2 = 0L;
        for (int i = 0; i < this.codes.length; ++i) {
            hash2 = hash2 * 33L + this.codes[i];
        }
        return (int)hash2;
    }

    public boolean isEmpty() {
        return this.length <= 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BinarySequence overlap(BinarySequence sequence2, int start) {
        int newLenWords;
        DnaSequence seq2 = (DnaSequence)sequence2;
        long[] newCodes = null;
        int newLen = 0;
        int len = this.length();
        if (start >= 0) {
            newLen = start + sequence2.length();
            newLenWords = newLen / this.coder.basesPerWord();
            if (newLen % this.coder.basesPerWord() != 0) {
                ++newLenWords;
            }
            if (len >= newLen) {
                newLen = len;
                newCodes = new long[this.codes.length];
                System.arraycopy(this.codes, 0, newCodes, 0, this.codes.length);
            } else {
                newCodes = new long[newLenWords];
                int lenWords = len / this.coder.basesPerWord();
                if (len % this.coder.basesPerWord() > 0) {
                    ++lenWords;
                }
                System.arraycopy(this.codes, 0, newCodes, 0, lenWords);
                this.coder.copyBases(seq2.codes, len - start, newCodes, len, newLen - len);
            }
        } else {
            newLen = Math.max(-start + len, seq2.length());
            newLenWords = newLen / this.coder.basesPerWord();
            if (newLen % this.coder.basesPerWord() != 0) {
                ++newLenWords;
            }
            newCodes = new long[newLenWords];
            System.arraycopy(seq2.codes, 0, newCodes, 0, seq2.codes.length);
            this.coder.copyBases(this.codes, 0, newCodes, -start, this.length);
        }
        DnaSequence newSeq = this.factory(newLen, newCodes);
        return newSeq;
    }

    @Override
    public BinarySequence read(DataInputStream dataInStream) throws IOException {
        DnaSequence binSeq = this.factory();
        try {
            binSeq.readDataStream(dataInStream);
        }
        catch (EOFException e) {
            return null;
        }
        return binSeq;
    }

    @Override
    protected void readDataStream(DataInputStream dataInStream) throws IOException {
        this.length = dataInStream.readInt();
        int ilen = this.coder.length2words(this.length);
        this.codes = new long[ilen];
        for (int i = 0; i < this.codes.length; ++i) {
            this.codes[i] = dataInStream.readLong();
        }
    }

    @Override
    public BinarySequence reverseWc() {
        DnaSequence rwc = this.factory();
        rwc.codes = new long[this.codes.length];
        rwc.length = this.length;
        int j = 0;
        int k = 0;
        long s = 0L;
        for (int index = this.length - 1; index >= 0; --index) {
            int idx = index / this.coder.basesPerWord();
            int off = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
            int c = this.coder.decodeWord(this.codes[idx], off);
            c = 3 & ~c;
            s <<= 2;
            s |= (long)c;
            if (++k < this.coder.basesPerWord()) continue;
            rwc.codes[j] = s;
            k = 0;
            ++j;
            s = 0L;
        }
        if (k < 64 && k != 0) {
            rwc.codes[j] = s <<= 64 - (k << 1);
        }
        return rwc;
    }

    @Override
    public void set(String seqStr) {
        this.set(seqStr, false);
    }

    public void set(String seqStr, boolean ignoreErrors) {
        if (seqStr == null) {
            this.length = 0;
            this.codes = null;
        } else {
            this.length = seqStr.length();
            int ilen = this.coder.length2words(this.length);
            this.codes = new long[ilen];
            char[] seqChar = seqStr.toCharArray();
            int j = 0;
            int k = 0;
            long s = 0L;
            for (int i = 0; i < seqChar.length; ++i) {
                s <<= 2;
                s |= (long)this.coder.baseToBits(seqChar[i], ignoreErrors);
                if (++k < this.coder.basesPerWord()) continue;
                this.codes[j] = s;
                k = 0;
                ++j;
                s = 0L;
            }
            if (k < 64 && k != 0) {
                this.codes[j] = s <<= 64 - (k << 1);
            }
        }
    }

    @Override
    public void setBase(int index, char base) {
        long newCode;
        int idx = index / this.coder.basesPerWord();
        int pos = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
        this.codes[idx] = newCode = this.coder.replaceBase(this.codes[idx], pos, base);
    }

    public void setCodes(long[] codes) {
        this.codes = codes;
    }

    public String toString() {
        return this.getSequence();
    }

    @Override
    public void write(DataOutputStream dataOutStream) throws IOException {
        dataOutStream.writeInt(this.length);
        for (int i = 0; i < this.codes.length; ++i) {
            dataOutStream.writeLong(this.codes[i]);
        }
    }
}

