/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.domain;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.client.JFatCatClient;
import org.biojava.bio.structure.align.client.StructureName;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.align.util.HTTPConnectionTools;
import org.biojava.bio.structure.domain.AssignmentXMLSerializer;
import org.biojava.bio.structure.domain.PDPProvider;
import org.biojava.bio.structure.domain.SerializableCache;
import org.biojava.bio.structure.scop.server.XMLUtil;

public class RemotePDPProvider
extends SerializableCache<String, SortedSet<String>>
implements PDPProvider {
    public static final String DEFAULT_SERVER = "http://source.rcsb.org/jfatcatserver/domains/";
    String server = "http://source.rcsb.org/jfatcatserver/domains/";
    private static String CACHE_FILE_NAME = "remotepdpdomaindefs.ser";

    public static void main(String[] args) {
        RemotePDPProvider me = new RemotePDPProvider(true);
        SortedSet<String> pdpdomains = me.getPDPDomainNamesForPDB("4HHB");
        System.out.println(pdpdomains);
        AtomCache cache = new AtomCache();
        Structure s = me.getDomain(pdpdomains.first(), cache);
        System.out.println(s);
        me.flushCache();
    }

    public RemotePDPProvider() {
        this(false);
    }

    public RemotePDPProvider(boolean useCache) {
        super(CACHE_FILE_NAME);
        if (!useCache) {
            this.disableCache();
        } else {
            this.loadRepresentativeDomains();
        }
    }

    private void loadRepresentativeDomains() {
        AssignmentXMLSerializer results = null;
        try {
            URL u = new URL(this.server + "getRepresentativePDPDomains");
            System.out.println(u);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = AssignmentXMLSerializer.fromXML(xml);
            Map<String, String> data2 = results.getAssignments();
            System.out.println("got " + data2.size() + " domain ranges for PDP domains from server.");
            for (String key : data2.keySet()) {
                String range2 = data2.get(key);
                String[] spl = range2.split(",");
                TreeSet<String> value2 = new TreeSet<String>();
                for (String s : spl) {
                    value2.add(s);
                }
                this.serializedCache.put(key, value2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public Structure getDomain(String pdpDomainName, AtomCache cache) {
        SortedSet<String> domainRanges = null;
        if (this.serializedCache != null && this.serializedCache.containsKey(pdpDomainName)) {
            domainRanges = (SortedSet<String>)this.serializedCache.get(pdpDomainName);
        }
        Structure s = null;
        try {
            boolean shouldRequestDomainRanges = this.checkDomainRanges(domainRanges);
            if (shouldRequestDomainRanges) {
                URL u = new URL(this.server + "getPDPDomain?pdpId=" + pdpDomainName);
                System.out.println(u);
                InputStream response = HTTPConnectionTools.getInputStream(u);
                String xml = JFatCatClient.convertStreamToString(response);
                domainRanges = XMLUtil.getDomainRangesFromXML(xml);
                if (domainRanges != null) {
                    this.cache(pdpDomainName, domainRanges);
                }
            }
            int i = 0;
            StringBuffer r = new StringBuffer();
            for (String domainRange : domainRanges) {
                if (!domainRange.contains(".")) {
                    r.append(domainRange);
                } else {
                    String[] spl = domainRange.split("\\.");
                    if (spl.length > 1) {
                        r.append(spl[1]);
                    } else {
                        System.out.println("not sure what to do with " + domainRange);
                    }
                }
                if (++i >= domainRanges.size()) continue;
                r.append(",");
            }
            String ranges = r.toString();
            StructureName sname = new StructureName(pdpDomainName);
            Structure tmp = cache.getStructure(sname.getPdbId());
            s = StructureTools.getSubRanges(tmp, ranges);
            s.setName(pdpDomainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    private boolean checkDomainRanges(SortedSet<String> domainRanges) {
        if (domainRanges == null || domainRanges.size() == 0) {
            return true;
        }
        for (String d : domainRanges) {
            if (d == null || d.length() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public SortedSet<String> getPDPDomainNamesForPDB(String pdbId) {
        SortedSet<String> results = null;
        try {
            URL u = new URL(this.server + "getPDPDomainNamesForPDB?pdbId=" + pdbId);
            System.out.println(u);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = XMLUtil.getDomainRangesFromXML(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }
}

