/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.Serializable;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleRadixConstants;
import org.apfloat.spi.DataStorage;

public class DoubleBaseMath
implements Serializable {
    private static final long serialVersionUID = 4560898425815362356L;
    private int radix;
    private double inverseBase;

    public DoubleBaseMath(int radix) {
        this.radix = radix;
        this.inverseBase = 1.0 / DoubleRadixConstants.BASE[radix];
    }

    public double baseAdd(DataStorage.Iterator src1, DataStorage.Iterator src2, double carry, DataStorage.Iterator dst, long size2) throws ApfloatRuntimeException {
        assert (src1 == null || src1 != src2);
        boolean sameDst = src1 == dst || src2 == dst;
        double base = DoubleRadixConstants.BASE[this.radix];
        for (long i = 0L; i < size2; ++i) {
            double result2 = (src1 == null ? 0.0 : src1.getDouble()) + carry + (src2 == null ? 0.0 : src2.getDouble());
            if (result2 >= base) {
                result2 -= base;
                carry = 1.0;
            } else {
                carry = 0.0;
            }
            dst.setDouble(result2);
            if (src1 != null) {
                src1.next();
            }
            if (src2 != null) {
                src2.next();
            }
            if (sameDst) continue;
            dst.next();
        }
        return carry;
    }

    public double baseSubtract(DataStorage.Iterator src1, DataStorage.Iterator src2, double carry, DataStorage.Iterator dst, long size2) throws ApfloatRuntimeException {
        assert (src1 == null || src1 != src2);
        assert (src2 != dst);
        double base = DoubleRadixConstants.BASE[this.radix];
        for (long i = 0L; i < size2; ++i) {
            double result2 = (src1 == null ? 0.0 : src1.getDouble()) - carry - (src2 == null ? 0.0 : src2.getDouble());
            if (result2 < 0.0) {
                result2 += base;
                carry = 1.0;
            } else {
                carry = 0.0;
            }
            dst.setDouble(result2);
            if (src1 != null && src1 != dst) {
                src1.next();
            }
            if (src2 != null) {
                src2.next();
            }
            dst.next();
        }
        return carry;
    }

    public double baseMultiplyAdd(DataStorage.Iterator src1, DataStorage.Iterator src2, double src3, double carry, DataStorage.Iterator dst, long size2) throws ApfloatRuntimeException {
        assert (src1 != src2);
        assert (src1 != dst);
        double base = DoubleRadixConstants.BASE[this.radix];
        for (long i = 0L; i < size2; ++i) {
            double b;
            double a = src1.getDouble();
            long tmp = (long)a * (long)(b = src3) + (long)(carry += src2 == null ? 0.0 : src2.getDouble());
            double result2 = tmp - (long)(carry = (double)((long)((a * b + carry) * this.inverseBase))) * (long)base;
            if (result2 >= base) {
                result2 -= base;
                carry += 1.0;
            }
            if (result2 < 0.0) {
                result2 += base;
                carry -= 1.0;
            }
            dst.setDouble(result2);
            src1.next();
            if (src2 != null && src2 != dst) {
                src2.next();
            }
            dst.next();
        }
        return carry;
    }

    public double baseDivide(DataStorage.Iterator src1, double src2, double carry, DataStorage.Iterator dst, long size2) throws ApfloatRuntimeException {
        assert (src1 != dst);
        double base = DoubleRadixConstants.BASE[this.radix];
        double inverseDivisor = 1.0 / src2;
        for (long i = 0L; i < size2; ++i) {
            double result2;
            double a = src1 == null ? 0.0 : src1.getDouble();
            long tmp = (long)carry * (long)base + (long)a;
            if ((carry = (double)(tmp - (long)(result2 = (double)((long)((carry * base + a) * inverseDivisor))) * (long)src2)) >= src2) {
                carry -= src2;
                result2 += 1.0;
            }
            if (carry < 0.0) {
                carry += src2;
                result2 -= 1.0;
            }
            dst.setDouble(result2);
            if (src1 != null) {
                src1.next();
            }
            dst.next();
        }
        return carry;
    }
}

