/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.custom_hash;

import gnu.trove.TByteCollection;
import gnu.trove.function.TByteFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TCustomObjectHash;
import gnu.trove.impl.hash.THash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.iterator.TObjectByteIterator;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.procedure.TByteProcedure;
import gnu.trove.procedure.TObjectByteProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.strategy.HashingStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectByteCustomHashMap<K>
extends TCustomObjectHash<K>
implements TObjectByteMap<K>,
Externalizable {
    static final long serialVersionUID = 1L;
    private final TObjectByteProcedure<K> PUT_ALL_PROC = new TObjectByteProcedure<K>(){

        @Override
        public boolean execute(K key, byte value2) {
            TObjectByteCustomHashMap.this.put(key, value2);
            return true;
        }
    };
    protected transient byte[] _values;
    protected byte no_entry_value;

    public TObjectByteCustomHashMap() {
    }

    public TObjectByteCustomHashMap(HashingStrategy<? super K> strategy) {
        super(strategy);
    }

    public TObjectByteCustomHashMap(HashingStrategy<? super K> strategy, int initialCapacity) {
        super(strategy, initialCapacity);
        this.no_entry_value = Constants.DEFAULT_BYTE_NO_ENTRY_VALUE;
    }

    public TObjectByteCustomHashMap(HashingStrategy<? super K> strategy, int initialCapacity, float loadFactor) {
        super(strategy, initialCapacity, loadFactor);
        this.no_entry_value = Constants.DEFAULT_BYTE_NO_ENTRY_VALUE;
    }

    public TObjectByteCustomHashMap(HashingStrategy<? super K> strategy, int initialCapacity, float loadFactor, byte noEntryValue) {
        super(strategy, initialCapacity, loadFactor);
        this.no_entry_value = noEntryValue;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._values, this.no_entry_value);
        }
    }

    public TObjectByteCustomHashMap(HashingStrategy<? super K> strategy, TObjectByteMap<? extends K> map2) {
        this(strategy, map2.size(), 0.5f, map2.getNoEntryValue());
        if (map2 instanceof TObjectByteCustomHashMap) {
            TObjectByteCustomHashMap hashmap = (TObjectByteCustomHashMap)map2;
            this._loadFactor = hashmap._loadFactor;
            this.no_entry_value = hashmap.no_entry_value;
            this.strategy = hashmap.strategy;
            if (this.no_entry_value != 0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.putAll(map2);
    }

    @Override
    public int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new byte[capacity];
        return capacity;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        byte[] oldVals = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new byte[newCapacity];
        Arrays.fill(this._values, this.no_entry_value);
        int i = oldCapacity;
        while (i-- > 0) {
            Object o = oldKeys[i];
            if (o == FREE || o == REMOVED) continue;
            int index2 = this.insertKey(o);
            if (index2 < 0) {
                this.throwObjectContractViolation(this._set[-index2 - 1], o);
            }
            this._values[index2] = oldVals[i];
        }
    }

    @Override
    public byte getNoEntryValue() {
        return this.no_entry_value;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    @Override
    public boolean containsValue(byte val) {
        Object[] keys = this._set;
        byte[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte get(Object key) {
        int index2 = this.index(key);
        return index2 < 0 ? this.no_entry_value : this._values[index2];
    }

    @Override
    public byte put(K key, byte value2) {
        int index2 = this.insertKey(key);
        return this.doPut(value2, index2);
    }

    @Override
    public byte putIfAbsent(K key, byte value2) {
        int index2 = this.insertKey(key);
        if (index2 < 0) {
            return this._values[-index2 - 1];
        }
        return this.doPut(value2, index2);
    }

    private byte doPut(byte value2, int index2) {
        byte previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public byte remove(Object key) {
        byte prev = this.no_entry_value;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = this.no_entry_value;
        super.removeAt(index2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Byte> map2) {
        Set<Map.Entry<K, Byte>> set = map2.entrySet();
        for (Map.Entry<K, Byte> entry : set) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TObjectByteMap<? extends K> map2) {
        map2.forEachEntry(this.PUT_ALL_PROC);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
    }

    @Override
    public Set<K> keySet() {
        return new KeyView();
    }

    @Override
    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    @Override
    public K[] keys(K[] a) {
        int size2 = this.size();
        if (a.length < size2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
        }
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            a[j++] = k[i];
        }
        return a;
    }

    @Override
    public TByteCollection valueCollection() {
        return new TByteValueCollection();
    }

    @Override
    public byte[] values() {
        byte[] vals = new byte[this.size()];
        byte[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    @Override
    public byte[] values(byte[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = new byte[size2];
        }
        byte[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            array[j++] = v[i];
        }
        if (array.length > size2) {
            array[size2] = this.no_entry_value;
        }
        return array;
    }

    @Override
    public TObjectByteIterator<K> iterator() {
        return new TObjectByteHashIterator(this);
    }

    @Override
    public boolean increment(K key) {
        return this.adjustValue(key, (byte)1);
    }

    @Override
    public boolean adjustValue(K key, byte amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    @Override
    public byte adjustOrPutValue(K key, byte adjust_amount, byte put_amount) {
        boolean isNewMapping;
        byte newValue;
        int index2 = this.insertKey(key);
        if (index2 < 0) {
            int n = index2 = -index2 - 1;
            byte by2 = (byte)(this._values[n] + adjust_amount);
            this._values[n] = by2;
            newValue = by2;
            isNewMapping = false;
        } else {
            newValue = this._values[index2] = put_amount;
            isNewMapping = true;
        }
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    @Override
    public boolean forEachKey(TObjectProcedure<? super K> procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TByteProcedure procedure) {
        Object[] keys = this._set;
        byte[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(values2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TObjectByteProcedure<? super K> procedure) {
        Object[] keys = this._set;
        byte[] values2 = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TObjectByteProcedure<? super K> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        byte[] values2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public void transformValues(TByteFunction function) {
        Object[] keys = this._set;
        byte[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values2[i] = function.execute(values2[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TObjectByteMap)) {
            return false;
        }
        TObjectByteMap that = (TObjectByteMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        try {
            TObjectByteIterator<K> iter2 = this.iterator();
            while (iter2.hasNext()) {
                iter2.advance();
                K key = iter2.key();
                byte value2 = iter2.value();
                if (!(value2 == this.no_entry_value ? that.get(key) != that.getNoEntryValue() || !that.containsKey(key) : value2 != that.get(key))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashcode = 0;
        Object[] keys = this._set;
        byte[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            hashcode += HashFunctions.hash(values2[i]) ^ (keys[i] == null ? 0 : keys[i].hashCode());
        }
        return hashcode;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeObject(this.strategy);
        out.writeByte(this.no_entry_value);
        out.writeInt(this._size);
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == REMOVED || this._set[i] == FREE) continue;
            out.writeObject(this._set[i]);
            out.writeByte(this._values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.strategy = (HashingStrategy)in.readObject();
        this.no_entry_value = in.readByte();
        int size2 = in.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            Object key = in.readObject();
            byte val = in.readByte();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TObjectByteProcedure<K>(){
            private boolean first = true;

            @Override
            public boolean execute(K key, byte value2) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(",");
                }
                buf.append(key).append("=").append(value2);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TObjectByteHashIterator<K>
    extends TObjectHashIterator<K>
    implements TObjectByteIterator<K> {
        private final TObjectByteCustomHashMap<K> _map;

        public TObjectByteHashIterator(TObjectByteCustomHashMap<K> map2) {
            super(map2);
            this._map = map2;
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public K key() {
            return (K)this._map._set[this._index];
        }

        @Override
        public byte value() {
            return this._map._values[this._index];
        }

        @Override
        public byte setValue(byte val) {
            byte old = this.value();
            this._map._values[this._index] = val;
            return old;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TByteValueCollection
    implements TByteCollection {
        TByteValueCollection() {
        }

        @Override
        public TByteIterator iterator() {
            return new TObjectByteValueHashIterator();
        }

        @Override
        public byte getNoEntryValue() {
            return TObjectByteCustomHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TObjectByteCustomHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TObjectByteCustomHashMap.this._size;
        }

        @Override
        public boolean contains(byte entry) {
            return TObjectByteCustomHashMap.this.containsValue(entry);
        }

        @Override
        public byte[] toArray() {
            return TObjectByteCustomHashMap.this.values();
        }

        @Override
        public byte[] toArray(byte[] dest) {
            return TObjectByteCustomHashMap.this.values(dest);
        }

        @Override
        public boolean add(byte entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(byte entry) {
            byte[] values2 = TObjectByteCustomHashMap.this._values;
            Object[] set = TObjectByteCustomHashMap.this._set;
            int i = values2.length;
            while (i-- > 0) {
                if (set[i] == TObjectHash.FREE || set[i] == TObjectHash.REMOVED || entry != values2[i]) continue;
                TObjectByteCustomHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Byte) {
                    byte ele = (Byte)element;
                    if (TObjectByteCustomHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TByteCollection collection) {
            TByteIterator iter2 = collection.iterator();
            while (iter2.hasNext()) {
                if (TObjectByteCustomHashMap.this.containsValue(iter2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(byte[] array) {
            for (byte element : array) {
                if (TObjectByteCustomHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Byte> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TByteCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(byte[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TByteIterator iter2 = this.iterator();
            while (iter2.hasNext()) {
                if (collection.contains(iter2.next())) continue;
                iter2.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TByteCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TByteIterator iter2 = this.iterator();
            while (iter2.hasNext()) {
                if (collection.contains(iter2.next())) continue;
                iter2.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(byte[] array) {
            boolean changed = false;
            Arrays.sort(array);
            byte[] values2 = TObjectByteCustomHashMap.this._values;
            Object[] set = TObjectByteCustomHashMap.this._set;
            int i = set.length;
            while (i-- > 0) {
                if (set[i] == TObjectHash.FREE || set[i] == TObjectHash.REMOVED || Arrays.binarySearch(array, values2[i]) >= 0) continue;
                TObjectByteCustomHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                byte c;
                if (!(element instanceof Byte) || !this.remove(c = ((Byte)element).byteValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TByteCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TByteIterator iter2 = collection.iterator();
            while (iter2.hasNext()) {
                byte element = iter2.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(byte[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TObjectByteCustomHashMap.this.clear();
        }

        @Override
        public boolean forEach(TByteProcedure procedure) {
            return TObjectByteCustomHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TObjectByteCustomHashMap.this.forEachValue(new TByteProcedure(){
                private boolean first = true;

                public boolean execute(byte value2) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value2);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }

        class TObjectByteValueHashIterator
        implements TByteIterator {
            protected THash _hash;
            protected int _expectedSize;
            protected int _index;

            TObjectByteValueHashIterator() {
                this._hash = TObjectByteCustomHashMap.this;
                this._expectedSize = this._hash.size();
                this._index = this._hash.capacity();
            }

            public boolean hasNext() {
                return this.nextIndex() >= 0;
            }

            public byte next() {
                this.moveToNextIndex();
                return TObjectByteCustomHashMap.this._values[this._index];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                if (this._expectedSize != this._hash.size()) {
                    throw new ConcurrentModificationException();
                }
                try {
                    this._hash.tempDisableAutoCompaction();
                    TObjectByteCustomHashMap.this.removeAt(this._index);
                }
                finally {
                    this._hash.reenableAutoCompaction(false);
                }
                --this._expectedSize;
            }

            protected final void moveToNextIndex() {
                this._index = this.nextIndex();
                if (this._index < 0) {
                    throw new NoSuchElementException();
                }
            }

            protected final int nextIndex() {
                if (this._expectedSize != this._hash.size()) {
                    throw new ConcurrentModificationException();
                }
                Object[] set = TObjectByteCustomHashMap.this._set;
                int i = this._index;
                while (i-- > 0 && (set[i] == TCustomObjectHash.FREE || set[i] == TCustomObjectHash.REMOVED)) {
                }
                return i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MapBackedView<E>
    extends AbstractSet<E>
    implements Set<E>,
    Iterable<E> {
        private MapBackedView() {
        }

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        @Override
        public boolean contains(Object key) {
            return this.containsElement(key);
        }

        @Override
        public boolean remove(Object o) {
            return this.removeElement(o);
        }

        @Override
        public void clear() {
            TObjectByteCustomHashMap.this.clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TObjectByteCustomHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] result2 = new Object[this.size()];
            Iterator e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result2[i] = e.next();
                ++i;
            }
            return result2;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size2 = this.size();
            if (a.length < size2) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
            }
            Iterator it = this.iterator();
            T[] result2 = a;
            for (int i = 0; i < size2; ++i) {
                result2[i] = it.next();
            }
            if (a.length > size2) {
                a[size2] = null;
            }
            return a;
        }

        @Override
        public boolean isEmpty() {
            return TObjectByteCustomHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean changed = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KeyView
    extends MapBackedView<K> {
        protected KeyView() {
        }

        @Override
        public Iterator<K> iterator() {
            return new TObjectHashIterator(TObjectByteCustomHashMap.this);
        }

        @Override
        public boolean removeElement(K key) {
            return TObjectByteCustomHashMap.this.no_entry_value != TObjectByteCustomHashMap.this.remove(key);
        }

        @Override
        public boolean containsElement(K key) {
            return TObjectByteCustomHashMap.this.contains(key);
        }
    }
}

