/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.F;
import com.informagen.sa.digest.CutSite;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestReportPanel;
import com.informagen.sa.digest.EnzymeCuts;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class AllCuttersPanel
extends DigestReportPanel {
    private static final int COL1 = 12;
    private static final int COL2 = 17;
    private static final int GROUPS = 5;
    private static final String COLSPACE = " ";
    private int numWidth = 5;

    public AllCuttersPanel() {
        super("All Cutters");
    }

    public void digestChanged(Digest digest) {
        this.writeHeader(digest);
        this.numWidth = (int)Math.ceil(Math.log(digest.getSeqLength()) / Math.log(10.0));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(F.f("Enzyme", 12, (short)2)).append(F.f("Site", 17, (short)2));
        stringBuffer.append("\n");
        stringBuffer.append(F.f("-", 11, (short)16)).append(COLSPACE);
        stringBuffer.append(F.f("-", 11, (short)16));
        stringBuffer.append("\n");
        Vector vector = digest.getCutters();
        Collections.sort(vector, EnzymeCuts.getComparator());
        int n = digest.getMaxCuts();
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            if (i == 1) {
                stringBuffer.append("Unique cutters:\n");
            } else {
                stringBuffer.append(i).append(" Cuts:\n");
            }
            for (int j = 0; j < vector.size(); ++j) {
                EnzymeCuts enzymeCuts = (EnzymeCuts)vector.elementAt(j);
                if (enzymeCuts.getCutCount() != i) continue;
                n2 += i;
                this.writeLine(digest, stringBuffer, enzymeCuts);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("  ").append(n2).append(" sites found with ").append(vector.size()).append(" enzymes.\n");
        this.textArea.append(stringBuffer.toString());
    }

    void writeLine(Digest digest, StringBuffer stringBuffer, EnzymeCuts enzymeCuts) {
        String string = enzymeCuts.getEnzymeName();
        string = string.startsWith("*") ? string : COLSPACE + string;
        stringBuffer.append(F.f(string, 12, (short)2));
        stringBuffer.append(F.f(enzymeCuts.getEnzymeSite(), 17, (short)2));
        Iterator iterator = enzymeCuts.getCutSites().iterator();
        int n = 1;
        int n2 = 0;
        while (iterator.hasNext()) {
            CutSite cutSite = (CutSite)iterator.next();
            int n3 = cutSite.getCutPosition();
            stringBuffer.append(F.f(n, this.numWidth));
            stringBuffer.append(" (");
            stringBuffer.append(F.f(n3 - n, this.numWidth));
            stringBuffer.append(") ");
            n = n3;
            if (++n2 <= 5) continue;
            stringBuffer.append("\n").append(F.f((Object)"", 29));
            n2 = 0;
        }
        stringBuffer.append(F.f(n, this.numWidth));
        stringBuffer.append(" (");
        stringBuffer.append(F.f(digest.getSeqLength() - n + 1, this.numWidth));
        stringBuffer.append(") ");
        stringBuffer.append(F.f(digest.getSeqLength(), this.numWidth));
        stringBuffer.append("\n");
    }
}

