/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.Element;
import com.informagen.giv.ElementRecord;
import com.informagen.giv.ElementStyle;
import com.informagen.giv.ElementType;
import com.informagen.giv.ElementTypeRecord;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapPanel;
import com.informagen.giv.MapPanelRecord;
import com.informagen.giv.MapView;
import com.informagen.giv.PanelMemberRecord;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MapData {
    private Hashtable mMapViewTable = new Hashtable();
    private Hashtable mMapPanelTable = new Hashtable();
    private Hashtable mPanelMemberTable = new Hashtable();
    private Hashtable mElementTypeTable = new Hashtable();
    private Hashtable mElementTable = new Hashtable();
    private Vector mMapViewList = new Vector();
    private Vector mMapPanelList = new Vector();

    public void addMapView(String string, String string2, MapView mapView) {
        this.mMapViewTable.put(string, new MapView());
        this.mMapViewList.addElement(string);
    }

    public void addMapPanel(String string, String string2, MapPanel mapPanel) {
        MapPanelRecord mapPanelRecord = new MapPanelRecord(string2, mapPanel);
        this.mMapPanelTable.put(string, mapPanelRecord);
        this.mMapPanelList.addElement(string);
    }

    public void addPanelMember(String string, String string2, String string3, ElementStyle elementStyle) {
        PanelMemberRecord panelMemberRecord = new PanelMemberRecord(string2, string3, elementStyle);
        this.mPanelMemberTable.put(string, panelMemberRecord);
    }

    public void addElementType(String string, ElementType elementType) {
        ElementTypeRecord elementTypeRecord = new ElementTypeRecord(elementType);
        this.mElementTypeTable.put(string, elementTypeRecord);
    }

    public void addElement(String string, String string2, Element element) {
        ElementRecord elementRecord = new ElementRecord(string2, element);
        this.mElementTable.put(string, elementRecord);
    }

    public Enumeration mapViews() {
        return this.mMapViewList.elements();
    }

    public Enumeration mapPanels() {
        return this.mMapPanelList.elements();
    }

    public Enumeration panelMembers() {
        return this.mPanelMemberTable.keys();
    }

    public Enumeration elementTypes() {
        return this.mElementTypeTable.keys();
    }

    public Enumeration elements() {
        return this.mElementTable.keys();
    }

    public MapView getMapView(String string) {
        return (MapView)this.mMapViewTable.get(string);
    }

    public MapPanelRecord getMapPanel(String string) {
        return (MapPanelRecord)this.mMapPanelTable.get(string);
    }

    public PanelMemberRecord getPanelMember(String string) {
        return (PanelMemberRecord)this.mPanelMemberTable.get(string);
    }

    public ElementTypeRecord getElementType(String string) {
        return (ElementTypeRecord)this.mElementTypeTable.get(string);
    }

    public ElementRecord getElement(String string) {
        return (ElementRecord)this.mElementTable.get(string);
    }

    public MapView makeMapView() {
        Enumeration enumeration = this.mapViews();
        String string = (String)enumeration.nextElement();
        MapView mapView = this.getMapView(string);
        Enumeration enumeration2 = this.mapPanels();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            MapPanelRecord mapPanelRecord = this.getMapPanel(string2);
            if (!mapPanelRecord.mMapViewID.equalsIgnoreCase(string)) continue;
            MapPanel mapPanel = mapPanelRecord.mMapPanel;
            mapView.add(mapPanel);
            Enumeration enumeration3 = this.panelMembers();
            while (enumeration3.hasMoreElements()) {
                String string3 = (String)enumeration3.nextElement();
                PanelMemberRecord panelMemberRecord = this.getPanelMember(string3);
                if (!panelMemberRecord.mMapPanelID.equalsIgnoreCase(string2)) continue;
                String string4 = panelMemberRecord.mElementTypeID;
                Enumeration enumeration4 = this.elements();
                while (enumeration4.hasMoreElements()) {
                    String string5 = (String)enumeration4.nextElement();
                    ElementRecord elementRecord = this.getElement(string5);
                    if (!elementRecord.mElementTypeID.equalsIgnoreCase(string4)) continue;
                    Element element = elementRecord.mElement;
                    float f = element.mStart;
                    float f2 = element.mStop;
                    float f3 = element.mStop - element.mStart;
                    MapGlyph mapGlyph = new MapGlyph(element.mName, f, f2, panelMemberRecord.mPanelMember);
                    mapPanel.add(mapGlyph);
                }
            }
        }
        return mapView;
    }
}

