/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaToolBarUI;
import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicToolBarUI;

public class QuaquaToolBarBorder
extends AbstractBorder
implements SwingConstants {
    private static final Color bright = new Color(0x999999, true);
    private static final Color dark = new Color(0x8C8C8C);
    private static final Color divider = new Color(0x9F9F9F);

    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        if (component instanceof JToolBar && ((JToolBar)component).getUI() instanceof QuaquaToolBarUI) {
            JToolBar c = (JToolBar)component;
            boolean isDividerDrawn = this.isDividerDrawn(c);
            int dividerLocation = this.getDividerLocation(c);
            if (c.isFloatable()) {
                int hx = x;
                int hy = y;
                int hw = w;
                int hh = h;
                if (isDividerDrawn) {
                    hx = dividerLocation == 7 ? x + 1 : x;
                    hy = dividerLocation == 1 ? y + 1 : y;
                    hw = dividerLocation == 3 || dividerLocation == 7 ? w - 1 : w;
                    int n = hh = dividerLocation == 5 || dividerLocation == 1 ? h - 1 : h;
                }
                if (c.getOrientation() == 0) {
                    if (QuaquaUtilities.isLeftToRight(c)) {
                        g.setColor(bright);
                        g.fillRect(hx + 2, hy + 2, 1, hh - 4);
                        g.fillRect(hx + 5, hy + 2, 1, hh - 4);
                        g.setColor(dark);
                        g.fillRect(hx + 3, hy + 2, 1, hh - 4);
                        g.fillRect(hx + 6, hy + 2, 1, hh - 4);
                    } else {
                        g.setColor(bright);
                        g.fillRect(hw - hx - 3, hy + 2, 1, hh - 4);
                        g.fillRect(hw - hx - 5, hy + 2, 1, hh - 4);
                        g.setColor(dark);
                        g.fillRect(hw - hx - 2, hy + 2, 1, hh - 4);
                        g.fillRect(hw - hx - 6, hy + 2, 1, hh - 4);
                    }
                } else {
                    g.setColor(bright);
                    g.fillRect(hx + 2, hy + 2, hw - 4, 1);
                    g.fillRect(hx + 2, hy + 5, hw - 4, 1);
                    g.setColor(dark);
                    g.fillRect(hx + 2, hy + 3, hw - 4, 1);
                    g.fillRect(hx + 2, hy + 6, hw - 4, 1);
                }
            }
            if (isDividerDrawn) {
                g.setColor(divider);
                switch (dividerLocation) {
                    case 1: {
                        g.fillRect(x, y, w, 1);
                        break;
                    }
                    case 3: {
                        g.fillRect(x + w - 1, y, 1, h);
                        break;
                    }
                    case 5: {
                        g.fillRect(x, y + h - 1, w, 1);
                        break;
                    }
                    case 7: {
                        g.fillRect(x, y, 1, h);
                        break;
                    }
                }
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    private boolean isDividerDrawn(JToolBar c) {
        Object value = c.getClientProperty(QuaquaToolBarUI.IS_DIVIDER_DRAWN);
        return value == null || value.equals(Boolean.TRUE);
    }

    private int getDividerLocation(JToolBar c) {
        if (!((BasicToolBarUI)c.getUI()).isFloating() && c.getParent() != null) {
            boolean fillsHeight;
            Dimension parentSize = c.getParent().getSize();
            Insets parentInsets = c.getParent().getInsets();
            Rectangle bounds = c.getBounds();
            boolean fillsWidth = bounds.width >= parentSize.width - parentInsets.left - parentInsets.right;
            boolean bl = fillsHeight = bounds.height >= parentSize.height - parentInsets.top - parentInsets.bottom;
            if (fillsWidth && fillsHeight) {
                return -1;
            }
            if (fillsWidth) {
                if (bounds.y == parentInsets.top) {
                    return 5;
                }
                return 1;
            }
            if (fillsHeight) {
                if (bounds.x == parentInsets.left) {
                    return 3;
                }
                return 7;
            }
        }
        return -1;
    }

    public Insets getBorderInsets(Component component, Insets newInsets) {
        if (component instanceof JToolBar && ((JToolBar)component).getUI() instanceof QuaquaToolBarUI) {
            Insets margin;
            JToolBar c = (JToolBar)component;
            newInsets.right = 0;
            newInsets.bottom = 0;
            newInsets.left = 0;
            newInsets.top = 0;
            boolean isFloatable = c.isFloatable();
            if (isFloatable) {
                if (c.getOrientation() == 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        newInsets.left = 16;
                    } else {
                        newInsets.right = 16;
                    }
                } else {
                    newInsets.top = 16;
                }
            } else if (c.getOrientation() == 0) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    newInsets.left = 4;
                } else {
                    newInsets.right = 4;
                }
            }
            if (this.isDividerDrawn(c)) {
                if (isFloatable && ((QuaquaToolBarUI)c.getUI()).isFloating()) {
                    ++newInsets.top;
                    ++newInsets.right;
                } else {
                    switch (this.getDividerLocation(c)) {
                        case 5: {
                            ++newInsets.bottom;
                            break;
                        }
                        case 3: {
                            ++newInsets.right;
                            break;
                        }
                        case 1: {
                            ++newInsets.top;
                            break;
                        }
                        case 7: {
                            ++newInsets.left;
                            break;
                        }
                    }
                }
            }
            if ((margin = c.getMargin()) != null) {
                newInsets.left += margin.left;
                newInsets.top += margin.top;
                newInsets.right += margin.right;
                newInsets.bottom += margin.bottom;
            }
            return newInsets;
        }
        return new Insets(0, 0, 0, 0);
    }

    public static class UIResource
    extends QuaquaToolBarBorder
    implements javax.swing.plaf.UIResource {
    }
}

