/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Gui;
import edsim51di.Mapping;
import edsim51sh.DITargetBoard;
import edsim51sh.dynamicinterface.DynamicInterface;
import edsim51sh.dynamicinterface.Menu;

class Board
extends DITargetBoard {
    private Gui gui = new Gui(true, this);

    Board(String hardwareSettingsFilename) {
        super(hardwareSettingsFilename);
        int i;
        this.init(this.gui, "Dynamic Interface", "x");
        Mapping[] mappings = this.gui.getKeypad().getPortMappings();
        for (int i2 = 0; i2 < mappings.length; ++i2) {
            this.setPortPinDescription(mappings[i2].portNumber, mappings[i2].pinNumber, mappings[i2].description);
        }
        Mapping gateMapping = this.gui.getKeypad().getGateMapping();
        this.setPortPinDescription(gateMapping.portNumber, gateMapping.pinNumber, gateMapping.description);
        mappings = this.gui.getLEDBank().dataLineMappings;
        for (i = 0; i < mappings.length; ++i) {
            this.setPortPinDescription(mappings[i].portNumber, mappings[i].pinNumber, mappings[i].description);
        }
        mappings = this.gui.getSwitchBank().dataLineMappings;
        for (i = 0; i < mappings.length; ++i) {
            this.setPortPinDescription(mappings[i].portNumber, mappings[i].pinNumber, mappings[i].description);
        }
        mappings = this.gui.getMultiplexedDisplay().dataLineMappings;
        for (i = 0; i < mappings.length; ++i) {
            this.setPortPinDescription(mappings[i].portNumber, mappings[i].pinNumber, mappings[i].description);
        }
        Mapping mapping = this.gui.getMultiplexedDisplay().getCSMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getMultiplexedDisplay().getINPUT0Mapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getMultiplexedDisplay().getINPUT1Mapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mappings = this.gui.getDAC().dataLineMappings;
        for (int i3 = 0; i3 < mappings.length; ++i3) {
            this.setPortPinDescription(mappings[i3].portNumber, mappings[i3].pinNumber, mappings[i3].description);
        }
        mapping = this.gui.getDAC().getWRMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        int[][] DBMapping = this.gui.getLcdModule().getDBMapping();
        this.setPortPinDescription(DBMapping[0][0], DBMapping[0][1], "LCD DB7");
        this.setPortPinDescription(DBMapping[1][0], DBMapping[1][1], "LCD DB6");
        this.setPortPinDescription(DBMapping[2][0], DBMapping[2][1], "LCD DB5");
        this.setPortPinDescription(DBMapping[3][0], DBMapping[3][1], "LCD DB4");
        this.setPortPinDescription(DBMapping[4][0], DBMapping[4][1], "LCD DB3");
        this.setPortPinDescription(DBMapping[5][0], DBMapping[5][1], "LCD DB2");
        this.setPortPinDescription(DBMapping[6][0], DBMapping[6][1], "LCD DB1");
        this.setPortPinDescription(DBMapping[7][0], DBMapping[7][1], "LCD DB0");
        int[] EMapping = this.gui.getLcdModule().getEMapping();
        int[] RSMapping = this.gui.getLcdModule().getRSMapping();
        this.setPortPinDescription(EMapping[0], EMapping[1], "LCD E");
        this.setPortPinDescription(RSMapping[0], RSMapping[1], "LCD RS");
        mappings = this.gui.getADC().dataLineMappings;
        for (int i4 = 0; i4 < mappings.length; ++i4) {
            this.setPortPinDescription(mappings[i4].portNumber, mappings[i4].pinNumber, mappings[i4].description);
        }
        mapping = this.gui.getADC().getRDMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getADC().getWRMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getADC().getINTRMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getComparator().getOutputMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getMotor().getBit0Mapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getMotor().getBit1Mapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getMotor().getSensorMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getUart().getTxMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
        mapping = this.gui.getUart().getRxMapping();
        this.setPortPinDescription(mapping.portNumber, mapping.pinNumber, mapping.description);
    }

    @Override
    public void remapHardware(DynamicInterface dynamicInterface) {
        int i;
        String description;
        Menu menu;
        String[] descriptions = this.gui.getKeypad().getRowDescriptions();
        String rowMapping = "";
        for (int i2 = 0; i2 < descriptions.length; ++i2) {
            menu = dynamicInterface.getMenu(descriptions[i2]);
            if (menu == null) continue;
            rowMapping = rowMapping + menu.getPort() + "." + menu.getPin();
            if (i2 == descriptions.length - 1) continue;
            rowMapping = rowMapping + ",";
        }
        if (!rowMapping.equals("")) {
            this.setHardwareSetting("keypad_rows", rowMapping);
        }
        descriptions = this.gui.getKeypad().getColumnDescriptions();
        String columnMapping = "";
        for (int i3 = 0; i3 < descriptions.length; ++i3) {
            menu = dynamicInterface.getMenu(descriptions[i3]);
            if (menu == null) continue;
            columnMapping = columnMapping + menu.getPort() + "." + menu.getPin();
            if (i3 == descriptions.length - 1) continue;
            columnMapping = columnMapping + ",";
        }
        if (!columnMapping.equals("")) {
            this.setHardwareSetting("keypad_columns", columnMapping);
        }
        if ((menu = dynamicInterface.getMenu(description = this.gui.getKeypad().getANDGateDescription())) != null) {
            this.setHardwareSetting("ANDGateOutput", menu.getPort() + "." + menu.getPin());
        }
        String DBMapping = "";
        for (int i4 = 7; i4 >= 0; --i4) {
            menu = dynamicInterface.getMenu("LCD DB" + i4);
            if (menu == null) continue;
            DBMapping = DBMapping + menu.getPort() + "." + menu.getPin();
            if (i4 == 0) continue;
            DBMapping = DBMapping + ",";
        }
        if (!DBMapping.equals("")) {
            this.setHardwareSetting("lcdModule_dbs", DBMapping);
        }
        if ((menu = dynamicInterface.getMenu("LCD RS")) != null) {
            this.setHardwareSetting("lcdModule_rs", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("LCD E")) != null) {
            this.setHardwareSetting("lcdModule_e", menu.getPort() + "." + menu.getPin());
        }
        DBMapping = "";
        char c = 'a';
        for (i = 0; i < 8; ++i) {
            menu = c == 'h' ? dynamicInterface.getMenu("Seg. dp") : dynamicInterface.getMenu("Seg. " + c);
            c = (char)(c + 1);
            if (menu == null) continue;
            DBMapping = DBMapping + menu.getPort() + "." + menu.getPin();
            if (i == 7) continue;
            DBMapping = DBMapping + ",";
        }
        if (!DBMapping.equals("")) {
            this.setHardwareSetting("multidisplay_dbs", DBMapping);
        }
        if ((menu = dynamicInterface.getMenu("Display-select Decoder CS")) != null) {
            this.setHardwareSetting("multidisplay_cs", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Display-select Input 0")) != null) {
            this.setHardwareSetting("multidisplay_input0", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Display-select Input 1")) != null) {
            this.setHardwareSetting("multidisplay_input1", menu.getPort() + "." + menu.getPin());
        }
        DBMapping = "";
        for (i = 0; i < 8; ++i) {
            menu = dynamicInterface.getMenu("ADC DB" + i);
            if (menu == null) continue;
            DBMapping = DBMapping + menu.getPort() + "." + menu.getPin();
            if (i == 7) continue;
            DBMapping = DBMapping + ",";
        }
        if (!DBMapping.equals("")) {
            this.setHardwareSetting("adc_dbs", DBMapping);
        }
        if ((menu = dynamicInterface.getMenu("ADC RD")) != null) {
            this.setHardwareSetting("adc_rd", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("ADC WR")) != null) {
            this.setHardwareSetting("adc_wr", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("ADC INTR")) != null) {
            this.setHardwareSetting("adc_intr", menu.getPort() + "." + menu.getPin());
        }
        DBMapping = "";
        for (i = 0; i < 8; ++i) {
            menu = dynamicInterface.getMenu("DAC DB" + i);
            if (menu == null) continue;
            DBMapping = DBMapping + menu.getPort() + "." + menu.getPin();
            if (i == 7) continue;
            DBMapping = DBMapping + ",";
        }
        if (!DBMapping.equals("")) {
            this.setHardwareSetting("dac_dbs", DBMapping);
        }
        if ((menu = dynamicInterface.getMenu("DAC WR")) != null) {
            this.setHardwareSetting("dac_wr", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Comparator Output")) != null) {
            this.setHardwareSetting("comparator_op", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Motor Control Bit 0")) != null) {
            this.setHardwareSetting("motor_bit0", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Motor Control Bit 1")) != null) {
            this.setHardwareSetting("motor_bit1", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Motor Sensor")) != null) {
            this.setHardwareSetting("motor_sensor", menu.getPort() + "." + menu.getPin());
        }
        DBMapping = "";
        for (i = 0; i < 8; ++i) {
            menu = dynamicInterface.getMenu("LED " + i);
            if (menu == null) continue;
            DBMapping = DBMapping + menu.getPort() + "." + menu.getPin();
            if (i == 7) continue;
            DBMapping = DBMapping + ",";
        }
        if (!DBMapping.equals("")) {
            this.setHardwareSetting("leds_dbs", DBMapping);
        }
        DBMapping = "";
        for (i = 0; i < 8; ++i) {
            menu = dynamicInterface.getMenu("SW " + i);
            if (menu == null) continue;
            DBMapping = DBMapping + menu.getPort() + "." + menu.getPin();
            if (i == 7) continue;
            DBMapping = DBMapping + ",";
        }
        if (!DBMapping.equals("")) {
            this.setHardwareSetting("switches_dbs", DBMapping);
        }
        if ((menu = dynamicInterface.getMenu("Ext. UART Tx")) != null) {
            this.setHardwareSetting("uart_tx", menu.getPort() + "." + menu.getPin());
        }
        if ((menu = dynamicInterface.getMenu("Ext. UART Rx")) != null) {
            this.setHardwareSetting("uart_rx", menu.getPort() + "." + menu.getPin());
        }
    }

    @Override
    public void reset() {
        this.gui.reset();
    }

    @Override
    public void setTargetBoardGraphicsSize(boolean small) {
        this.gui.setSize(small);
    }

    @Override
    public void updateTargetBoardGraphics() {
        this.gui.refresh();
    }

    @Override
    public void updatePortPins() {
        this.gui.updatePortPins(this.getInstructionElapsedTime());
    }
}

