/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.ImageIcon;
import javax.swing.JPanel;

final class NumberDisplay {
    private final DisplayCore.DisplayGlyph[] minusSign;
    private final DisplayCore.DisplayGlyph[][] intDigits;
    private final DisplayCore.DisplayGlyph[][] fracDigits;
    private final DisplayCore.DisplayGlyph[] intTicks;
    private final DisplayCore.DisplayGlyph[] fracTicks;
    private final DisplayCore.DisplayGlyph[] dot;
    private final DisplayCore.DisplayGlyph e;
    private final DisplayCore.DisplayGlyph expPlusSign;
    private final DisplayCore.DisplayGlyph expMinusSign;
    private final DisplayCore.DisplayGlyph error;
    private final DisplayCore.DisplayGlyph[][] expDigits;
    private final DisplayCore displayCore;
    private final int inputLength;
    private final int expInputLength;
    private final boolean hasTicks;
    private final boolean hasError;
    private static final int tickFrequency = 3;

    NumberDisplay(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, boolean bl, boolean bl2, String string, int n16, JPanel jPanel) {
        int n17;
        ImageIcon imageIcon;
        this.displayCore = new DisplayCore(n, n2, n3, n4, jPanel, true);
        this.inputLength = n14;
        this.expInputLength = n15;
        this.hasTicks = bl;
        this.hasError = bl2;
        this.minusSign = new DisplayCore.DisplayGlyph[n14];
        this.intDigits = new DisplayCore.DisplayGlyph[n14][n16];
        this.fracDigits = new DisplayCore.DisplayGlyph[n14][n16];
        this.intTicks = new DisplayCore.DisplayGlyph[n14];
        this.fracTicks = new DisplayCore.DisplayGlyph[n14];
        this.dot = new DisplayCore.DisplayGlyph[n14];
        this.expDigits = new DisplayCore.DisplayGlyph[n15][n16];
        int n18 = n5 * (n14 + 1) + n8;
        for (int i = 0; i < n16; ++i) {
            imageIcon = DisplayCore.initGlyphIcon(string + "/DIGIT_" + i + ".png");
            for (n17 = 0; n17 < n14; ++n17) {
                this.intDigits[n17][i] = new DisplayCore.DisplayGlyph(n9 + n5 * (n17 + 1), n10, imageIcon, this.displayCore.getPane());
                this.fracDigits[n17][i] = new DisplayCore.DisplayGlyph(n9 + n8 + n5 * (n17 + 1), n10, imageIcon, this.displayCore.getPane());
            }
            for (n17 = 0; n17 < n15; ++n17) {
                this.expDigits[n17][i] = new DisplayCore.DisplayGlyph(n9 + n18 + n5 * (n17 + 2), n10, imageIcon, this.displayCore.getPane());
            }
        }
        ImageIcon imageIcon2 = DisplayCore.initGlyphIcon(string + "/DOT.png");
        imageIcon = DisplayCore.initGlyphIcon(string + "/MINUS.png");
        for (n17 = 0; n17 < n14; ++n17) {
            this.dot[n17] = new DisplayCore.DisplayGlyph(n9 + n5 * (n17 + 2) + n6, n10 + n7, imageIcon2, this.displayCore.getPane());
            this.minusSign[n17] = new DisplayCore.DisplayGlyph(n9 + n5 * n17, n10, imageIcon, this.displayCore.getPane());
        }
        if (bl) {
            ImageIcon imageIcon3 = DisplayCore.initGlyphIcon(string + "/TICK.png");
            for (int i = 0; i < n14; ++i) {
                this.intTicks[i] = new DisplayCore.DisplayGlyph(n9 + n5 * i + n12, n10 + n13, imageIcon3, this.displayCore.getPane());
                this.fracTicks[i] = new DisplayCore.DisplayGlyph(n9 + n5 * i + n8 + n12, n10 + n13, imageIcon3, this.displayCore.getPane());
            }
        }
        this.expMinusSign = new DisplayCore.DisplayGlyph(n9 + n18 + n5, n10, imageIcon, this.displayCore.getPane());
        this.expPlusSign = new DisplayCore.DisplayGlyph(n9 + n18 + n5, n10, DisplayCore.initGlyphIcon(string + "/PLUS.png"), this.displayCore.getPane());
        this.e = new DisplayCore.DisplayGlyph(n9 + n18, n10, DisplayCore.initGlyphIcon(string + "/E.png"), this.displayCore.getPane());
        this.error = bl2 ? new DisplayCore.DisplayGlyph(n9 + n11, n10, DisplayCore.initGlyphIcon(string + "/ERROR.png"), this.displayCore.getPane()) : null;
    }

    void show(DoubleByDigitGetters doubleByDigitGetters) {
        int n;
        this.displayCore.clear();
        if (doubleByDigitGetters.isOverflow()) {
            if (this.hasError) {
                this.displayCore.addGlyphToShow(this.error);
            }
            this.displayCore.refresh();
            return;
        }
        int n2 = doubleByDigitGetters.getNIntDigits() + doubleByDigitGetters.getNFracDigits();
        int n3 = this.inputLength - n2;
        if (n2 > this.inputLength) {
            throw new RuntimeException("More digits in the mantissa, " + n2 + ", than can be shown," + this.inputLength);
        }
        if (doubleByDigitGetters.getSign() < 0) {
            this.displayCore.addGlyphToShow(this.minusSign[n3]);
        }
        for (n = 0; n < doubleByDigitGetters.getNIntDigits(); ++n) {
            this.displayCore.addGlyphToShow(this.intDigits[n3 + n][doubleByDigitGetters.getIntDigit(n)]);
        }
        this.displayCore.addGlyphToShow(this.dot[n3 + doubleByDigitGetters.getNIntDigits() - 1]);
        for (n = 0; n < doubleByDigitGetters.getNFracDigits(); ++n) {
            this.displayCore.addGlyphToShow(this.fracDigits[n3 + doubleByDigitGetters.getNIntDigits() + n][doubleByDigitGetters.getFracDigit(n)]);
        }
        if (doubleByDigitGetters.getNExpDigits() > 0) {
            if (doubleByDigitGetters.getNExpDigits() > this.expInputLength) {
                throw new RuntimeException("More digits in the exponent, " + doubleByDigitGetters.getNExpDigits() + ", than can be shown," + this.expInputLength);
            }
            this.displayCore.addGlyphToShow(this.e);
            if (doubleByDigitGetters.getExpSign() > 0) {
                this.displayCore.addGlyphToShow(this.expPlusSign);
            } else {
                this.displayCore.addGlyphToShow(this.expMinusSign);
            }
            for (n = 0; n < doubleByDigitGetters.getNExpDigits(); ++n) {
                this.displayCore.addGlyphToShow(this.expDigits[n][doubleByDigitGetters.getExpDigit(n)]);
            }
        }
        if (this.hasTicks) {
            for (n = doubleByDigitGetters.getNIntDigits() - 3; n > 0; n -= 3) {
                this.displayCore.addGlyphToShow(this.intTicks[n3 + n]);
            }
            for (n = 3; n < doubleByDigitGetters.getNFracDigits(); n += 3) {
                this.displayCore.addGlyphToShow(this.fracTicks[n3 + doubleByDigitGetters.getNIntDigits() + n]);
            }
        }
        this.displayCore.refresh();
    }
}

