/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.ObjectCache;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.web.BadRequestException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AudioScrobbler {
    private final int ONE_HOUR_IN_SECONDS = 3600;
    private final int CACHE_TIMEOUT_IN_SECONDS = 3600;
    private final Logger log = Logger.getLogger(AudioScrobbler.class);
    private Database db;
    private ObjectCache cache;

    public AudioScrobbler(Database db, ObjectCache cache) {
        this.db = db;
        this.cache = cache;
    }

    public String[] getSimilarArtists(int artistId) throws IOException, SQLException, BadRequestException {
        String cacheKey = "web.action.AudioScrobbler.similar." + artistId;
        if (!this.cache.isCached(cacheKey)) {
            this.cache.write(cacheKey, this.getSimilarArtists(this.getArtistName(artistId)), 3600);
        }
        return (String[])this.cache.read(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getSimilarArtists(String artistName) throws IOException {
        String[] stringArray;
        BufferedReader in = null;
        try {
            this.log.debug((Object)("Fetching similar artists for: " + artistName));
            String url = "http://ws.audioscrobbler.com/1.0/artist/" + Utils.URLEncode(artistName) + "/similar.txt";
            HttpURLConnection cnn = this.getHttpURLConnection(url);
            ArrayList<String> artists = new ArrayList<String>();
            String s = "";
            in = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
            while ((s = in.readLine()) != null) {
                String[] info = s.split(",");
                artists.add(info[2]);
            }
            stringArray = artists.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        Utils.close(in);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getArtistName(int artistId) throws SQLException, BadRequestException {
        String string;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            String sql = " select name  from artists  where id = ? ";
            st = this.db.prepare(" select name  from artists  where id = ? ");
            st.setInt(1, artistId);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException("unknown artist", 404);
            }
            string = rs.getString("name");
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return string;
    }

    protected HttpURLConnection getHttpURLConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }
}

