/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.TMain;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TMainImpl
extends AbstractTemplateImpl
implements TMain.Intf {
    private final Vector<Album> recentAlbums;
    private final Vector<User> recentUsers;
    private final String title;
    private final Vector<Artist> topArtists;
    private final User user;
    private final Vector<Track> recentTracks;
    private final Locale locale;
    private final Properties properties;

    protected static TMain.ImplData __jamon_setOptionalArguments(TMain.ImplData p_implData) {
        if (!p_implData.getRecentAlbums__IsNotDefault()) {
            p_implData.setRecentAlbums(null);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getTitle__IsNotDefault()) {
            p_implData.setTitle("Sockso");
        }
        if (!p_implData.getTopArtists__IsNotDefault()) {
            p_implData.setTopArtists(null);
        }
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getRecentTracks__IsNotDefault()) {
            p_implData.setRecentTracks(null);
        }
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        return p_implData;
    }

    public TMainImpl(TemplateManager p_templateManager, TMain.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TMainImpl.__jamon_setOptionalArguments(p_implData));
        this.recentAlbums = p_implData.getRecentAlbums();
        this.recentUsers = p_implData.getRecentUsers();
        this.title = p_implData.getTitle();
        this.topArtists = p_implData.getTopArtists();
        this.user = p_implData.getUser();
        this.recentTracks = p_implData.getRecentTracks();
        this.locale = p_implData.getLocale();
        this.properties = p_implData.getProperties();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_6 = new IHeader(this.getTemplateManager());
        __jamon__var_6.setProperties(this.properties);
        __jamon__var_6.setTitle("Home");
        __jamon__var_6.setLocale(this.locale);
        __jamon__var_6.setUser(this.user);
        __jamon__var_6.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n");
        if (!this.properties.get("www.covers.disable").equals("yes")) {
            jamonWriter.write("\n    ");
            if (this.recentAlbums.size() > 0) {
                jamonWriter.write("\n        <div class=\"albumArt\">\n            <h2>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.recentlyPlayedAlbums")), jamonWriter);
                jamonWriter.write("</h2>\n            <ul>\n            ");
                for (Album album : this.recentAlbums) {
                    jamonWriter.write("\n                <li>\n                    <a href=\"");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/album/" + album.getId())), jamonWriter);
                    jamonWriter.write("\" title=\"");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)(Utils.u2e(album.getArtist().getName()) + " - " + Utils.u2e(album.getName()))), jamonWriter);
                    jamonWriter.write("\"><img class=\"cover\" src=\"");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/file/cover/al" + album.getId())), jamonWriter);
                    jamonWriter.write("\" /></a>\n                    <div class=\"links\">\n                        ");
                    IMusicLinks __jamon__var_7 = new IMusicLinks(this.getTemplateManager());
                    __jamon__var_7.setName(album.getName());
                    __jamon__var_7.setId(album.getId());
                    __jamon__var_7.setPlayRandomLink(true);
                    __jamon__var_7.setProperties(this.properties);
                    __jamon__var_7.setLocale(this.locale);
                    __jamon__var_7.setType("al");
                    __jamon__var_7.renderNoFlush(jamonWriter);
                    jamonWriter.write("\n                    </div>\n                </li>\n            ");
                }
                jamonWriter.write("\n            </ul>\n        </div>\n    ");
            }
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n\n<div class=\"clearer\"></div>\n\n<div class=\"section\">\n    <h3>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.recentlyPlayedTracks")), jamonWriter);
        jamonWriter.write("</h3>\n    <ul class=\"musiclist\">\n    ");
        if (this.recentTracks.size() > 0) {
            jamonWriter.write("\n        ");
            for (Track track : this.recentTracks) {
                jamonWriter.write("\n            <li class=\"track\">\n                ");
                IMusicLinks __jamon__var_8 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_8.setName(track.getName());
                __jamon__var_8.setId(track.getId());
                __jamon__var_8.setProperties(this.properties);
                __jamon__var_8.setLocale(this.locale);
                __jamon__var_8.setType("tr");
                __jamon__var_8.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                <span class=\"link\">\n                    <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/artist/" + track.getArtist().getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getArtist().getName())), jamonWriter);
                jamonWriter.write("</a>\n                    -\n                    ");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getName())), jamonWriter);
                jamonWriter.write("\n                </span>\n            </li>\n        ");
            }
            jamonWriter.write("\n    ");
        } else {
            jamonWriter.write("\n        <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n    </ul>\n</div>\n\n<div class=\"section\">\n    <h3>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.topArtists")), jamonWriter);
        jamonWriter.write("</h3>\n    <ul class=\"musiclist\">\n    ");
        if (this.topArtists.size() > 0) {
            jamonWriter.write("\n        ");
            for (Artist artist : this.topArtists) {
                jamonWriter.write("\n            <li class=\"artist\">\n                ");
                IMusicLinks __jamon__var_9 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_9.setName(artist.getName());
                __jamon__var_9.setId(artist.getId());
                __jamon__var_9.setProperties(this.properties);
                __jamon__var_9.setLocale(this.locale);
                __jamon__var_9.setType("ar");
                __jamon__var_9.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                <span class=\"link\">\n                    <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/artist/" + artist.getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(artist.getName())), jamonWriter);
                jamonWriter.write("</a>\n                </span>\n                <span class=\"info\">(");
                Escaping.HTML.write(StandardEmitter.valueOf((int)artist.getPlayCount()), jamonWriter);
                jamonWriter.write(" play");
                if (artist.getPlayCount() != 1) {
                    jamonWriter.write("s");
                }
                jamonWriter.write(")</span>\n            </li>\n        ");
            }
            jamonWriter.write("\n    ");
        } else {
            jamonWriter.write("\n        <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n    </ul>\n</div>\n\n");
        IFooter __jamon__var_10 = new IFooter(this.getTemplateManager());
        __jamon__var_10.setUser(this.user);
        __jamon__var_10.setProperties(this.properties);
        __jamon__var_10.setRecentUsers(this.recentUsers);
        __jamon__var_10.setLocale(this.locale);
        __jamon__var_10.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

