/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.CreateUserDialog;
import com.pugh.sockso.gui.MyTableModel;
import com.pugh.sockso.gui.controls.BooleanOptionField;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class UsersPanel
extends JPanel
implements TableModelListener {
    private static Logger log = Logger.getLogger(UsersPanel.class);
    private Properties p;
    private Database db;
    private Resources r;
    private JFrame parent;
    private MyTableModel model;
    private JTable table;
    private boolean isRefreshing;

    public UsersPanel(JFrame parent, Database db, Properties p, Resources r) {
        this.parent = parent;
        this.db = db;
        this.p = p;
        this.r = r;
        this.isRefreshing = false;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getOptionsPane(), "North");
        this.add((Component)this.getAccountsPane(), "Center");
        this.model.addTableModelListener(this);
        this.startAutoRefresh();
    }

    protected void startAutoRefresh() {
        long refreshTimeout = 30000L;
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (!UsersPanel.this.table.isEditing()) {
                                UsersPanel.this.refreshUsers();
                            }
                            1.sleep(30000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private JPanel getOptionsPane() {
        FormLayout layout = new FormLayout(" right:max(60dlu;pref), 10dlu, 150dlu, 7dlu ");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Options");
        builder.append("Require login:", (Component)new BooleanOptionField(this.p, "users.requireLogin"));
        builder.nextLine();
        builder.append("Disable registering:", (Component)new BooleanOptionField(this.p, "users.disableRegistration"));
        builder.nextLine();
        builder.append("Require activation:", (Component)new BooleanOptionField(this.p, "users.requireActivation"));
        builder.nextLine();
        return builder.getPanel();
    }

    private JPanel getAccountsPane() {
        JButton delete = new JButton("Delete", new ImageIcon(this.r.getImage("icons/16x16/delete.png")));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsersPanel.this.deleteSelectedUser();
            }
        });
        JButton create = new JButton("Create User", new ImageIcon(this.r.getImage("icons/16x16/add.png")));
        create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new CreateUserDialog(UsersPanel.this.parent, UsersPanel.this.db, UsersPanel.this.r, UsersPanel.this);
            }
        });
        JPanel accBtns = new JPanel(new FlowLayout(0));
        accBtns.add(create);
        accBtns.add(delete);
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        TableColumnModel columns = this.table.getColumnModel();
        this.table.getSelectionModel().setSelectionMode(0);
        int[] widths = new int[]{10, 150, 200, 90, 10, 10};
        for (int i = 0; i < widths.length; ++i) {
            columns.getColumn(i).setPreferredWidth(widths[i]);
        }
        JPanel pn = new JPanel();
        pn.setLayout(new BorderLayout());
        pn.add((Component)new JScrollPane(this.table), "Center");
        pn.add((Component)accBtns, "South");
        return pn;
    }

    public void tableChanged(TableModelEvent evt) {
        if (!this.isRefreshing) {
            this.saveChanges();
        }
    }

    protected void saveChanges() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            User user = new User(Integer.parseInt(this.model.getValueAt(i, 0).toString()), (String)this.model.getValueAt(i, 1), (String)this.model.getValueAt(i, 2), this.model.getValueAt(i, 4).equals("true"));
            user.setActive(this.model.getValueAt(i, 5).equals("1"));
            try {
                user.update(this.db);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
                JOptionPane.showMessageDialog(this.parent, e.getMessage(), "Sockso", 0);
            }
        }
    }

    protected void deleteSelectedUser() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            try {
                int id = Integer.parseInt((String)this.model.getValueAt(row, 0));
                User.delete(this.db, id);
                this.refreshUsers();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshUsers() {
        this.isRefreshing = true;
        for (int i = this.model.getRowCount(); i > 0; --i) {
            this.model.removeRow(i - 1);
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " select u.id, u.name, u.email, u.date_created, u.is_admin, u.is_active  from users u  order by u.name asc ";
            st = this.db.prepare(" select u.id, u.name, u.email, u.date_created, u.is_admin, u.is_active  from users u  order by u.name asc ");
            rs = st.executeQuery();
            while (rs.next()) {
                int row = this.model.getRowCount() + 1;
                this.model.setRowCount(row);
                this.model.setValueAt(rs.getString("id"), row - 1, 0);
                this.model.setValueAt(rs.getString("name"), row - 1, 1);
                this.model.setValueAt(rs.getString("email"), row - 1, 2);
                this.model.setValueAt(rs.getString("date_created"), row - 1, 3);
                this.model.setValueAt(rs.getString("is_admin"), row - 1, 4);
                this.model.setValueAt(rs.getString("is_active"), row - 1, 5);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e);
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                this.isRefreshing = false;
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
            this.isRefreshing = false;
        }
        Utils.close(rs);
        Utils.close(st);
        this.isRefreshing = false;
    }
}

