/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.DBExporter;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.ForwardPortDialog;
import com.pugh.sockso.gui.controls.BooleanOptionField;
import com.pugh.sockso.gui.controls.NumberOptionField;
import com.pugh.sockso.gui.controls.TextOptionField;
import com.pugh.sockso.gui.controls.UploadDirectoryOptionField;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.action.Nater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class GeneralPanel
extends JPanel {
    private static Logger log = Logger.getLogger(Logger.class);
    private final JFrame parent;
    private final Database db;
    private final Properties p;
    private final Resources r;
    private final Server sv;
    private final Locale locale;
    private final CollectionManager cm;
    private JComboBox exportRequestLogFormats;
    private JButton exportRequestLogButton;
    private JButton clearRequestLog;

    public GeneralPanel(JFrame parent, Database db, Properties p, Resources r, Server sv, CollectionManager cm) {
        this.parent = parent;
        this.db = db;
        this.p = p;
        this.r = r;
        this.sv = sv;
        this.cm = cm;
        this.locale = r.getCurrentLocale();
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.exportRequestLogFormats = new JComboBox<DBExporter.Format>(DBExporter.Format.values());
        this.exportRequestLogButton = new JButton(this.locale.getString("gui.label.export"), new ImageIcon(this.r.getImage("icons/16x16/export.png")));
        this.exportRequestLogButton.addActionListener(this.getExportRequestLogAction());
        this.clearRequestLog = new JButton(this.getClearRequestLogButtonText(), new ImageIcon(this.r.getImage("icons/16x16/remove.png")));
        this.clearRequestLog.addActionListener(this.getClearRequestLogAction());
    }

    private String getClearRequestLogButtonText() {
        return this.locale.getString("gui.label.clearRequestLog", new String[]{this.getRequestLogSize()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestLogSize() {
        PreparedStatement st;
        ResultSet rs;
        block4: {
            String string;
            rs = null;
            st = null;
            try {
                String sql = " select count(*) as total  from request_log ";
                st = this.db.prepare(" select count(*) as total  from request_log ");
                rs = st.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString("total");
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e);
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(rs);
            Utils.close(st);
            return string;
        }
        Utils.close(rs);
        Utils.close(st);
        return "unknown";
    }

    private void layoutComponents() {
        FormLayout layout = new FormLayout(" right:max(40dlu;pref), 3dlu, 150dlu, 7dlu ");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.locale.getString("gui.label.community"));
        builder.append(this.locale.getString("gui.label.communityEnabled"), (Component)new BooleanOptionField(this.p, "community.enabled"));
        builder.nextLine();
        builder.appendSeparator(this.locale.getString("gui.label.webServer"));
        builder.append(this.locale.getString("gui.label.port"), (Component)new NumberOptionField(this.p, "server.port"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.basepath"), (Component)new TextOptionField(this.p, "server.basepath"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.wwwTitle"), (Component)new TextOptionField(this.p, "www.title"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.wwwTagline"), (Component)new TextOptionField(this.p, "www.tagline"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.disableDownloads"), (Component)new BooleanOptionField(this.p, "www.disableDownloads"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.enableFolderBrowsing"), (Component)new BooleanOptionField(this.p, "browse.folders.enabled"));
        String scheduler = this.p.get("scheduler", "");
        if (!scheduler.equals("cron") && !scheduler.equals("manual")) {
            builder.appendSeparator(this.locale.getString("gui.label.collection"));
            builder.append(this.locale.getString("gui.label.scanOnStartup"), (Component)new BooleanOptionField(this.p, "collman.scan.onStart"));
            builder.nextLine();
            builder.append(this.locale.getString("gui.label.scanInterval"), (Component)new NumberOptionField(this.p, "scheduler.simple.interval"));
            builder.nextLine();
        }
        builder.appendSeparator(this.locale.getString("gui.label.uploads"));
        builder.append(this.locale.getString("gui.label.enableUploads"), (Component)new BooleanOptionField(this.p, "uploads.enabled"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.anonymousUploads"), (Component)new BooleanOptionField(this.p, "uploads.allowAnonymous"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.uploadsDirectory"), (Component)new UploadDirectoryOptionField(this.parent, this.p, "uploads.collectionId", this.locale, this.db, this.cm));
        builder.nextLine();
        builder.appendSeparator(this.locale.getString("gui.label.general"));
        builder.append(this.locale.getString("gui.label.startMinimized"), (Component)new BooleanOptionField(this.p, "app.startMinimized"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.confirmExit"), (Component)new BooleanOptionField(this.p, "app.confirmExit"));
        builder.nextLine();
        builder.appendSeparator(this.locale.getString("gui.label.logging"));
        builder.append(this.locale.getString("gui.label.enableRequestLog"), (Component)new BooleanOptionField(this.p, "log.requests.enable"));
        builder.nextLine();
        builder.append(this.locale.getString("gui.label.exportRequestLogAs"), (Component)this.exportRequestLogFormats);
        builder.nextLine();
        builder.append("", (Component)this.exportRequestLogButton);
        builder.nextLine();
        builder.append("", (Component)this.clearRequestLog);
        builder.nextLine();
        JButton testNat = new JButton(this.locale.getString("gui.label.testNat"));
        testNat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.doNatTest();
            }
        });
        JButton forwardPort = new JButton(this.locale.getString("gui.label.portForward"), new ImageIcon(this.r.getImage("icons/22x22/port_forward.png")));
        forwardPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.showForwardPortDialog();
            }
        });
        builder.appendSeparator(this.locale.getString("gui.label.natSetup"));
        builder.append("", (Component)testNat);
        builder.nextLine();
        builder.append("", (Component)forwardPort);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(builder.getPanel()), "Center");
    }

    private void showForwardPortDialog() {
        new ForwardPortDialog(this.parent, this.sv, this.r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNatTest() {
        String result = this.locale.getString("gui.message.natTestFailed");
        int port = Integer.parseInt(this.p.get("server.port"));
        BufferedReader in = null;
        try {
            String urlString = "http://sockso.pu-gh.com/nat/test/" + port;
            URL url = new URL(urlString);
            log.debug((Object)("NAT Test URL: " + urlString));
            HttpURLConnection cnn = (HttpURLConnection)url.openConnection();
            cnn.setRequestMethod("GET");
            in = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
            String s = in.readLine();
            log.debug((Object)("Nat Test Response: " + s));
            if (s.equals(Nater.NAT_TEST_STRING)) {
                result = this.locale.getString("gui.message.natTestOk");
            }
            Utils.close(in);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            Utils.close(in);
        }
        JOptionPane.showMessageDialog(this.parent, result);
    }

    private ActionListener getClearRequestLogAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int result = JOptionPane.showConfirmDialog(GeneralPanel.this.parent, GeneralPanel.this.locale.getString("gui.message.confirmClearRequestLog"), "Sockso", 0);
                if (result == 0) {
                    try {
                        String sql = " delete from request_log ";
                        GeneralPanel.this.db.update(" delete from request_log ");
                        GeneralPanel.this.clearRequestLog.setText(GeneralPanel.this.getClearRequestLogButtonText());
                        JOptionPane.showMessageDialog(GeneralPanel.this.parent, GeneralPanel.this.locale.getString("gui.message.requestLogCleared"), "Sockso", 1);
                    }
                    catch (SQLException e) {
                        JOptionPane.showMessageDialog(GeneralPanel.this.parent, e.getMessage(), "Sockso", 0);
                        log.error((Object)e);
                    }
                }
            }
        };
    }

    private ActionListener getExportRequestLogAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                int result = chooser.showSaveDialog(GeneralPanel.this.parent);
                if (result == 0) {
                    DBExporter exporter = new DBExporter(GeneralPanel.this.db);
                    DBExporter.Format format = (DBExporter.Format)((Object)GeneralPanel.this.exportRequestLogFormats.getSelectedItem());
                    String sql = " select *  from request_log  order by date_of_request desc ";
                    File saveFile = chooser.getSelectedFile();
                    try {
                        FileWriter writer = new FileWriter(saveFile);
                        String data = exporter.export(" select *  from request_log  order by date_of_request desc ", format);
                        writer.write(data);
                        writer.close();
                        JOptionPane.showMessageDialog(GeneralPanel.this.parent, GeneralPanel.this.locale.getString("gui.message.exportComplete"));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(GeneralPanel.this.parent, e.getMessage());
                    }
                }
            }
        };
    }
}

