/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.db;

import com.pugh.sockso.db.Database;
import com.pugh.sockso.db.DatabaseConnectionException;
import com.pugh.sockso.db.JDBCDatabase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;

public class MySQLDatabase
extends JDBCDatabase
implements Database {
    private static final Logger log = Logger.getLogger(MySQLDatabase.class);
    private Connection cnn;

    public void connect(OptionSet options) throws DatabaseConnectionException {
        String dbHost = options.has("dbhost") ? options.valueOf("dbhost").toString() : "localhost";
        String dbUser = options.has("dbuser") ? options.valueOf("dbuser").toString() : "root";
        String dbPass = options.has("dbpass") ? options.valueOf("dbpass").toString() : "";
        String dbName = options.has("dbname") ? options.valueOf("dbname").toString() : "sockso";
        this.connect(dbHost, dbUser, dbPass, dbName);
    }

    public void connect(String dbHost, String dbUser, String dbPass, String dbName) throws DatabaseConnectionException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.cnn = DriverManager.getConnection("jdbc:mysql://" + dbHost, dbUser, dbPass);
            this.update(" use " + dbName);
            this.update(" set names utf8 ");
            this.createStructure();
            this.checkArtistsBrowseNameField();
            this.checkIndexerTableExists();
            this.checkUserAdminColumnExists();
            this.checkUserIsActiveColumnExists();
            this.checkAlbumYearColumnExists();
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(e.getMessage());
        }
    }

    public ResultSet query(String sql) throws SQLException {
        return this.query(sql, false);
    }

    protected void createStructure() {
        String sql = "";
        try {
            sql = " create table tracks (  id int unsigned not null auto_increment,  artist_id int unsigned not null,  album_id int unsigned null,  name varchar(255) not null,  path varchar(500) not null,  length int unsigned not null,  date_added datetime not null,  collection_id int unsigned not null,  track_no smallint null,  primary key ( id ),  unique ( artist_id, album_id, name )  ) character set utf8 ";
            this.update(sql);
            sql = " create table play_log (  id int unsigned not null auto_increment,  track_id int unsigned null,  date_played datetime not null,  user_id int unsigned null,  scrobbled tinyint(1) not null default 0,  primary key ( id )  ) character set utf8 ";
            this.update(sql);
            sql = " create table playlist_tracks (  id int unsigned not null auto_increment,  playlist_id int unsigned null,  track_id int unsigned null,  primary key ( id )  ) character set utf8 ";
            this.update(sql);
            sql = " create table playlists (  id int unsigned not null auto_increment,  name varchar(255) not null,  date_created datetime not null,  date_modified datetime not null,  user_id int unsigned null,  primary key ( id ),  unique ( name )  ) character set utf8 ";
            this.update(sql);
            sql = " create table collection (  id int unsigned not null auto_increment,  path varchar(500) not null,  primary key ( id )  ) character set utf8 ";
            this.update(sql);
            sql = " create table artists (  id int unsigned not null auto_increment,  name varchar(255) not null,  date_added datetime not null,  primary key ( id ),  unique ( name )  ) character set utf8 ";
            this.update(sql);
            sql = " create table albums (  id int unsigned not null auto_increment,  artist_id int unsigned not null,  name varchar(255) not null,  date_added datetime not null,  primary key ( id ),  unique ( artist_id, name )  ) character set utf8 ";
            this.update(sql);
            sql = " create table request_log (  id int unsigned not null auto_increment,  user_id int unsigned null,  ip_address char(16) not null,  date_of_request datetime not null,  request_url varchar(255) not null,  user_agent varchar(255) not null,  referer varchar(255) not null,  cookies varchar(255) not null,  primary key ( id )  ) character set utf8 ";
            this.update(sql);
            sql = " create table sessions (  id int unsigned not null auto_increment,  code char(10) not null,  user_id int unsigned not null,  date_created datetime not null,  primary key ( id )  ) character set utf8 ";
            this.update(sql);
            sql = " create table users (  id int unsigned not null auto_increment, name varchar(50) not null unique,  pass char(32) not null,  email varchar(255) not null, date_created datetime not null, primary key ( id ) ) character set utf8 ";
            this.update(sql);
            sql = " create table properties (  id int unsigned not null auto_increment,  name varchar(100) not null,  value varchar(255) not null, primary key ( id ),  unique ( name )  ) character set utf8 ";
            this.update(sql);
            sql = " create index ix_play_log_track_id  on play_log ( track_id ) ";
            this.update(sql);
            this.setDefaultProperties();
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    private void checkArtistsBrowseNameField() {
        try {
            String sql = " alter table artists  add browse_name varchar(255) null ";
            this.update(sql);
            sql = " update artists  set browse_name = name ";
            this.update(sql);
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    private void checkIndexerTableExists() {
        try {
            String sql = " create table indexer (  id int unsigned not null,   last_modified datetime not null,  primary key ( id )  ) ";
            this.update(" create table indexer (  id int unsigned not null,   last_modified datetime not null,  primary key ( id )  ) ");
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    private void checkUserAdminColumnExists() {
        String sql = " alter table users  add is_admin tinyint(1) not null default '0' ";
        this.safeUpdate(" alter table users  add is_admin tinyint(1) not null default '0' ");
    }

    public Connection getConnection() {
        return this.cnn;
    }

    public String escape(String str) {
        return str.replaceAll("'", "\\\\'");
    }

    public void close() {
        try {
            this.cnn.close();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public String getRandomFunction() {
        return "rand";
    }
}

