/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.db;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.AbstractDatabase;
import com.pugh.sockso.db.DatabaseConnectionException;
import com.pugh.sockso.db.JDBCDatabase;
import com.pugh.sockso.music.encoders.Encoders;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;

public class HSQLDatabase
extends JDBCDatabase {
    private static final Logger log = Logger.getLogger(AbstractDatabase.class);
    private final String dataPath;
    private Connection connection;
    private String connectionString;

    public HSQLDatabase() {
        this(HSQLDatabase.getDefaultDatabasePath(""));
    }

    public HSQLDatabase(String dataPath) {
        this(dataPath, "jdbc:hsqldb:file:" + dataPath);
    }

    public HSQLDatabase(String dataPath, String connectionString) {
        this.dataPath = dataPath;
        this.connectionString = connectionString;
    }

    public void connect(OptionSet options) throws DatabaseConnectionException {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.connection = DriverManager.getConnection(this.connectionString, "sa", "");
        }
        catch (Exception e) {
            if (e.getMessage().contains("old version")) {
                throw new DatabaseConnectionException("You seem to have upgraded Sockso without exiting the old version cleanly.  This has left the database in an inconsistent state.  To run the new version of Sockso you will first need to run, and cleanly (ie. press exit) close the old version.");
            }
            throw new DatabaseConnectionException(e.getMessage());
        }
        this.checkDefaultStructure();
        this.setDefaultSettings();
        this.checkUserSessionsUpgrade();
        this.checkLogRequestsUpgrade();
        this.checkCollectionPathBackslashes();
        this.checkPlayLogTrackIndex();
        this.checkMultipleSlashesInCollection();
        this.checkRemoveTracksAddedByField();
        this.checkOldRequireLoginProperty();
        this.checkPlayLogUserId();
        this.checkScrobbledLogField();
        this.checkArtistsBrowseNameField();
        this.checkIndexerTableExists();
        this.checkUserAdminColumnExists();
        this.checkUserIsActiveColumnExists();
        this.checkAlbumYearColumnExists();
    }

    private void setDefaultSettings() {
        try {
            this.update(" set write_delay 0 ");
            this.update(" set ignorecase true ");
        }
        catch (SQLException e) {
            log.fatal((Object)e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void checkUserAdminColumnExists() {
        String sql = " alter table users  add is_admin bit default 0 ";
        this.safeUpdate(" alter table users  add is_admin bit default 0 ");
    }

    private void checkIndexerTableExists() {
        String sql = " create table indexer (  id integer not null,   last_modified timestamp not null,  primary key ( id )  ) ";
        this.safeUpdate(" create table indexer (  id integer not null,   last_modified timestamp not null,  primary key ( id )  ) ");
    }

    private void checkArtistsBrowseNameField() {
        try {
            String sql = " alter table artists  add browse_name varchar_ignorecase(255) null ";
            this.update(sql);
            sql = " update artists  set browse_name = name ";
            this.update(sql);
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    private void checkScrobbledLogField() {
        try {
            String sql = " alter table play_log  add scrobbled bit default 0 ";
            this.update(" alter table play_log  add scrobbled bit default 0 ");
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    private void checkPlayLogUserId() {
        try {
            String sql = " alter table play_log  add user_id int null ";
            this.update(" alter table play_log  add user_id int null ");
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOldRequireLoginProperty() {
        block6: {
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                String sql = " select value  from properties  where name = ? ";
                st = this.prepare(sql);
                st.setString(1, "uploads.requireLogin");
                rs = st.executeQuery();
                if (rs.next()) {
                    this.setProperty("uploads.allowAnonymous", rs.getString("value"));
                    sql = " delete from properties  where name = 'uploads.requireLogin' ";
                    this.update(sql);
                }
                Utils.close(rs);
            }
            catch (SQLException e) {
                log.debug((Object)e);
                break block6;
            }
            finally {
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(st);
        }
    }

    private void checkRemoveTracksAddedByField() {
        try {
            String sql = " alter table tracks  drop column addedBy ";
            this.update(" alter table tracks  drop column addedBy ");
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMultipleSlashesInCollection() {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String separator = System.getProperty("file.separator");
            String sql = " select id, path  from collection ";
            st = this.prepare(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                String newPath = rs.getString("path").replaceAll("^(.*?\\" + separator + ")\\" + separator + "*$", "$1");
                sql = " update collection  set path = '" + this.escape(newPath) + "' " + " where id = " + rs.getString("id");
                this.update(sql);
            }
        }
        catch (SQLException e) {
            try {
                log.debug((Object)e);
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
        }
        Utils.close(rs);
        Utils.close(st);
    }

    private void checkPlayLogTrackIndex() {
        try {
            String sql = " create index ix_play_log_track_id  on play_log ( track_id ) ";
            this.update(" create index ix_play_log_track_id  on play_log ( track_id ) ");
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    private void checkCollectionPathBackslashes() {
        String separator = System.getProperty("file.separator");
        try {
            String sql = " select id, path  from collection ";
            ResultSet rs = this.query(sql);
            while (rs.next()) {
                if (rs.getString("path").matches(".*\\" + separator + "$")) continue;
                sql = " update collection  set path = path + '" + separator + "'" + " where id = " + rs.getString("id");
                this.update(sql);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLogRequestsUpgrade() {
        String sql = "";
        ResultSet rs = null;
        try {
            sql = " select p.value as value  from properties p  where p.name = 'player.lame.use' ";
            rs = this.query(sql);
            if (rs.next() && rs.getString("value").equals("yes")) {
                rs.close();
                String bitrate = "128";
                sql = " select p.value as value  from properties p  where p.name = 'player.lame.bitrate' ";
                rs = this.query(sql);
                if (rs.next()) {
                    bitrate = rs.getString("value");
                }
                this.setProperty("encoders.mp3", Encoders.Type.BUILTIN.name());
                this.setProperty("encoders.mp3.name", Encoders.Builtin.Lame.name());
                this.setProperty("encoders.mp3.bitrate", bitrate);
                this.setProperty("player.lame.use", "");
                this.setProperty("player.lame.bitrate", "");
            }
            sql = " create table request_log (  id integer not null identity,  user_id integer null, ip_address char(16) not null,  date_of_request timestamp not null,  request_url varchar(255) not null,  user_agent varchar(255) not null,  referer varchar(255) not null,  cookies varchar(255) not null,  primary key ( id )  ) ";
            this.update(sql);
        }
        catch (SQLException e) {
            try {
                log.debug((Object)e);
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                throw throwable;
            }
            Utils.close(rs);
        }
        Utils.close(rs);
    }

    protected void checkUserSessionsUpgrade() {
        String sql = "";
        try {
            sql = " alter table playlists  add user_id integer null ";
            this.update(sql);
            sql = " create table users (  id integer not null identity,  name varchar(50) not null,  pass char(32) not null,  email varchar(255) not null,  date_created timestamp not null,  unique ( name ),  unique ( email ),  primary key ( id )  ) ";
            this.update(sql);
            sql = " create table sessions (  id integer not null identity,  code char(10) not null,  user_id integer not null,  date_created timestamp not null,  unique ( id, code ),  primary key ( id )  ) ";
            this.update(sql);
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    public void close() {
        log.info((Object)"Shutting Down");
        try {
            this.update("shutdown");
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    private void checkDefaultStructure() {
        log.debug((Object)"Checking Database Existence");
        if (new File(this.dataPath + ".script").exists()) {
            return;
        }
        try {
            log.debug((Object)"Creating Database Structure");
            this.update("set ignorecase true");
            this.update(" create table artists (  id integer not null identity,  name varchar(255) not null,  date_added timestamp not null,  unique ( name ),  primary key ( id )  ) ");
            log.debug((Object)"Created 'artists' table");
            this.update(" create table albums (  id integer not null identity,  artist_id integer not null,  name varchar(255) not null,  date_added timestamp not null,  unique( artist_id, name ),  primary key ( id )  ) ");
            log.debug((Object)"Created 'albums' table");
            this.update(" create table tracks (  id integer not null identity,  artist_id integer not null,  album_id integer null,  name varchar(255) not null,  path varchar(500) not null,  length integer not null,  date_added timestamp not null,  collection_id integer not null,  track_no integer null,  unique ( artist_id, album_id, name ),  primary key ( id )  ) ");
            log.debug((Object)"Created 'tracks' table");
            this.update(" create table properties (  id integer not null identity,  name varchar(100) not null,  value varchar(255) not null,  unique ( name ),  primary key ( id )  ) ");
            log.debug((Object)"Created 'properties' table");
            this.update(" create table collection (  id integer not null identity,  path varchar(500) not null,  unique ( path ),  primary key ( id )  ) ");
            log.debug((Object)"Created 'collection' table");
            this.update(" create table play_log (  id integer not null identity,  track_id integer not null,  date_played timestamp not null,  primary key ( id )  ) ");
            log.debug((Object)"Created 'play_log' table");
            this.update(" create table playlists (  id integer not null identity,  name varchar(255) not null,  date_created timestamp not null,  date_modified timestamp not null,  unique ( name ),  primary key ( id )  ) ");
            log.debug((Object)"Created 'playlists' table");
            this.update(" create table playlist_tracks (  id integer not null identity,  playlist_id integer not null,  track_id integer not null,  primary key ( id )  ) ");
            log.debug((Object)"Created 'playlist_tracks' table");
            this.setDefaultProperties();
            log.debug((Object)"Created Default Properties");
            log.debug((Object)"Database Setup Complete");
        }
        catch (SQLException e) {
            log.fatal((Object)("Error Creating Database: " + e.getMessage()));
        }
    }

    public String escape(String str) {
        return str.replaceAll("'", "''");
    }

    public String getRandomFunction() {
        return "rand";
    }
}

