/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Properties;
import com.pugh.sockso.commands.BaseCommand;
import java.util.Arrays;

public class PropList
extends BaseCommand {
    private final Properties p;

    public PropList(Properties p) {
        this.p = p;
    }

    public String getName() {
        return "proplist";
    }

    public String getDescription() {
        return "Lists properties";
    }

    public String execute(String[] args) {
        StringBuffer sb = new StringBuffer();
        String pattern = args.length > 1 ? args[1] : null;
        Object[] props = this.p.getProperties();
        int longest = this.getLongestStringLength((String[])props);
        Arrays.sort(props);
        sb.append(" NAME" + this.getPadding(4, longest) + "  VALUE\n");
        if (pattern != null) {
            sb.append("\n (containing '" + pattern + "')\n");
        }
        sb.append("\n");
        for (Object prop : props) {
            if (pattern != null && !((String)prop).contains(pattern)) continue;
            sb.append(" " + (String)prop + this.getPadding(((String)prop).length(), longest) + "  " + this.p.get((String)prop));
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String getPadding(int length, int longest) {
        String padding = "";
        for (int i = length; i < longest; ++i) {
            padding = padding + " ";
        }
        return padding;
    }

    protected int getLongestStringLength(String[] strings) {
        int longest = 0;
        for (String string : strings) {
            int length = string.length();
            if (length <= longest) continue;
            longest = length;
        }
        return longest;
    }

    public String[] getArguments() {
        return new String[]{"FILTER"};
    }
}

