/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.jaudiotagger.MutableTreeNode;
import org.jaudiotagger.TreeNode;

public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = new Enumeration<TreeNode>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public TreeNode nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected MutableTreeNode parent = null;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public DefaultMutableTreeNode() {
        this(null);
    }

    public DefaultMutableTreeNode(Object userObject) {
        this(userObject, true);
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)this.children.elementAt(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setAllowsChildren(boolean allows) {
        if (allows != this.allowsChildren) {
            this.allowsChildren = allows;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void remove(MutableTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(MutableTreeNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreeNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        return anotherNode.isNodeAncestor(this);
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode aNode) {
        TreeNode node2;
        TreeNode node1;
        int diff;
        if (aNode == this) {
            return this;
        }
        if (aNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = aNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = aNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = aNode;
        }
        while (diff > 0) {
            node1 = node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode aNode) {
        return aNode != null && this.getRoot() == aNode.getRoot();
    }

    public int getDepth() {
        Object last = null;
        Enumeration enum_ = this.breadthFirstEnumeration();
        while (enum_.hasMoreElements()) {
            last = enum_.nextElement();
        }
        if (last == null) {
            throw new Error("nodes should be null");
        }
        return ((DefaultMutableTreeNode)last).getLevel() - this.getLevel();
    }

    public int getLevel() {
        int levels = 0;
        TreeNode ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] realPath = this.getPath();
        Object[] retPath = new Object[realPath.length];
        for (int counter = 0; counter < realPath.length; ++counter) {
            retPath[counter] = ((DefaultMutableTreeNode)realPath[counter]).getUserObject();
        }
        return retPath;
    }

    public TreeNode getRoot() {
        DefaultMutableTreeNode previous;
        TreeNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public DefaultMutableTreeNode getNextNode() {
        if (this.getChildCount() == 0) {
            DefaultMutableTreeNode nextSibling = this.getNextSibling();
            if (nextSibling == null) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.getParent();
                while (true) {
                    if (aNode == null) {
                        return null;
                    }
                    nextSibling = aNode.getNextSibling();
                    if (nextSibling != null) {
                        return nextSibling;
                    }
                    aNode = (DefaultMutableTreeNode)aNode.getParent();
                }
            }
            return nextSibling;
        }
        return (DefaultMutableTreeNode)this.getChildAt(0);
    }

    public DefaultMutableTreeNode getPreviousNode() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            if (previousSibling.getChildCount() == 0) {
                return previousSibling;
            }
            return previousSibling.getLastLeaf();
        }
        return myParent;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode ancestor) {
        return new PathBetweenNodesEnumeration(ancestor, this);
    }

    public boolean isNodeChild(TreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public TreeNode getChildAfter(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (index < this.getChildCount() - 1) {
            return this.getChildAt(index + 1);
        }
        return null;
    }

    public TreeNode getChildBefore(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (index > 0) {
            return this.getChildAt(index - 1);
        }
        return null;
    }

    public boolean isNodeSibling(TreeNode anotherNode) {
        boolean retval;
        if (anotherNode == null) {
            retval = false;
        } else if (anotherNode == this) {
            retval = true;
        } else {
            TreeNode myParent = this.getParent();
            boolean bl = retval = myParent != null && myParent == anotherNode.getParent();
            if (retval && !((DefaultMutableTreeNode)this.getParent()).isNodeChild(anotherNode)) {
                throw new Error("sibling has different parent");
            }
        }
        return retval;
    }

    public int getSiblingCount() {
        TreeNode myParent = this.getParent();
        if (myParent == null) {
            return 1;
        }
        return myParent.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode retval = myParent == null ? null : (DefaultMutableTreeNode)myParent.getChildAfter(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new Error("child of parent is not a sibling");
        }
        return retval;
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode retval = myParent == null ? null : (DefaultMutableTreeNode)myParent.getChildBefore(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new Error("child of parent is not a sibling");
        }
        return retval;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getFirstChild();
        }
        return node;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getLastChild();
        }
        return node;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            return nextSibling.getFirstLeaf();
        }
        return myParent.getNextLeaf();
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            return previousSibling.getLastLeaf();
        }
        return myParent.getPreviousLeaf();
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration enum_ = this.breadthFirstEnumeration();
        while (enum_.hasMoreElements()) {
            TreeNode node = (TreeNode)enum_.nextElement();
            if (!node.isLeaf()) continue;
            ++count;
        }
        if (count < 1) {
            throw new Error("tree has zero leaves");
        }
        return count;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public Object clone() {
        DefaultMutableTreeNode newNode = null;
        try {
            newNode = (DefaultMutableTreeNode)super.clone();
            newNode.children = null;
            newNode.parent = null;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        return newNode;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] tValues = this.userObject != null && this.userObject instanceof Serializable ? new Object[]{"userObject", this.userObject} : new Object[]{};
        s.writeObject(tValues);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object[] tValues = (Object[])s.readObject();
        if (tValues.length > 0 && tValues[0].equals("userObject")) {
            this.userObject = tValues[1];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PathBetweenNodesEnumeration
    implements Enumeration<TreeNode> {
        protected Stack<TreeNode> stack;

        public PathBetweenNodesEnumeration(TreeNode ancestor, TreeNode descendant) {
            if (ancestor == null || descendant == null) {
                throw new IllegalArgumentException("argument is null");
            }
            this.stack = new Stack();
            this.stack.push(descendant);
            TreeNode current = descendant;
            while (current != ancestor) {
                if ((current = current.getParent()) == null && descendant != ancestor) {
                    throw new IllegalArgumentException("node " + ancestor + " is not an ancestor of " + descendant);
                }
                this.stack.push(current);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        @Override
        public TreeNode nextElement() {
            try {
                return this.stack.pop();
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class BreadthFirstEnumeration
    implements Enumeration<TreeNode> {
        protected Queue queue;

        public BreadthFirstEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration enumer = (Enumeration)this.queue.firstObject();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration children = node.children();
            if (!enumer.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PostorderEnumeration
    implements Enumeration<TreeNode> {
        protected TreeNode root;
        protected Enumeration<TreeNode> children;
        protected Enumeration<TreeNode> subtree;

        public PostorderEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public TreeNode nextElement() {
            TreeNode retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration(this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PreorderEnumeration
    implements Enumeration<TreeNode> {
        protected Stack stack;

        public PreorderEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.stack = new Stack();
            this.stack.push(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration enumer = (Enumeration)this.stack.peek();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration children = node.children();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            return node;
        }
    }
}

