/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.remote.SaslContext;

final class SaslClientContext
implements SaslContext {
    private final SaslClient saslClient;

    SaslClientContext(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    public String getMechanismName() {
        return this.saslClient.getMechanismName();
    }

    public Object getNegotiatedProperty(String name) {
        return this.saslClient.getNegotiatedProperty(name);
    }

    public ByteBuffer unwrap(ByteBuffer src) throws SaslException {
        byte[] unwrapped;
        if (src.hasArray()) {
            byte[] orig = src.array();
            int start = src.arrayOffset() + src.position();
            int len = src.remaining();
            unwrapped = this.saslClient.unwrap(orig, start, len);
        } else {
            int len = src.remaining();
            byte[] orig = new byte[len];
            src.get(orig);
            unwrapped = this.saslClient.unwrap(orig, 0, len);
        }
        return ByteBuffer.wrap(unwrapped);
    }
}

