/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedTldMetaDataDeployer
extends AbstractDeployer {
    public static final String SHARED_TLDS_ATTACHMENT_NAME = "shared." + TldMetaData.class.getName();
    private List<URL> tldJars = null;
    private List<TldMetaData> sharedTldMetaData = null;

    public List<URL> getTldJars() {
        return this.tldJars;
    }

    public void setTldJars(List<URL> tldJars) {
        this.tldJars = tldJars;
    }

    public SharedTldMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addOutput(SHARED_TLDS_ATTACHMENT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!unit.getSimpleName().endsWith(".war")) {
            return;
        }
        SharedTldMetaDataDeployer sharedTldMetaDataDeployer = this;
        synchronized (sharedTldMetaDataDeployer) {
            if (this.sharedTldMetaData == null && this.tldJars != null) {
                UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                Unmarshaller unmarshaller = factory.newUnmarshaller();
                MutableSchemaResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
                this.sharedTldMetaData = new ArrayList<TldMetaData>();
                if (this.tldJars != null) {
                    SuffixMatchFilter tldFilter = new SuffixMatchFilter(".tld", VisitorAttributes.DEFAULT);
                    for (URL tldJar : this.tldJars) {
                        try {
                            VirtualFile virtualFile = VFS.getChild((URL)tldJar);
                            VirtualFile metaInf = virtualFile.getChild("META-INF");
                            if (metaInf == null) continue;
                            List tlds = metaInf.getChildren((VirtualFileFilter)tldFilter);
                            for (VirtualFile tld : tlds) {
                                TldMetaData tldMetaData = (TldMetaData)unmarshaller.unmarshal(tld.toURL().toString(), (SchemaBindingResolver)resolver);
                                this.sharedTldMetaData.add(tldMetaData);
                            }
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Error processing TLDs for JAR: " + tldJar, (Throwable)e);
                        }
                    }
                }
            }
        }
        if (this.sharedTldMetaData != null) {
            ArrayList<TldMetaData> clone = new ArrayList<TldMetaData>();
            clone.addAll(this.sharedTldMetaData);
            unit.addAttachment(SHARED_TLDS_ATTACHMENT_NAME, clone);
        }
    }
}

