/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.PropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.utils.UUID;

public interface Message {
    public static final SimpleString HDR_ACTUAL_EXPIRY_TIME = new SimpleString("_HQ_ACTUAL_EXPIRY");
    public static final SimpleString HDR_ORIGINAL_ADDRESS = new SimpleString("_HQ_ORIG_ADDRESS");
    public static final SimpleString HDR_ORIG_MESSAGE_ID = new SimpleString("_HQ_ORIG_MESSAGE_ID");
    public static final SimpleString HDR_GROUP_ID = new SimpleString("_HQ_GROUP_ID");
    public static final SimpleString HDR_SCHEDULED_DELIVERY_TIME = new SimpleString("_HQ_SCHED_DELIVERY");
    public static final SimpleString HDR_DUPLICATE_DETECTION_ID = new SimpleString("_HQ_DUPL_ID");
    public static final SimpleString HDR_LAST_VALUE_NAME = new SimpleString("_HQ_LVQ_NAME");
    public static final byte DEFAULT_TYPE = 0;
    public static final byte OBJECT_TYPE = 2;
    public static final byte TEXT_TYPE = 3;
    public static final byte BYTES_TYPE = 4;
    public static final byte MAP_TYPE = 5;
    public static final byte STREAM_TYPE = 6;

    public long getMessageID();

    public UUID getUserID();

    public void setUserID(UUID var1);

    public SimpleString getAddress();

    public void setAddress(SimpleString var1);

    public byte getType();

    public boolean isDurable();

    public void setDurable(boolean var1);

    public long getExpiration();

    public boolean isExpired();

    public void setExpiration(long var1);

    public long getTimestamp();

    public void setTimestamp(long var1);

    public byte getPriority();

    public void setPriority(byte var1);

    public int getEncodeSize();

    public boolean isLargeMessage();

    public HornetQBuffer getBodyBuffer();

    public void putBooleanProperty(SimpleString var1, boolean var2);

    public void putBooleanProperty(String var1, boolean var2);

    public void putByteProperty(SimpleString var1, byte var2);

    public void putByteProperty(String var1, byte var2);

    public void putBytesProperty(SimpleString var1, byte[] var2);

    public void putBytesProperty(String var1, byte[] var2);

    public void putShortProperty(SimpleString var1, short var2);

    public void putShortProperty(String var1, short var2);

    public void putIntProperty(SimpleString var1, int var2);

    public void putIntProperty(String var1, int var2);

    public void putLongProperty(SimpleString var1, long var2);

    public void putLongProperty(String var1, long var2);

    public void putFloatProperty(SimpleString var1, float var2);

    public void putFloatProperty(String var1, float var2);

    public void putDoubleProperty(SimpleString var1, double var2);

    public void putDoubleProperty(String var1, double var2);

    public void putStringProperty(SimpleString var1, SimpleString var2);

    public void putStringProperty(String var1, String var2);

    public void putObjectProperty(SimpleString var1, Object var2) throws PropertyConversionException;

    public void putObjectProperty(String var1, Object var2) throws PropertyConversionException;

    public Object removeProperty(SimpleString var1);

    public Object removeProperty(String var1);

    public boolean containsProperty(SimpleString var1);

    public boolean containsProperty(String var1);

    public Boolean getBooleanProperty(SimpleString var1) throws PropertyConversionException;

    public Boolean getBooleanProperty(String var1) throws PropertyConversionException;

    public Byte getByteProperty(SimpleString var1) throws PropertyConversionException;

    public Byte getByteProperty(String var1) throws PropertyConversionException;

    public Double getDoubleProperty(SimpleString var1) throws PropertyConversionException;

    public Double getDoubleProperty(String var1) throws PropertyConversionException;

    public Integer getIntProperty(SimpleString var1) throws PropertyConversionException;

    public Integer getIntProperty(String var1) throws PropertyConversionException;

    public Long getLongProperty(SimpleString var1) throws PropertyConversionException;

    public Long getLongProperty(String var1) throws PropertyConversionException;

    public Object getObjectProperty(SimpleString var1);

    public Object getObjectProperty(String var1);

    public Short getShortProperty(SimpleString var1) throws PropertyConversionException;

    public Short getShortProperty(String var1) throws PropertyConversionException;

    public Float getFloatProperty(SimpleString var1) throws PropertyConversionException;

    public Float getFloatProperty(String var1) throws PropertyConversionException;

    public String getStringProperty(SimpleString var1) throws PropertyConversionException;

    public String getStringProperty(String var1) throws PropertyConversionException;

    public SimpleString getSimpleStringProperty(SimpleString var1) throws PropertyConversionException;

    public SimpleString getSimpleStringProperty(String var1) throws PropertyConversionException;

    public byte[] getBytesProperty(SimpleString var1) throws PropertyConversionException;

    public byte[] getBytesProperty(String var1) throws PropertyConversionException;

    public Set<SimpleString> getPropertyNames();

    public Map<String, Object> toMap();
}

