/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentPropertyDescriptor;
import org.apache.myfaces.view.facelets.tag.composite.InterfaceDescriptorCreator;

public class FacetHandler
extends TagHandler
implements InterfaceDescriptorCreator {
    private static final Logger log = Logger.getLogger(FacetHandler.class.getName());
    private final TagAttribute _name = this.getRequiredAttribute("name");
    private final TagAttribute _displayName = this.getAttribute("displayName");
    private final TagAttribute _required = this.getAttribute("required");
    private final TagAttribute _preferred = this.getAttribute("preferred");
    private final TagAttribute _expert = this.getAttribute("expert");
    private final TagAttribute _shortDescription = this.getAttribute("shortDescription");
    protected final TagAttribute _hidden = this.getAttribute("hidden");
    private boolean _cacheable;
    private PropertyDescriptor _propertyDescriptor;

    public FacetHandler(TagConfig config) {
        super(config);
        if (!(!this._name.isLiteral() || this._displayName != null && !this._displayName.isLiteral() || this._preferred != null && !this._preferred.isLiteral() || this._expert != null && !this._expert.isLiteral() || this._shortDescription != null && !this._shortDescription.isLiteral() || this._hidden != null && !this._hidden.isLiteral())) {
            this._cacheable = true;
            if (this._required == null) {
                this._propertyDescriptor = this._createFacetPropertyDescriptor(this._name.getValue());
            }
        } else {
            this._cacheable = false;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (beanInfo == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
            }
            return;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        HashMap<String, PropertyDescriptor> facetPropertyDescriptorMap = (HashMap<String, PropertyDescriptor>)beanDescriptor.getValue("javax.faces.component.FACETS_KEY");
        if (facetPropertyDescriptorMap == null) {
            facetPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
            beanDescriptor.setValue("javax.faces.component.FACETS_KEY", facetPropertyDescriptorMap);
        }
        String facetName = this._name.getValue(ctx);
        if (this.isCacheable()) {
            if (this._propertyDescriptor == null) {
                this._propertyDescriptor = this._createFacetPropertyDescriptor(facetName, ctx, parent);
            }
            facetPropertyDescriptorMap.put(facetName, this._propertyDescriptor);
        } else {
            PropertyDescriptor facetDescriptor = this._createFacetPropertyDescriptor(facetName, ctx, parent);
            facetPropertyDescriptorMap.put(facetName, facetDescriptor);
        }
        this.nextHandler.apply(ctx, parent);
    }

    private PropertyDescriptor _createFacetPropertyDescriptor(String facetName) {
        try {
            CompositeComponentPropertyDescriptor facetPropertyDescriptor = new CompositeComponentPropertyDescriptor(facetName);
            if (this._displayName != null) {
                facetPropertyDescriptor.setDisplayName(this._displayName.getValue());
            }
            if (this._preferred != null) {
                facetPropertyDescriptor.setPreferred(Boolean.valueOf(this._preferred.getValue()));
            }
            if (this._expert != null) {
                facetPropertyDescriptor.setExpert(Boolean.valueOf(this._expert.getValue()));
            }
            if (this._shortDescription != null) {
                facetPropertyDescriptor.setShortDescription(this._shortDescription.getValue());
            }
            if (this._hidden != null) {
                facetPropertyDescriptor.setHidden(Boolean.valueOf(this._hidden.getValue()));
            }
            return facetPropertyDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for facet ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }

    private PropertyDescriptor _createFacetPropertyDescriptor(String facetName, FaceletContext ctx, UIComponent parent) throws TagException, IOException {
        try {
            CompositeComponentPropertyDescriptor facetPropertyDescriptor = new CompositeComponentPropertyDescriptor(facetName);
            if (this._displayName != null) {
                facetPropertyDescriptor.setDisplayName(this._displayName.getValue(ctx));
            }
            if (this._required != null) {
                facetPropertyDescriptor.setValue("required", this._required.getValueExpression(ctx, Boolean.class));
            }
            if (this._preferred != null) {
                facetPropertyDescriptor.setPreferred(this._preferred.getBoolean(ctx));
            }
            if (this._expert != null) {
                facetPropertyDescriptor.setExpert(this._expert.getBoolean(ctx));
            }
            if (this._shortDescription != null) {
                facetPropertyDescriptor.setShortDescription(this._shortDescription.getValue(ctx));
            }
            if (this._hidden != null) {
                facetPropertyDescriptor.setHidden(this._hidden.getBoolean(ctx));
            }
            return facetPropertyDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for attribute ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }

    public boolean isCacheable() {
        return this._cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this._cacheable = cacheable;
    }
}

