/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.lifecycle.RestoreViewSupport;
import org.apache.myfaces.shared_impl.application.InvalidViewIdException;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.util.Assert;

public class DefaultRestoreViewSupport
implements RestoreViewSupport {
    private static final String JAVAX_SERVLET_INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static final String JAVAX_SERVLET_INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    private static final String PORTLET_LIFECYCLE_PHASE = "javax.portlet.faces.phase";
    private static final String CACHED_SERVLET_MAPPING = DefaultRestoreViewSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private final Logger log = Logger.getLogger(DefaultRestoreViewSupport.class.getName());

    public void processComponentBinding(FacesContext facesContext, UIComponent component) {
        component.visitTree(VisitContext.createVisitContext((FacesContext)facesContext), (VisitCallback)new RestoreStateCallback());
    }

    public String calculateViewId(FacesContext facesContext) {
        Assert.notNull(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String viewId = null;
        boolean traceEnabled = this.log.isLoggable(Level.FINEST);
        if (requestMap.containsKey(PORTLET_LIFECYCLE_PHASE)) {
            viewId = externalContext.getRequestPathInfo();
        } else {
            viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_PATH_INFO);
            if (viewId != null) {
                if (traceEnabled) {
                    this.log.finest("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_PATH_INFO + "'");
                }
            } else {
                viewId = externalContext.getRequestPathInfo();
                if (viewId != null && traceEnabled) {
                    this.log.finest("Calculated viewId '" + viewId + "' from request path info");
                }
            }
            if (viewId == null && (viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_SERVLET_PATH)) != null && traceEnabled) {
                this.log.finest("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_SERVLET_PATH + "'");
            }
        }
        if (viewId == null && (viewId = externalContext.getRequestServletPath()) != null && traceEnabled) {
            this.log.finest("Calculated viewId '" + viewId + "' from request servlet path");
        }
        if (viewId == null) {
            throw new FacesException("Could not determine view id.");
        }
        return viewId;
    }

    public boolean isPostback(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String renderkitId = viewHandler.calculateRenderKitId(facesContext);
        ResponseStateManager rsm = RendererUtils.getResponseStateManager(facesContext, renderkitId);
        return rsm.isPostback(facesContext);
    }

    public String deriveViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            viewId = this.handlePrefixMapping(viewId, mapping.getPrefix());
        } else if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    protected String[] getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml .jsp";
        }
        return defaultSuffix.split(" ");
    }

    protected String getFaceletsContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
        return defaultSuffix;
    }

    protected String[] getFaceletsViewMappings(FacesContext context) {
        String faceletsViewMappings = context.getExternalContext().getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (faceletsViewMappings == null) {
            faceletsViewMappings = context.getExternalContext().getInitParameter("facelets.VIEWMAPPINGS");
        }
        return faceletsViewMappings == null ? null : faceletsViewMappings.split(";");
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        String uri = viewId;
        prefix = prefix + '/';
        while (uri.startsWith(prefix) || uri.startsWith("//")) {
            if (uri.startsWith(prefix)) {
                uri = uri.substring(prefix.length() - 1);
                continue;
            }
            uri = uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        String[] faceletsViewMappings = this.getFaceletsViewMappings(context);
        String[] jspDefaultSuffixes = this.getContextSuffix(context);
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        for (String defaultSuffix : jspDefaultSuffixes) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (faceletsViewMappings != null && faceletsViewMappings.length > 0) {
                for (String mapping : faceletsViewMappings) {
                    if (mapping.startsWith("/")) continue;
                    if (mapping.equals(candidateViewId)) {
                        return candidateViewId;
                    }
                    if (!mapping.startsWith(".")) continue;
                    builder.setLength(0);
                    builder.append(candidateViewId);
                    builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                    String tempViewId = builder.toString();
                    if (!this.checkResourceExists(context, tempViewId)) continue;
                    return tempViewId;
                }
            }
            if (!this.checkResourceExists(context, candidateViewId)) continue;
            return candidateViewId;
        }
        String faceletsDefaultSuffix = this.getFaceletsContextSuffix(context);
        StringBuilder builder = new StringBuilder(requestViewId);
        if (extensionPos > -1 && extensionPos > slashPos) {
            builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
        } else {
            builder.append(faceletsDefaultSuffix);
        }
        String candidateViewId = builder.toString();
        if (this.checkResourceExists(context, candidateViewId)) {
            return candidateViewId;
        }
        if (this.checkResourceExists(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    protected boolean checkResourceExists(FacesContext context, String viewId) {
        try {
            if (context.getExternalContext().getResource(viewId) != null) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = DefaultRestoreViewSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    protected static class FacesServletMapping {
        private String prefix;
        private String extension;

        protected FacesServletMapping() {
        }

        public static FacesServletMapping createPrefixMapping(String path) {
            FacesServletMapping mapping = new FacesServletMapping();
            mapping.setPrefix(path);
            return mapping;
        }

        public static FacesServletMapping createExtensionMapping(String extension) {
            FacesServletMapping mapping = new FacesServletMapping();
            mapping.setExtension(extension);
            return mapping;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String path) {
            this.prefix = path;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public boolean isExtensionMapping() {
            return this.extension != null;
        }

        public boolean isPrefixMapping() {
            return this.prefix != null;
        }

        public String getUrlPattern() {
            if (this.isExtensionMapping()) {
                return "*" + this.extension;
            }
            return this.prefix + "/*";
        }
    }

    private static class RestoreStateCallback
    implements VisitCallback {
        private PostRestoreStateEvent event;

        private RestoreStateCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this.event == null) {
                this.event = new PostRestoreStateEvent(target);
            } else {
                this.event.setComponent(target);
            }
            target.processEvent((ComponentSystemEvent)this.event);
            return VisitResult.ACCEPT;
        }
    }
}

