/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.callback.acknowledgement;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.CallbackListener;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.util.id.GUID;

public class CallbackAcknowledgeServer {
    public static final String APPLICATION_ACKNOWLDEGEMENTS = "applicationAcknowledgements";
    public static final String REMOTING_ACKNOWLDEGEMENTS = "remotingAcknowledgements";
    private static String transport = "socket";
    private static String host;
    private static int port;
    private Connector connector;

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            System.err.println("cannot get local host name");
            return;
        }
        String locatorURI = transport + "://" + host + ":" + port;
        CallbackAcknowledgeServer server = new CallbackAcknowledgeServer();
        try {
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void setupServer(String locatorURI) throws Exception {
        this.connector = new Connector(new InvokerLocator(locatorURI));
        this.connector.start();
        this.connector.addInvocationHandler("test", new TestInvoocationHandler());
    }

    static {
        port = 5401;
    }

    static class TestInvoocationHandler
    implements ServerInvocationHandler,
    CallbackListener {
        InvokerCallbackHandler callbackHandler;
        int counter;

        TestInvoocationHandler() {
        }

        @Override
        public void setMBeanServer(MBeanServer server) {
        }

        @Override
        public void setInvoker(ServerInvoker invoker) {
        }

        @Override
        public Object invoke(InvocationRequest invocation) throws Throwable {
            String command = (String)invocation.getParameter();
            System.out.println("command: " + command);
            Callback cb = new Callback("callback " + ++this.counter);
            HashMap<String, Object> returnPayload = new HashMap<String, Object>();
            returnPayload.put("callbackListener", this);
            returnPayload.put("callbackId", new GUID());
            cb.setReturnPayload(returnPayload);
            if (CallbackAcknowledgeServer.REMOTING_ACKNOWLDEGEMENTS.equals(command)) {
                returnPayload.put("remotingAcknowledgesPushCallbacks", "true");
            }
            this.callbackHandler.handleCallback(cb);
            return null;
        }

        @Override
        public void addListener(InvokerCallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        @Override
        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        @Override
        public void acknowledgeCallback(InvokerCallbackHandler callbackHandler, Object callbackId, Object response) {
            System.out.println("received acknowledgment for callback: " + callbackId);
            System.out.println("response: " + response);
            System.out.println("");
        }
    }
}

