/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.OutdatedSessionChecker;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.persistent.ExtendedDistributedCacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionBasedOutdatedSessionChecker
implements OutdatedSessionChecker {
    private final ExtendedDistributedCacheManager<? extends OutgoingDistributableSessionData> manager;

    public VersionBasedOutdatedSessionChecker(ExtendedDistributedCacheManager<? extends OutgoingDistributableSessionData> manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        this.manager = manager;
    }

    @Override
    public boolean isSessionOutdated(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
        boolean result = true;
        String realId = session.getRealId();
        Integer version = this.manager.getSessionVersion(realId);
        if (version != null) {
            session.setVersionFromDistributedCache(version);
            result = session.isOutdated();
        } else {
            result = session.getLastReplicated() > 0L;
        }
        return result;
    }
}

